/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.rdfizers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import net.fortytwo.linkeddata.CacheEntry;
import net.fortytwo.linkeddata.Rdfizer;
import org.openrdf.rio.RDFHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageRdfizer
implements Rdfizer {
    private static final Logger logger = LoggerFactory.getLogger(ImageRdfizer.class);
    private static boolean initialized = false;

    private static void initialize() {
        ImageIO.setUseCache(false);
        ImageIO.scanForPlugins();
        initialized = true;
    }

    @Override
    public CacheEntry.Status rdfize(InputStream is, RDFHandler handler, String baseUri) {
        if (!initialized) {
            ImageRdfizer.initialize();
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(is);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                reader.setInput(iis);
                System.out.println("[Trace] Image Reader : " + reader);
                System.out.println("[Trace] Image Format Name : " + reader.getFormatName());
                System.out.println("[Trace] Input : " + reader.getInput());
                IIOMetadata metadata = reader.getImageMetadata(0);
                String[] names = metadata.getMetadataFormatNames();
                for (int i = 0; i < names.length; ++i) {
                    System.out.println("[Trace] MetadataFormat Name " + i + " : " + names[i]);
                    Node node = metadata.getAsTree(names[i]);
                    try {
                        StringBuilder sb = new StringBuilder();
                        ImageRdfizer.showNode(node, sb, "");
                        System.out.println(sb);
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                return CacheEntry.Status.Success;
            }
            logger.warn("could not find a reader for image");
            return CacheEntry.Status.RdfizerError;
        }
        catch (IOException e) {
            logger.error("image rdfization error", (Throwable)e);
            return CacheEntry.Status.RdfizerError;
        }
    }

    private static void showNode(Node node, StringBuilder sb, String indent) {
        sb.append(indent).append(node.getLocalName());
        indent = indent + "    ";
        NamedNodeMap map = node.getAttributes();
        if (0 < map.getLength()) {
            sb.append(" {");
            for (int i = 0; i < map.getLength(); ++i) {
                if (0 < i) {
                    sb.append(", ");
                }
                Node n = map.item(i);
                sb.append(n.getNodeName()).append("=").append(n.getNodeValue());
            }
            sb.append("}");
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            sb.append("\n");
            ImageRdfizer.showNode(n, sb, indent);
        }
    }

    public String toString() {
        return "image rdfizer";
    }
}

