/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.dereferencers;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.fortytwo.linkeddata.Dereferencer;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.linkeddata.RedirectManager;
import net.fortytwo.linkeddata.dereferencers.HTTPRepresentation;
import net.fortytwo.linkeddata.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.restlet.representation.Representation;

public class HTTPURIDereferencer
implements Dereferencer {
    private static final Logger logger = Logger.getLogger(HTTPURIDereferencer.class);
    private final LinkedDataCache linkedDataCache;
    private final RedirectManager redirectManager;
    private final Set<String> badExtensions;

    public HTTPURIDereferencer(LinkedDataCache linkedDataCache, RedirectManager redirectManager) {
        this.linkedDataCache = linkedDataCache;
        this.redirectManager = redirectManager;
        this.badExtensions = new HashSet<String>();
    }

    @Override
    public Representation dereference(String uri) {
        int l = uri.lastIndexOf(46);
        if (l >= 0 && this.badExtensions.contains(uri.substring(l + 1))) {
            throw new IllegalArgumentException("URI <" + StringUtils.escapeURIString(uri) + "> has blacklisted extension");
        }
        try {
            return new HTTPRepresentation(uri, this.redirectManager, this.linkedDataCache.getAcceptHeader());
        }
        catch (HTTPRepresentation.RedirectToExistingDocumentException e) {
            return null;
        }
        catch (IOException e) {
            logger.log((Priority)Level.ERROR, (Object)("failed to dereference URI " + uri), (Throwable)e);
            return null;
        }
    }

    public void blackListExtension(String ext) {
        this.badExtensions.add(ext);
    }

    public void whitelistExtension(String ext) {
        this.badExtensions.remove(ext);
    }

    public String toString() {
        return "HTTP URI dereferencer";
    }
}

