/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.dereferencers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.linkeddata.RedirectManager;
import net.fortytwo.linkeddata.util.HTTPUtils;
import net.fortytwo.linkeddata.util.RDFUtils;
import net.fortytwo.linkeddata.util.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.openrdf.sail.SailException;
import org.restlet.data.MediaType;
import org.restlet.representation.StreamRepresentation;

public class HTTPRepresentation
extends StreamRepresentation {
    private static final Logger logger = Logger.getLogger(HTTPRepresentation.class.getName());
    private InputStream inputStream;
    private HttpUriRequest method;
    private static final HttpClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPRepresentation(String iri, RedirectManager redirects, String acceptHeader) throws IOException {
        HttpResponse response;
        block18: {
            URL getUrl;
            super(null);
            try {
                getUrl = RDFUtils.iriToUrl(iri);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
            String redirectUrl = null;
            try {
                block17: {
                    int code;
                    while (true) {
                        this.method = HTTPUtils.createGetMethod(getUrl.toString());
                        HTTPUtils.setAcceptHeader((HttpRequest)this.method, acceptHeader);
                        long idleTime = HTTPUtils.throttleHttpRequest((HttpRequest)this.method);
                        response = client.execute(this.method);
                        code = response.getStatusLine().getStatusCode();
                        int c = code / 100;
                        if (2 == c) break block17;
                        if (3 != c) break;
                        redirectUrl = response.getFirstHeader("Location").getValue();
                        if (redirects.existsRedirectTo(redirectUrl)) {
                            throw new RedirectToExistingDocumentException();
                        }
                        this.method.abort();
                        try {
                            getUrl = new URL(redirectUrl);
                        }
                        catch (MalformedURLException e) {
                            throw new IOException(e);
                        }
                    }
                    throw new ErrorResponseException("" + code + " response for resource <" + StringUtils.escapeURIString(iri) + ">");
                }
                this.method = null;
                if (null == redirectUrl) break block18;
            }
            catch (Throwable throwable) {
                if (null != redirectUrl) {
                    try {
                        redirects.persistRedirect(iri, redirectUrl);
                    }
                    catch (SailException e) {
                        throw new IOException(e);
                    }
                }
                if (this.method != null) {
                    this.method.abort();
                    this.method = null;
                }
                throw throwable;
            }
            try {
                redirects.persistRedirect(iri, redirectUrl);
            }
            catch (SailException e) {
                throw new IOException(e);
            }
        }
        if (this.method != null) {
            this.method.abort();
            this.method = null;
        }
        InputStream is = response.getEntity().getContent();
        this.inputStream = new HttpRepresentationInputStream(is);
        Header h = response.getFirstHeader("Content-Type");
        if (null == h) {
            throw new InvalidResponseException("no content-type header served for resource <" + StringUtils.escapeURIString(iri) + ">");
        }
        String mtStr = h.getValue().split(";")[0];
        if (null == mtStr || 0 == mtStr.length()) {
            throw new InvalidResponseException("no media type found for resource <" + StringUtils.escapeURIString(iri) + ">");
        }
        MediaType mt = new MediaType(mtStr);
        this.setMediaType(mt);
    }

    public ReadableByteChannel getChannel() throws IOException {
        return null;
    }

    public InputStream getStream() throws IOException {
        return this.inputStream;
    }

    public void write(OutputStream outputStream) throws IOException {
    }

    public void write(WritableByteChannel writableByteChannel) throws IOException {
    }

    static {
        try {
            client = HTTPUtils.createClient(false);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "failed to initialize", e);
            throw new ExceptionInInitializerError(e);
        }
    }

    public class RedirectToExistingDocumentException
    extends HTTPException {
    }

    public class InvalidResponseException
    extends HTTPException {
        public InvalidResponseException(String message) {
            super(message);
        }
    }

    public class ErrorResponseException
    extends HTTPException {
        public ErrorResponseException(String message) {
            super(message);
        }
    }

    public class HTTPException
    extends IOException {
        public HTTPException() {
        }

        public HTTPException(String message) {
            super(message);
        }
    }

    private class HttpRepresentationInputStream
    extends InputStream {
        private final InputStream innerInputStream;

        public HttpRepresentationInputStream(InputStream is) {
            this.innerInputStream = is;
        }

        @Override
        public int read() throws IOException {
            return this.innerInputStream.read();
        }

        @Override
        public void close() throws IOException {
            if (null != HTTPRepresentation.this.method) {
                HTTPRepresentation.this.method.abort();
            }
            this.innerInputStream.close();
        }

        @Override
        public int available() throws IOException {
            return this.innerInputStream.available();
        }
    }
}

