/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata;

import info.aduna.iteration.CloseableIteration;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.linkeddata.util.RDFUtils;
import org.openrdf.model.IRI;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class RedirectManager {
    private static final ValueFactory valueFactory = SimpleValueFactory.getInstance();
    private final SailConnection connection;

    public RedirectManager(SailConnection connection) {
        this.connection = connection;
    }

    public boolean existsRedirectTo(String documentUri) throws SailException {
        IRI hashedDocumentUri = valueFactory.createIRI(RDFUtils.hashedUri(documentUri));
        try (CloseableIteration iter = this.connection.getStatements(null, LinkedDataCache.CACHE_REDIRECTSTO, (Value)hashedDocumentUri, false, new Resource[0]);){
            boolean bl = iter.hasNext();
            return bl;
        }
    }

    public void persistRedirect(String thingUri, String documentUri) throws SailException {
        IRI hashedThingUri = valueFactory.createIRI(RDFUtils.hashedUri(thingUri));
        IRI hashedDocumentUri = valueFactory.createIRI(RDFUtils.hashedUri(documentUri));
        this.connection.removeStatements((Resource)hashedThingUri, LinkedDataCache.CACHE_REDIRECTSTO, null, new Resource[0]);
        this.connection.addStatement((Resource)hashedThingUri, LinkedDataCache.CACHE_REDIRECTSTO, (Value)hashedDocumentUri, new Resource[0]);
        this.connection.commit();
        this.connection.begin();
    }
}

