/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fortytwo.linkeddata.BNodeToURIFilter;
import net.fortytwo.linkeddata.CacheEntry;
import net.fortytwo.linkeddata.CacheExpirationPolicy;
import net.fortytwo.linkeddata.CachingMetadata;
import net.fortytwo.linkeddata.Dereferencer;
import net.fortytwo.linkeddata.Rdfizer;
import net.fortytwo.linkeddata.RedirectManager;
import net.fortytwo.linkeddata.dereferencers.FileURIDereferencer;
import net.fortytwo.linkeddata.dereferencers.HTTPURIDereferencer;
import net.fortytwo.linkeddata.dereferencers.JarURIDereferencer;
import net.fortytwo.linkeddata.rdfizers.ImageRdfizer;
import net.fortytwo.linkeddata.rdfizers.VerbatimRdfizer;
import net.fortytwo.linkeddata.sail.LinkedDataSail;
import net.fortytwo.linkeddata.util.RDFUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.openrdf.model.IRI;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;

public class LinkedDataCache {
    private static final Logger logger = Logger.getLogger(LinkedDataCache.class);
    private static final ValueFactory constValueFactory = SimpleValueFactory.getInstance();
    private static final String CACHE_NS = "http://fortytwo.net/2012/02/linkeddata#";
    public static final IRI CACHE_MEMO = constValueFactory.createIRI("http://fortytwo.net/2012/02/linkeddata#memo");
    public static final IRI CACHE_REDIRECTSTO = constValueFactory.createIRI("http://fortytwo.net/2012/02/linkeddata#redirectsTo");
    public static final IRI CACHE_GRAPH = null;
    private static final String[] NON_RDF_EXTENSIONS = new String[]{"123", "3dm", "3dmf", "3gp", "8bi", "aac", "ai", "aif", "app", "asf", "asp", "asx", "avi", "bat", "bin", "bmp", "c", "cab", "cfg", "cgi", "com", "cpl", "cpp", "css", "csv", "dat", "db", "dll", "dmg", "dmp", "doc", "drv", "drw", "dxf", "eps", "exe", "fnt", "fon", "gif", "gz", "h", "hqx", "iff", "indd", "ini", "iso", "java", "js", "jsp", "key", "log", "m3u", "mdb", "mid", "midi", "mim", "mng", "mov", "mp3", "mp4", "mpa", "mpg", "msg", "msi", "otf", "pct", "pdf", "php", "pif", "pkg", "pl", "plugin", "png", "pps", "ppt", "ps", "psd", "psp", "qt", "qxd", "qxp", "ra", "ram", "rar", "reg", "rm", "rtf", "sea", "sit", "sitx", "sql", "svg", "swf", "sys", "tar", "tif", "ttf", "uue", "vb", "vcd", "wav", "wks", "wma", "wmv", "wpd", "wps", "ws", "xll", "xls", "yps", "zip"};
    private static final int MINIMUM_CAPACITY = 100;
    private final CachingMetadata metadata;
    private final ValueFactory valueFactory;
    private final boolean useBlankNodes;
    private boolean autoCommit = true;
    private boolean derefSubjects = true;
    private boolean derefPredicates = false;
    private boolean derefObjects = true;
    private boolean derefContexts = false;
    private String acceptHeader = null;
    private CacheExpirationPolicy expirationPolicy;
    private final Map<MediaType, MediaTypeInfo> rdfizers = new HashMap<MediaType, MediaTypeInfo>();
    private final Map<String, Dereferencer> dereferencers = new HashMap<String, Dereferencer>();
    private DataStore dataStore;
    private final SailConnection sailConnection;

    public static LinkedDataCache createDefault(Sail sail) {
        RDFParser.DatatypeHandling datatypeHandling;
        LinkedDataCache cache = new LinkedDataCache(sail);
        RedirectManager redirectManager = new RedirectManager(cache.getSailConnection());
        HTTPURIDereferencer hdref = new HTTPURIDereferencer(cache, redirectManager);
        for (String x : NON_RDF_EXTENSIONS) {
            hdref.blackListExtension(x);
        }
        cache.addDereferencer("http", hdref);
        cache.addDereferencer("file", new FileURIDereferencer());
        cache.addDereferencer("jar", new JarURIDereferencer());
        String p = LinkedDataSail.getProperty("net.fortytwo.linkeddata.datatypeHandlingPolicy", "ignore");
        Object object = p.equals("ignore") ? RDFParser.DatatypeHandling.IGNORE : (p.equals("verify") ? RDFParser.DatatypeHandling.VERIFY : (datatypeHandling = p.equals("normalize") ? RDFParser.DatatypeHandling.NORMALIZE : null));
        if (null == datatypeHandling) {
            throw new IllegalStateException("no such datatype handling policy: " + p);
        }
        LinkedList tmp = new LinkedList();
        tmp.addAll(RDFParserRegistry.getInstance().getKeys());
        for (RDFFormat f : tmp) {
            VerbatimRdfizer r = new VerbatimRdfizer(f, datatypeHandling);
            for (String type : f.getMIMETypes()) {
                double qualityFactor = type.equals("application/rdf+xml") ? 1.0 : 0.5;
                cache.addRdfizer(new MediaType(type), r, qualityFactor);
            }
        }
        ImageRdfizer imageRdfizer = new ImageRdfizer();
        cache.addRdfizer(MediaType.IMAGE_JPEG, imageRdfizer, 0.4);
        cache.addRdfizer(new MediaType("image/tiff"), imageRdfizer, 0.4);
        cache.addRdfizer(new MediaType("image/tiff-fx"), imageRdfizer, 0.4);
        return cache;
    }

    private LinkedDataCache(Sail sail) {
        this.sailConnection = sail.getConnection();
        this.sailConnection.begin();
        int capacity = Integer.valueOf(LinkedDataSail.getProperty("net.fortytwo.linkeddata.memoryCacheCapacity", "10000"));
        if (capacity < 100) {
            logger.log((Priority)Level.WARN, (Object)"LinkedDataSail.MEMORY_CACHE_CAPACITY is suspiciously low. Using 100");
        }
        this.metadata = new CachingMetadata(capacity, sail.getValueFactory());
        this.valueFactory = sail.getValueFactory();
        this.useBlankNodes = Boolean.valueOf(LinkedDataSail.getProperty("net.fortytwo.linkeddata.useBlankNodes", "false"));
        this.expirationPolicy = new DefaultCacheExpirationPolicy();
        this.dataStore = sc -> new SesameOutputAdapter(new SailInserter(sc));
    }

    public synchronized void clear() {
        this.metadata.clear();
        SailConnection sc = this.getSailConnection();
        sc.clear(new Resource[0]);
        sc.commit();
        sc.begin();
    }

    public synchronized void close() {
        SailConnection sc = this.getSailConnection();
        if (null != sc) {
            sc.close();
        }
    }

    public synchronized SailConnection getSailConnection() {
        return this.sailConnection;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public String getAcceptHeader() {
        if (null == this.acceptHeader) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            Comparator comparator = (first1, second) -> first1.quality < second.quality ? 1 : (first1.quality > second.quality ? -1 : 0);
            MediaTypeInfo[] array = new MediaTypeInfo[this.rdfizers.size()];
            this.rdfizers.values().toArray(array);
            Arrays.sort(array, comparator);
            for (MediaTypeInfo m : array) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(m.mediaType.getName());
                double quality = m.quality;
                if (1.0 == quality) continue;
                sb.append(";q=").append(quality);
            }
            this.acceptHeader = sb.toString();
        }
        return this.acceptHeader;
    }

    private void addRdfizer(MediaType mediaType, Rdfizer rdfizer, double qualityFactor) {
        logger.info((Object)("adding RDFizer for media type " + mediaType + ": " + rdfizer));
        if (qualityFactor <= 0.0 || qualityFactor > 1.0) {
            throw new IllegalArgumentException("quality factor must be between 0 and 1");
        }
        if (null != this.rdfizers.get(mediaType)) {
            logger.warn((Object)("overriding already-registered RDFizer for media type " + mediaType));
        }
        MediaTypeInfo rq = new MediaTypeInfo();
        rq.mediaType = mediaType;
        rq.quality = qualityFactor;
        rq.rdfizer = rdfizer;
        this.rdfizers.put(mediaType, rq);
        this.acceptHeader = null;
    }

    private void addDereferencer(String scheme, Dereferencer dref) {
        logger.info((Object)("adding dereferencer for for IRI scheme " + scheme + ": " + dref));
        this.dereferencers.put(scheme, dref);
    }

    public CacheEntry.Status peek(IRI iri, SailConnection sc) throws IOException {
        return this.peekOrRetrieve(iri, sc, false);
    }

    public CacheEntry.Status retrieve(IRI iri, SailConnection sc) throws IOException {
        return this.peekOrRetrieve(iri, sc, true);
    }

    private synchronized CacheEntry getSetMemo(IRI uri, String graphUri, SailConnection sc, boolean doRetrieve) {
        CacheEntry memo = this.metadata.getMemo(graphUri, sc);
        if (null != memo && !this.expirationPolicy.isExpired(memo)) {
            return memo;
        }
        if (!doRetrieve) {
            return null;
        }
        memo = new CacheEntry(CacheEntry.Status.Undetermined);
        this.metadata.setMemo(graphUri, memo, null);
        memo.setStatus(CacheEntry.Status.CacheLookup);
        return memo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry.Status peekOrRetrieve(IRI uri, SailConnection sc, boolean doRetrieve) throws IOException {
        Dereferencer dref;
        CacheEntry.Status status;
        String graphUri = RDFUtils.findGraphUri(uri.toString());
        CacheEntry memo = this.getSetMemo(uri, graphUri, sc, doRetrieve);
        CacheEntry.Status status2 = status = null == memo ? null : memo.getStatus();
        if (null == status || status != CacheEntry.Status.CacheLookup) {
            return status;
        }
        memo.setStatus(CacheEntry.Status.Undetermined);
        String retrievalUri = RDFUtils.removeFragmentIdentifier(uri.toString());
        try {
            dref = this.chooseDereferencer(retrievalUri);
        }
        catch (URISyntaxException e) {
            return CacheEntry.Status.InvalidUri;
        }
        if (null == dref) {
            return CacheEntry.Status.BadUriScheme;
        }
        logger.info((Object)("dereferencing <" + uri.toString() + ">"));
        memo.setDereferencer(dref.getClass().getName());
        try {
            memo.setStatus(CacheEntry.Status.DereferencerError);
            Representation rep = dref.dereference(retrievalUri);
            if (null == rep) {
                memo.setStatus(CacheEntry.Status.RedirectsToCached);
                CacheEntry.Status status3 = memo.getStatus();
                return status3;
            }
            memo.setMediaType(rep.getMediaType());
            Rdfizer rfiz = this.chooseRdfizer(memo.getMediaType());
            if (null == rfiz) {
                memo.setStatus(CacheEntry.Status.BadMediaType);
                CacheEntry.Status status4 = this.logStatus(uri, memo);
                return status4;
            }
            memo.setRdfizer(rfiz.getClass().getName());
            Consumer<Statement> adder = this.dataStore.createConsumer(sc);
            Buffer<Statement> buffer = new Buffer<Statement>(adder);
            SingleContextPipe pipe = new SingleContextPipe(buffer, (Resource)this.valueFactory.createIRI(graphUri));
            SesameInputAdapter handler = new SesameInputAdapter(this.useBlankNodes ? pipe : new BNodeToURIFilter(pipe, this.valueFactory));
            InputStream is = rep.getStream();
            String baseUri = uri.getNamespace();
            memo.setStatus(rfiz.rdfize(is, handler, baseUri));
            if (CacheEntry.Status.Success == memo.getStatus()) {
                sc.removeStatements(null, null, null, new Resource[]{this.valueFactory.createIRI(graphUri)});
                buffer.flush();
            }
        }
        finally {
            this.metadata.setMemo(graphUri, memo, sc);
            if (this.autoCommit) {
                sc.commit();
                sc.begin();
            }
            this.logStatus(uri, memo);
        }
        return memo.getStatus();
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setExpirationPolicy(CacheExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }

    public boolean getDereferenceSubjects() {
        return this.derefSubjects;
    }

    public void setDereferenceSubjects(boolean flag) {
        this.derefSubjects = flag;
    }

    public boolean getDereferencePredicates() {
        return this.derefPredicates;
    }

    public void setDereferencePredicates(boolean flag) {
        this.derefPredicates = flag;
    }

    public boolean getDereferenceObjects() {
        return this.derefObjects;
    }

    public void setDereferenceObjects(boolean flag) {
        this.derefObjects = flag;
    }

    public boolean getDereferenceContexts() {
        return this.derefContexts;
    }

    public void setDereferenceContexts(boolean flag) {
        this.derefContexts = flag;
    }

    private CacheEntry.Status logStatus(IRI uri, CacheEntry memo) {
        CacheEntry.Status status = memo.getStatus();
        if (CacheEntry.Status.Success != status && CacheEntry.Status.RedirectsToCached != status) {
            StringBuilder msg = new StringBuilder("Failed to dereference IRI <" + uri.toString() + "> (");
            msg.append("dereferencer: ").append(memo.getDereferencer());
            msg.append(", media type: ").append(memo.getMediaType());
            msg.append(", rdfizer: ").append(memo.getRdfizer());
            msg.append("): ").append((Object)status);
            logger.info((Object)msg);
        }
        return status;
    }

    private Dereferencer chooseDereferencer(String uri) throws URISyntaxException {
        String scheme = new URI(uri).getScheme();
        return this.dereferencers.get(scheme);
    }

    private Rdfizer chooseRdfizer(MediaType mediaType) {
        MediaTypeInfo rq = this.rdfizers.get(mediaType);
        return null == rq ? null : rq.rdfizer;
    }

    private class SesameOutputAdapter
    implements Consumer<Statement> {
        private final RDFHandler handler;

        public SesameOutputAdapter(RDFHandler handler) {
            this.handler = handler;
        }

        @Override
        public void accept(Statement st) {
            this.handler.handleStatement(st);
        }
    }

    public class SailInserter
    extends StatementConsumerRDFHandler {
        private final SailConnection sailConnection;

        public SailInserter(SailConnection sailConnection) {
            this.sailConnection = sailConnection;
        }

        public void handleStatement(Statement st) throws RDFHandlerException {
            try {
                this.sailConnection.addStatement(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[]{st.getContext()});
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }
    }

    private class SesameInputAdapter
    extends StatementConsumerRDFHandler {
        private final Consumer<Statement> stSink;

        public SesameInputAdapter(Consumer<Statement> stSink) {
            this.stSink = stSink;
        }

        public void handleStatement(Statement st) {
            this.stSink.accept(st);
        }
    }

    private abstract class StatementConsumerRDFHandler
    implements RDFHandler {
        private StatementConsumerRDFHandler() {
        }

        public void handleComment(String comment) {
        }

        public void handleNamespace(String prefix, String uri) {
        }

        public void startRDF() {
        }

        public void endRDF() {
        }
    }

    private class Buffer<T>
    implements Consumer<T> {
        private final Consumer<T> wrapped;
        private final List<T> buffer = new LinkedList<T>();

        public Buffer(Consumer<T> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void accept(T t) {
            this.buffer.add(t);
        }

        public void flush() {
            this.buffer.forEach(this.wrapped::accept);
            this.buffer.clear();
        }
    }

    private class SingleContextPipe
    implements Consumer<Statement> {
        private final Consumer<Statement> stSink;
        private final Resource context;

        public SingleContextPipe(Consumer<Statement> stSink, Resource context) {
            this.stSink = stSink;
            this.context = context;
        }

        @Override
        public void accept(Statement st) {
            Statement newSt = LinkedDataCache.this.valueFactory.createStatement(st.getSubject(), st.getPredicate(), st.getObject(), this.context);
            this.stSink.accept(newSt);
        }
    }

    public static interface DataStore {
        public Consumer<Statement> createConsumer(SailConnection var1);
    }

    private class MediaTypeInfo {
        MediaType mediaType;
        public double quality;
        public Rdfizer rdfizer;

        private MediaTypeInfo() {
        }
    }

    private class DefaultCacheExpirationPolicy
    implements CacheExpirationPolicy {
        private final long cacheLifetime = Long.valueOf(LinkedDataSail.getProperty("net.fortytwo.linkeddata.cacheLifetime", "604800")) * 1000L;

        @Override
        public boolean isExpired(CacheEntry entry) {
            Date last = entry.getTimestamp();
            return null != last && System.currentTimeMillis() - last.getTime() >= this.cacheLifetime;
        }
    }
}

