/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.restlet.data.MediaType;

public class CacheEntry {
    private static final String DEREFERENCER = "dereferencer";
    private static final String MEDIATYPE = "mediaType";
    private static final String RDFIZER = "rdfizer";
    private static final String STATUS = "status";
    private static final String TIMESTAMP = "timestamp";
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
    private Status status;
    private Date timestamp;
    private MediaType mediaType;
    private String dereferencer;
    private String rdfizer;

    public CacheEntry(Status status) {
        this.status = status;
        this.timestamp = new Date();
    }

    public CacheEntry(String keyValues) {
        String[] props;
        for (String prop : props = keyValues.split(",")) {
            int eq = prop.indexOf(61);
            String key = prop.substring(0, eq);
            String value = prop.substring(eq + 1);
            try {
                this.addEntry(key, value);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public String getDereferencer() {
        return this.dereferencer;
    }

    public String getRdfizer() {
        return this.rdfizer;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    private Map<String, String> getKeyValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != this.status) {
            map.put(STATUS, this.status.toString());
        }
        if (null != this.timestamp) {
            map.put(TIMESTAMP, TIMESTAMP_FORMAT.format(this.timestamp));
        }
        if (null != this.mediaType) {
            map.put(MEDIATYPE, this.mediaType.toString());
        }
        if (null != this.dereferencer) {
            map.put(DEREFERENCER, this.dereferencer);
        }
        if (null != this.rdfizer) {
            map.put(RDFIZER, this.rdfizer);
        }
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.getKeyValues().entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setMediaType(MediaType mt) {
        this.mediaType = mt;
    }

    public void setDereferencer(String dref) {
        this.dereferencer = dref;
    }

    public void setRdfizer(String rfiz) {
        this.rdfizer = rfiz;
    }

    private void addEntry(String key, String value) throws ParseException {
        switch (key) {
            case "status": {
                this.status = Status.valueOf(value);
                break;
            }
            case "timestamp": {
                this.timestamp = TIMESTAMP_FORMAT.parse(value);
                break;
            }
            case "mediaType": {
                this.mediaType = new MediaType(value);
                break;
            }
            case "dereferencer": {
                this.dereferencer = value;
                break;
            }
            case "rdfizer": {
                this.rdfizer = value;
            }
        }
    }

    public static enum Status {
        BadMediaType,
        BadUriScheme,
        CacheLookup,
        ClientError,
        DereferencerError,
        Failure,
        Ignored,
        InvalidUri,
        ParseError,
        RdfizerError,
        RedirectsToCached,
        ServerError,
        Success,
        Timeout,
        Undetermined;

    }
}

