/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata;

import java.util.function.Consumer;
import org.openrdf.model.BNode;
import org.openrdf.model.IRI;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class BNodeToURIFilter
implements Consumer<Statement> {
    private final Consumer<Statement> wrapped;
    private final ValueFactory valueFactory;

    public BNodeToURIFilter(Consumer<Statement> wrapped, ValueFactory vf) {
        this.valueFactory = vf;
        this.wrapped = wrapped;
    }

    private IRI bnodeToUri(BNode bnode) {
        return this.valueFactory.createIRI("urn:uuid:" + bnode.getID());
    }

    @Override
    public void accept(Statement st) {
        boolean c;
        boolean s = st.getSubject() instanceof BNode;
        boolean o = st.getObject() instanceof BNode;
        boolean bl = c = null != st.getContext() && st.getContext() instanceof BNode;
        if (s || o || c) {
            Resource subj = s ? this.bnodeToUri((BNode)st.getSubject()) : st.getSubject();
            IRI pred = st.getPredicate();
            Value obj = o ? this.bnodeToUri((BNode)st.getObject()) : st.getObject();
            Resource con = c ? this.bnodeToUri((BNode)st.getContext()) : st.getContext();
            Statement newSt = null == con ? this.valueFactory.createStatement(subj, pred, obj) : this.valueFactory.createStatement(subj, pred, obj, con);
            this.wrapped.accept(newSt);
        } else {
            this.wrapped.accept(st);
        }
    }
}

