/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata;

import info.aduna.iteration.CloseableIteration;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.linkeddata.sail.LinkedDataSail;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openrdf.model.IRI;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.memory.MemoryStore;

public class LinkedDataSailIT {
    private static final ValueFactory valueFactory = SimpleValueFactory.getInstance();
    private Sail baseSail;
    private LinkedDataSail sail;

    @Before
    public void setUp() {
        this.baseSail = new MemoryStore();
        this.baseSail.initialize();
        LinkedDataCache wc = LinkedDataCache.createDefault((Sail)this.baseSail);
        this.sail = new LinkedDataSail(this.baseSail, wc);
        this.sail.initialize();
    }

    @After
    public void tearDown() {
        this.sail.shutDown();
        this.baseSail.shutDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDereferencer() throws Exception {
        boolean includeInferred = false;
        ValueFactory vf = this.sail.getValueFactory();
        IRI tagging = vf.createIRI("http://www.holygoat.co.uk/owl/redwood/0.1/tags/Tagging");
        NotifyingSailConnection sc = this.sail.getConnection();
        try {
            sc.begin();
            long count = LinkedDataSailIT.countStatements((CloseableIteration<? extends Statement, SailException>)sc.getStatements((Resource)tagging, RDF.TYPE, null, includeInferred, new Resource[0]));
            Assert.assertEquals((long)1L, (long)count);
        }
        finally {
            sc.rollback();
            sc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountStatements() throws Exception {
        ValueFactory vf = this.sail.getValueFactory();
        IRI ctxA = vf.createIRI("urn:org.example.test.countStatementsTest#");
        IRI uri1 = vf.createIRI("urn:org.example.test#uri1");
        IRI uri2 = vf.createIRI("urn:org.example.test#uri2");
        IRI uri3 = vf.createIRI("urn:org.example.test#uri3");
        IRI[] uris = new IRI[]{uri1, uri2, uri3};
        try (SailConnection sc = this.baseSail.getConnection();){
            sc.begin();
            Assert.assertEquals((long)0L, (long)LinkedDataSailIT.countStatements(sc, new Resource[]{ctxA}));
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        sc.addStatement((Resource)uris[i], uris[j], (Value)uris[k], new Resource[]{ctxA});
                    }
                }
            }
            sc.commit();
        }
        sc = this.sail.getConnection();
        try {
            sc.begin();
            Assert.assertEquals((long)27L, (long)LinkedDataSailIT.countStatements(sc, new Resource[]{ctxA}));
        }
        finally {
            sc.rollback();
            sc.close();
        }
    }

    private static long countStatements(CloseableIteration<? extends Statement, SailException> iter) throws SailException {
        long count;
        try {
            count = 0L;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
        }
        finally {
            iter.close();
        }
        return count;
    }

    private static long countStatements(SailConnection sc, Resource ... contexts) throws SailException {
        return LinkedDataSailIT.countStatements((CloseableIteration<? extends Statement, SailException>)sc.getStatements(null, null, null, false, contexts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        MemoryStore baseSail = new MemoryStore();
        baseSail.initialize();
        try {
            SailRepository repo = new SailRepository((Sail)baseSail);
            LinkedDataSail sail = new LinkedDataSail((Sail)baseSail);
            sail.initialize();
            try (NotifyingSailConnection sc = sail.getConnection();){
                sc.begin();
                sc.getStatements((Resource)valueFactory.createIRI("http://rdf.freebase.com/rdf/en.stephen_fry"), null, null, false, new Resource[0]);
                sc.commit();
            }
            finally {
                sail.shutDown();
            }
            try (RepositoryConnection rc = repo.getConnection();){
                rc.export(new RDFHandler(){

                    public void startRDF() throws RDFHandlerException {
                    }

                    public void endRDF() throws RDFHandlerException {
                    }

                    public void handleNamespace(String s, String s1) throws RDFHandlerException {
                    }

                    public void handleStatement(Statement statement) throws RDFHandlerException {
                        System.out.println("" + statement);
                    }

                    public void handleComment(String s) throws RDFHandlerException {
                    }
                }, new Resource[0]);
            }
        }
        finally {
            baseSail.shutDown();
        }
    }
}

