/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.sail;

import info.aduna.iteration.CloseableIteration;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.linkeddata.sail.SailConnectionTripleSource;
import net.fortytwo.ripple.RippleException;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UpdateExpr;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;

public class LinkedDataSailConnection
implements NotifyingSailConnection {
    private final ValueFactory valueFactory;
    private final LinkedDataCache linkedDataCache;
    private boolean open = false;
    private SailConnection baseConnection;

    public synchronized void addConnectionListener(SailConnectionListener listener) {
        if (this.baseConnection instanceof NotifyingSailConnection) {
            ((NotifyingSailConnection)this.baseConnection).addConnectionListener(listener);
        }
    }

    public void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.baseConnection.addStatement(subj, pred, obj, contexts);
    }

    public void clear(Resource ... contexts) throws SailException {
        this.baseConnection.clear(contexts);
    }

    public void clearNamespaces() throws SailException {
        this.baseConnection.clearNamespaces();
    }

    public synchronized void close() throws SailException {
        this.baseConnection.close();
        this.open = false;
    }

    public void commit() throws SailException {
        this.baseConnection.commit();
    }

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        try {
            SailConnectionTripleSource tripleSource = new SailConnectionTripleSource((SailConnection)this, this.valueFactory, includeInferred);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource, dataset);
            return strategy.evaluate(tupleExpr, bindings);
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    public void executeUpdate(UpdateExpr updateExpr, Dataset dataset, BindingSet bindingSet, boolean b) throws SailException {
        this.baseConnection.executeUpdate(updateExpr, dataset, bindingSet, b);
    }

    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        return this.baseConnection.getContextIDs();
    }

    public String getNamespace(String prefix) throws SailException {
        return this.baseConnection.getNamespace(prefix);
    }

    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        return this.baseConnection.getNamespaces();
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.extendClosureToStatement(subj, pred, obj, contexts);
        return this.baseConnection.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    public boolean isOpen() throws SailException {
        return this.open;
    }

    public synchronized void removeConnectionListener(SailConnectionListener listener) {
        if (this.baseConnection instanceof NotifyingSailConnection) {
            ((NotifyingSailConnection)this.baseConnection).removeConnectionListener(listener);
        }
    }

    public void removeNamespace(String prefix) throws SailException {
        this.baseConnection.removeNamespace(prefix);
    }

    public void removeStatements(Resource subj, URI pred, Value obj, Resource ... context) throws SailException {
        this.baseConnection.removeStatements(subj, pred, obj, context);
    }

    public void rollback() throws SailException {
        this.baseConnection.rollback();
    }

    public void setNamespace(String prefix, String name) throws SailException {
        this.baseConnection.setNamespace(prefix, name);
    }

    public long size(Resource ... contexts) throws SailException {
        return this.baseConnection.size(contexts);
    }

    LinkedDataSailConnection(Sail baseSail, LinkedDataCache linkedDataCache) throws SailException {
        this.linkedDataCache = linkedDataCache;
        this.valueFactory = baseSail.getValueFactory();
        this.baseConnection = baseSail.getConnection();
        this.open = true;
    }

    private void retrieveUri(URI uri) {
        try {
            this.linkedDataCache.retrieveUri(uri, this.baseConnection);
        }
        catch (RippleException e) {
            e.logError();
        }
    }

    private void extendClosureToStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.linkedDataCache.getDereferenceSubjects() && null != subj && subj instanceof URI) {
            this.retrieveUri((URI)subj);
        }
        if (this.linkedDataCache.getDereferencePredicates() && null != pred) {
            this.retrieveUri(pred);
        }
        if (this.linkedDataCache.getDereferenceObjects() && null != obj && obj instanceof URI) {
            this.retrieveUri((URI)obj);
        }
        if (this.linkedDataCache.getDereferenceContexts()) {
            for (Resource ctx : contexts) {
                if (null == ctx || !(ctx instanceof URI)) continue;
                this.retrieveUri((URI)ctx);
            }
        }
    }
}

