/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.sail;

import java.io.File;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.linkeddata.sail.LinkedDataSailConnection;
import net.fortytwo.ripple.RippleException;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.StackableSail;

public class LinkedDataSail
implements StackableSail,
NotifyingSail {
    public static final String CACHE_LIFETIME = "net.fortytwo.linkeddata.cacheLifetime";
    public static final String DATATYPE_HANDLING_POLICY = "net.fortytwo.linkeddata.datatypeHandlingPolicy";
    public static final String MEMORY_CACHE_CAPACITY = "net.fortytwo.linkeddata.memoryCacheCapacity";
    private final LinkedDataCache cache;
    private Sail baseSail;

    public LinkedDataSail(Sail baseSail, LinkedDataCache cache) throws RippleException {
        this.baseSail = baseSail;
        this.cache = cache;
    }

    public LinkedDataSail(Sail baseSail) throws RippleException {
        this(baseSail, LinkedDataCache.createDefault(baseSail));
    }

    public void addSailChangedListener(SailChangedListener listener) {
        if (this.baseSail instanceof NotifyingSail) {
            ((NotifyingSail)this.baseSail).addSailChangedListener(listener);
        }
    }

    public synchronized NotifyingSailConnection getConnection() throws SailException {
        return new LinkedDataSailConnection(this.baseSail, this.cache);
    }

    public File getDataDir() {
        throw new UnsupportedOperationException();
    }

    public ValueFactory getValueFactory() {
        return this.baseSail.getValueFactory();
    }

    public void initialize() throws SailException {
    }

    public boolean isWritable() throws SailException {
        return true;
    }

    public void removeSailChangedListener(SailChangedListener listener) {
        if (this.baseSail instanceof NotifyingSail) {
            ((NotifyingSail)this.baseSail).removeSailChangedListener(listener);
        }
    }

    public void setDataDir(File dataDir) {
        throw new UnsupportedOperationException();
    }

    public void shutDown() throws SailException {
    }

    public Sail getBaseSail() {
        return this.baseSail;
    }

    public void setBaseSail(Sail baseSail) {
        this.baseSail = baseSail;
    }

    public LinkedDataCache getCache() {
        return this.cache;
    }
}

