/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.rdfizers;

import java.io.IOException;
import java.io.InputStream;
import net.fortytwo.linkeddata.CacheEntry;
import net.fortytwo.linkeddata.Rdfizer;
import net.fortytwo.ripple.RippleException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

public class VerbatimRdfizer
implements Rdfizer {
    private final RDFFormat format;
    private final RDFParser parser;

    public VerbatimRdfizer(RDFFormat format, RDFParser.DatatypeHandling datatypeHandling) {
        this.format = format;
        this.parser = Rio.createParser((RDFFormat)format);
        this.parser.setDatatypeHandling(datatypeHandling);
    }

    @Override
    public CacheEntry.Status rdfize(InputStream is, RDFHandler handler, String baseUri) {
        try {
            this.parser.setRDFHandler(handler);
            this.parser.parse(is, baseUri);
        }
        catch (IOException e) {
            new RippleException((Throwable)e).logError(false);
            return CacheEntry.Status.Failure;
        }
        catch (RDFParseException e) {
            new RippleException((Throwable)e).logError(false);
            return CacheEntry.Status.ParseError;
        }
        catch (RDFHandlerException e) {
            new RippleException((Throwable)e).logError(false);
            return CacheEntry.Status.Failure;
        }
        return CacheEntry.Status.Success;
    }

    public String toString() {
        return "'" + this.format.getName() + "' verbatim rdfizer";
    }
}

