/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.fortytwo.flow.rdf.RDFBuffer;
import net.fortytwo.flow.rdf.RDFSink;
import net.fortytwo.flow.rdf.SailInserter;
import net.fortytwo.flow.rdf.SesameInputAdapter;
import net.fortytwo.flow.rdf.SesameOutputAdapter;
import net.fortytwo.flow.rdf.SingleContextPipe;
import net.fortytwo.linkeddata.BNodeToURIFilter;
import net.fortytwo.linkeddata.CacheEntry;
import net.fortytwo.linkeddata.CacheExpirationPolicy;
import net.fortytwo.linkeddata.CachingMetadata;
import net.fortytwo.linkeddata.Dereferencer;
import net.fortytwo.linkeddata.RDFUtils;
import net.fortytwo.linkeddata.Rdfizer;
import net.fortytwo.linkeddata.dereferencers.FileURIDereferencer;
import net.fortytwo.linkeddata.dereferencers.HTTPURIDereferencer;
import net.fortytwo.linkeddata.dereferencers.JarURIDereferencer;
import net.fortytwo.linkeddata.rdfizers.ImageRdfizer;
import net.fortytwo.linkeddata.rdfizers.VerbatimRdfizer;
import net.fortytwo.ripple.Ripple;
import net.fortytwo.ripple.RippleException;
import net.fortytwo.ripple.StringUtils;
import net.fortytwo.ripple.URIMap;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.semarglproject.sesame.rdf.rdfa.RDFaFormat;

public class LinkedDataCache {
    private static final Logger LOGGER = Logger.getLogger(LinkedDataCache.class);
    public static final String CACHE_NS = "http://fortytwo.net/2012/02/linkeddata#";
    public static final URI CACHE_MEMO = new URIImpl("http://fortytwo.net/2012/02/linkeddata#memo");
    public static final URI CACHE_GRAPH = null;
    private static final String[] NON_RDF_EXTENSIONS = new String[]{"123", "3dm", "3dmf", "3gp", "8bi", "aac", "ai", "aif", "app", "asf", "asp", "asx", "avi", "bat", "bin", "bmp", "c", "cab", "cfg", "cgi", "com", "cpl", "cpp", "css", "csv", "dat", "db", "dll", "dmg", "dmp", "doc", "drv", "drw", "dxf", "eps", "exe", "fnt", "fon", "gif", "gz", "h", "hqx", "iff", "indd", "ini", "iso", "java", "js", "jsp", "key", "log", "m3u", "mdb", "mid", "midi", "mim", "mng", "mov", "mp3", "mp4", "mpa", "mpg", "msg", "msi", "otf", "pct", "pdf", "php", "pif", "pkg", "pl", "plugin", "png", "pps", "ppt", "ps", "psd", "psp", "qt", "qxd", "qxp", "ra", "ram", "rar", "reg", "rm", "rtf", "sea", "sit", "sitx", "sql", "svg", "swf", "sys", "tar", "tif", "ttf", "uue", "vb", "vcd", "wav", "wks", "wma", "wmv", "wpd", "wps", "ws", "xll", "xls", "yps", "zip"};
    private final CachingMetadata metadata;
    private final ValueFactory valueFactory;
    private final boolean useBlankNodes;
    private URIMap uriMap;
    private boolean autoCommit = true;
    private boolean derefSubjects = true;
    private boolean derefPredicates = false;
    private boolean derefObjects = true;
    private boolean derefContexts = false;
    private String acceptHeader = null;
    private CacheExpirationPolicy expirationPolicy;
    private final Map<MediaType, MediaTypeInfo> rdfizers = new HashMap<MediaType, MediaTypeInfo>();
    private final Map<String, Dereferencer> dereferencers = new HashMap<String, Dereferencer>();

    public static LinkedDataCache createDefault(Sail sail) throws RippleException {
        RDFParser.DatatypeHandling datatypeHandling;
        LinkedDataCache cache = new LinkedDataCache(sail);
        HTTPURIDereferencer hdref = new HTTPURIDereferencer(cache);
        for (String x : NON_RDF_EXTENSIONS) {
            hdref.blackListExtension(x);
        }
        cache.addDereferencer("http", hdref);
        cache.addDereferencer("file", new FileURIDereferencer());
        cache.addDereferencer("jar", new JarURIDereferencer());
        String p = Ripple.getConfiguration().getString("net.fortytwo.linkeddata.datatypeHandlingPolicy");
        Object object = p.equals("ignore") ? RDFParser.DatatypeHandling.IGNORE : (p.equals("verify") ? RDFParser.DatatypeHandling.VERIFY : (datatypeHandling = p.equals("normalize") ? RDFParser.DatatypeHandling.NORMALIZE : null));
        if (null == datatypeHandling) {
            throw new RippleException("no such datatype handling policy: " + p);
        }
        RDFFormat.register((RDFFormat)RDFaFormat.RDFA);
        LinkedList tmp = new LinkedList();
        tmp.addAll(RDFFormat.values());
        for (RDFFormat f : tmp) {
            VerbatimRdfizer r = new VerbatimRdfizer(f, datatypeHandling);
            for (String type : f.getMIMETypes()) {
                double qualityFactor = type.equals("application/rdf+xml") ? 1.0 : 0.5;
                cache.addRdfizer(new MediaType(type), r, qualityFactor);
            }
            if (!f.equals((Object)RDFaFormat.RDFA)) continue;
            cache.addRdfizer(new MediaType("text/html"), r, 0.5);
        }
        ImageRdfizer imageRdfizer = new ImageRdfizer();
        cache.addRdfizer(MediaType.IMAGE_JPEG, imageRdfizer, 0.4);
        cache.addRdfizer(new MediaType("image/tiff"), imageRdfizer, 0.4);
        cache.addRdfizer(new MediaType("image/tiff-fx"), imageRdfizer, 0.4);
        return cache;
    }

    public LinkedDataCache(Sail sail) throws RippleException {
        int capacity = Ripple.getConfiguration().getInt("net.fortytwo.linkeddata.memoryCacheCapacity");
        this.metadata = new CachingMetadata(capacity, sail.getValueFactory());
        this.valueFactory = sail.getValueFactory();
        this.useBlankNodes = Ripple.getConfiguration().getBoolean("net.fortytwo.ripple.model.useBlankNodes");
        this.expirationPolicy = new DefaultCacheExpirationPolicy();
    }

    public URIMap getURIMap() {
        return this.uriMap;
    }

    public void setURIMap(URIMap map) {
        this.uriMap = map;
    }

    public String getAcceptHeader() {
        if (null == this.acceptHeader) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            Comparator<MediaTypeInfo> comparator = new Comparator<MediaTypeInfo>(){

                @Override
                public int compare(MediaTypeInfo first, MediaTypeInfo second) {
                    return first.quality < second.quality ? 1 : (first.quality > second.quality ? -1 : 0);
                }
            };
            MediaTypeInfo[] array = new MediaTypeInfo[this.rdfizers.size()];
            this.rdfizers.values().toArray(array);
            Arrays.sort(array, comparator);
            for (MediaTypeInfo m : array) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(m.mediaType.getName());
                double quality = m.quality;
                if (1.0 == quality) continue;
                sb.append(";q=").append(quality);
            }
            this.acceptHeader = sb.toString();
        }
        return this.acceptHeader;
    }

    public void addRdfizer(MediaType mediaType, Rdfizer rdfizer, double qualityFactor) {
        LOGGER.info((Object)("adding RDFizer for media type " + mediaType + ": " + rdfizer));
        if (qualityFactor <= 0.0 || qualityFactor > 1.0) {
            throw new IllegalArgumentException("quality factor must be between 0 and 1");
        }
        if (null != this.rdfizers.get(mediaType)) {
            LOGGER.warn((Object)("overriding already-registered RDFizer for media type " + mediaType));
        }
        MediaTypeInfo rq = new MediaTypeInfo();
        rq.mediaType = mediaType;
        rq.quality = qualityFactor;
        rq.rdfizer = rdfizer;
        this.rdfizers.put(mediaType, rq);
        this.acceptHeader = null;
    }

    public void addDereferencer(String scheme, Dereferencer dref) {
        LOGGER.info((Object)("adding dereferencer for for URI scheme " + scheme + ": " + dref));
        this.dereferencers.put(scheme, dref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry.Status retrieveUri(URI uri, SailConnection sc) throws RippleException {
        CacheEntry memo;
        block20: {
            Dereferencer dref;
            String graphUri = RDFUtils.findGraphUri(uri.toString());
            memo = this.metadata.getMemo(graphUri, sc);
            if (null != memo && !this.expirationPolicy.isExpired(uri.toString(), memo)) {
                return memo.getStatus();
            }
            String mapped = null == this.uriMap ? uri.toString() : this.uriMap.get(uri.toString());
            String retrievalUri = RDFUtils.removeFragmentIdentifier(mapped);
            try {
                dref = this.chooseDereferencer(retrievalUri);
            }
            catch (URISyntaxException e) {
                return CacheEntry.Status.InvalidUri;
            }
            if (null == dref) {
                return CacheEntry.Status.BadUriScheme;
            }
            LOGGER.info((Object)("dereferencing URI <" + StringUtils.escapeURIString((String)uri.toString()) + ">"));
            memo = new CacheEntry(CacheEntry.Status.Undetermined);
            memo.setDereferencer(dref.getClass().getName());
            try {
                InputStream is;
                memo.setStatus(CacheEntry.Status.DereferencerError);
                Representation rep = dref.dereference(retrievalUri);
                memo.setMediaType(rep.getMediaType());
                Rdfizer rfiz = this.chooseRdfizer(memo.getMediaType());
                if (null == rfiz) {
                    memo.setStatus(CacheEntry.Status.BadMediaType);
                    CacheEntry.Status status = this.logStatus(uri, memo);
                    return status;
                }
                memo.setRdfizer(rfiz.getClass().getName());
                SesameOutputAdapter adder = new SesameOutputAdapter((RDFHandler)new SailInserter(sc));
                RDFBuffer buffer = new RDFBuffer((RDFSink)adder);
                SingleContextPipe pipe = new SingleContextPipe((RDFSink)buffer, (Resource)this.valueFactory.createURI(graphUri), this.valueFactory);
                SesameInputAdapter handler = new SesameInputAdapter((RDFSink)(this.useBlankNodes ? pipe : new BNodeToURIFilter((RDFSink)pipe, this.valueFactory)));
                try {
                    is = rep.getStream();
                }
                catch (IOException e) {
                    throw new RippleException((Throwable)e);
                }
                String baseUri = uri.getNamespace();
                memo.setStatus(rfiz.rdfize(is, (RDFHandler)handler, baseUri));
                if (CacheEntry.Status.Success != memo.getStatus()) break block20;
                try {
                    sc.removeStatements(null, null, null, new Resource[]{this.valueFactory.createURI(graphUri)});
                }
                catch (SailException e) {
                    throw new RippleException((Throwable)e);
                }
                buffer.flush();
            }
            finally {
                this.metadata.setMemo(graphUri, memo, sc);
                if (this.autoCommit) {
                    try {
                        sc.commit();
                    }
                    catch (SailException e) {
                        throw new RippleException((Throwable)e);
                    }
                }
                this.logStatus(uri, memo);
            }
        }
        return memo.getStatus();
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setExpirationPolicy(CacheExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
    }

    public boolean getDereferenceSubjects() {
        return this.derefSubjects;
    }

    public void setDereferenceSubjects(boolean flag) {
        this.derefSubjects = flag;
    }

    public boolean getDereferencePredicates() {
        return this.derefPredicates;
    }

    public void setDereferencePredicates(boolean flag) {
        this.derefPredicates = flag;
    }

    public boolean getDereferenceObjects() {
        return this.derefObjects;
    }

    public void setDereferenceObjects(boolean flag) {
        this.derefObjects = flag;
    }

    public boolean getDereferenceContexts() {
        return this.derefContexts;
    }

    public void setDereferenceContexts(boolean flag) {
        this.derefContexts = flag;
    }

    private CacheEntry.Status logStatus(URI uri, CacheEntry memo) {
        CacheEntry.Status status = memo.getStatus();
        if (CacheEntry.Status.Success != status) {
            StringBuilder msg = new StringBuilder("Failed to dereference URI <" + StringUtils.escapeURIString((String)uri.toString()) + "> (");
            msg.append("dereferencer: ").append(memo.getDereferencer());
            msg.append(", media type: ").append(memo.getMediaType());
            msg.append(", rdfizer: ").append(memo.getRdfizer());
            msg.append("): ").append((Object)status);
            LOGGER.info((Object)msg);
        }
        return status;
    }

    private Dereferencer chooseDereferencer(String uri) throws URISyntaxException {
        String scheme = new java.net.URI(uri).getScheme();
        return this.dereferencers.get(scheme);
    }

    private Rdfizer chooseRdfizer(MediaType mediaType) throws RippleException {
        MediaTypeInfo rq = this.rdfizers.get(mediaType);
        return null == rq ? null : rq.rdfizer;
    }

    private class MediaTypeInfo {
        MediaType mediaType;
        public double quality;
        public Rdfizer rdfizer;

        private MediaTypeInfo() {
        }
    }

    private class DefaultCacheExpirationPolicy
    implements CacheExpirationPolicy {
        private long cacheLifetime = Ripple.getConfiguration().getLong("net.fortytwo.linkeddata.cacheLifetime") * 1000L;

        @Override
        public boolean isExpired(String uri, CacheEntry entry) {
            Date last = entry.getTimestamp();
            return null != last && System.currentTimeMillis() - last.getTime() >= this.cacheLifetime;
        }
    }
}

