/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata;

import info.aduna.iteration.CloseableIteration;
import java.util.Properties;
import junit.framework.TestCase;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.linkeddata.sail.LinkedDataSail;
import net.fortytwo.ripple.Ripple;
import net.fortytwo.ripple.URIMap;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.memory.MemoryStore;

public class LinkedDataSailTest
extends TestCase {
    private Sail baseSail;
    private LinkedDataSail sail;

    public void setUp() throws Exception {
        Ripple.initialize((Properties[])new Properties[0]);
        this.baseSail = new MemoryStore();
        this.baseSail.initialize();
        URIMap map = new URIMap();
        map.put("http://www.holygoat.co.uk/owl/redwood/0.1/tags/Tagging", LinkedDataSailTest.class.getResource("tags.owl").toString());
        LinkedDataCache wc = LinkedDataCache.createDefault((Sail)this.baseSail);
        wc.setURIMap(map);
        this.sail = new LinkedDataSail(this.baseSail, wc);
        this.sail.initialize();
    }

    public void tearDown() throws Exception {
        this.sail.shutDown();
        this.baseSail.shutDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDereferencer() throws Exception {
        boolean includeInferred = false;
        ValueFactory vf = this.sail.getValueFactory();
        URI tagging = vf.createURI("http://www.holygoat.co.uk/owl/redwood/0.1/tags/Tagging");
        NotifyingSailConnection sc = this.sail.getConnection();
        try {
            long count = LinkedDataSailTest.countStatements((CloseableIteration<? extends Statement, SailException>)sc.getStatements((Resource)tagging, RDF.TYPE, null, includeInferred, new Resource[0]));
            LinkedDataSailTest.assertEquals((long)1L, (long)count);
        }
        finally {
            sc.close();
        }
    }

    public void testCountStatements() throws Exception {
        ValueFactory vf = this.sail.getValueFactory();
        SailConnection sc = this.baseSail.getConnection();
        URI ctxA = vf.createURI("urn:org.example.test.countStatementsTest#");
        URI uri1 = vf.createURI("urn:org.example.test#uri1");
        URI uri2 = vf.createURI("urn:org.example.test#uri2");
        URI uri3 = vf.createURI("urn:org.example.test#uri3");
        URI[] uris = new URI[]{uri1, uri2, uri3};
        LinkedDataSailTest.assertEquals((long)0L, (long)LinkedDataSailTest.countStatements(sc, new Resource[]{ctxA}));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    sc.addStatement((Resource)uris[i], uris[j], (Value)uris[k], new Resource[]{ctxA});
                }
            }
        }
        sc.commit();
        sc.close();
        sc = this.sail.getConnection();
        LinkedDataSailTest.assertEquals((long)27L, (long)LinkedDataSailTest.countStatements(sc, new Resource[]{ctxA}));
        sc.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long countStatements(CloseableIteration<? extends Statement, SailException> iter) throws SailException {
        long count;
        try {
            count = 0L;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
        }
        finally {
            iter.close();
        }
        return count;
    }

    private static long countStatements(SailConnection sc, Resource ... contexts) throws SailException {
        return LinkedDataSailTest.countStatements((CloseableIteration<? extends Statement, SailException>)sc.getStatements(null, null, null, false, contexts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Ripple.initialize((Properties[])new Properties[0]);
        MemoryStore baseSail = new MemoryStore();
        baseSail.initialize();
        try {
            SailRepository repo = new SailRepository((Sail)baseSail);
            LinkedDataSail sail = new LinkedDataSail((Sail)baseSail);
            sail.initialize();
            try {
                NotifyingSailConnection sc = sail.getConnection();
                try {
                    sc.getStatements((Resource)new URIImpl("http://rdf.freebase.com/rdf/en.stephen_fry"), null, null, false, new Resource[0]);
                    sc.commit();
                }
                finally {
                    sc.close();
                }
            }
            finally {
                sail.shutDown();
            }
            RepositoryConnection rc = repo.getConnection();
            try {
                rc.export(new RDFHandler(){

                    public void startRDF() throws RDFHandlerException {
                    }

                    public void endRDF() throws RDFHandlerException {
                    }

                    public void handleNamespace(String s, String s1) throws RDFHandlerException {
                    }

                    public void handleStatement(Statement statement) throws RDFHandlerException {
                        System.out.println("" + statement);
                    }

                    public void handleComment(String s) throws RDFHandlerException {
                    }
                }, new Resource[0]);
            }
            finally {
                rc.close();
            }
        }
        finally {
            baseSail.shutDown();
        }
    }
}

