/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.trixnity.crypto.core;

import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"generatePbkdf2Sha512", "", "password", "", "salt", "iterationCount", "", "keyBitLength", "(Ljava/lang/String;[BIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trixnity-crypto-core"})
public final class Pbkdf2Sha512Kt {
    @Nullable
    public static final Object generatePbkdf2Sha512(@NotNull String password, @NotNull byte[] salt, int iterationCount, int keyBitLength, @NotNull Continuation<? super byte[]> $completion) {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        Intrinsics.checkNotNullExpressionValue((Object)secretKeyFactory, (String)"getInstance(...)");
        SecretKeyFactory skf = secretKeyFactory;
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        byte[] byArray = skf.generateSecret(new PBEKeySpec(cArray, salt, iterationCount, keyBitLength)).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }
}

