/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.trixnity.crypto.core;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.folivo.trixnity.crypto.core.SecureRandomKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lnet/folivo/trixnity/crypto/core/SecureRandom;", "Lkotlin/random/Random;", "<init>", "()V", "nextBytes", "", "array", "fromIndex", "", "toIndex", "nextBits", "bitCount", "trixnity-crypto-core"})
public final class SecureRandom
extends Random {
    @NotNull
    public static final SecureRandom INSTANCE = new SecureRandom();

    private SecureRandom() {
    }

    @NotNull
    public byte[] nextBytes(@NotNull byte[] array, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        byte[] random = new byte[toIndex - fromIndex];
        SecureRandomKt.fillRandomBytes(random);
        ArraysKt.copyInto((byte[])random, (byte[])array, (int)fromIndex, (int)0, (int)random.length);
        return array;
    }

    public int nextBits(int bitCount) {
        int numBytes = (bitCount + 7) / 8;
        byte[] b = this.nextBytes(numBytes);
        int next = 0;
        for (int i = 0; i < numBytes; ++i) {
            next = (next << 8) + (b[i] & 0xFF);
        }
        return next >>> numBytes * 8 - bitCount;
    }
}

