/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.trixnity.core.util;

import io.ktor.http.Parameters;
import io.ktor.http.ParametersKt;
import io.ktor.http.QueryKt;
import io.ktor.http.URLProtocol;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.folivo.trixnity.core.model.EventId;
import net.folivo.trixnity.core.model.RoomAliasId;
import net.folivo.trixnity.core.model.RoomId;
import net.folivo.trixnity.core.model.UserId;
import net.folivo.trixnity.core.util.MatrixIdRegex;
import net.folivo.trixnity.core.util.Patterns;
import net.folivo.trixnity.core.util.ReferenceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00072\u00020\u0001:\u0006\u0002\u0003\u0004\u0005\u0006\u0007\u0082\u0001\u0005\b\t\n\u000b\f\u00a8\u0006\r\u00c0\u0006\u0003"}, d2={"Lnet/folivo/trixnity/core/util/Reference;", "", "User", "Room", "RoomAlias", "Event", "Link", "Companion", "Lnet/folivo/trixnity/core/util/Reference$Event;", "Lnet/folivo/trixnity/core/util/Reference$Link;", "Lnet/folivo/trixnity/core/util/Reference$Room;", "Lnet/folivo/trixnity/core/util/Reference$RoomAlias;", "Lnet/folivo/trixnity/core/util/Reference$User;", "trixnity-core"})
public interface Reference {
    @NotNull
    public static final Companion Companion = net.folivo.trixnity.core.util.Reference$Companion.$$INSTANCE;

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\tJ \u0010\u0011\u001a\u0004\u0018\u00010\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u0004\u0018\u00010\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0017\u001a\u00020\t*\u00020\tH\u0002J\f\u0010\u0018\u001a\u00020\t*\u00020\tH\u0002J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lnet/folivo/trixnity/core/util/Reference$Companion;", "", "<init>", "()V", "findReferences", "", "Lkotlin/ranges/IntRange;", "Lnet/folivo/trixnity/core/util/Reference;", "message", "", "findIdReferences", "content", "findLinkReferences", "parseMatrixId", "id", "parseLink", "href", "parseMatrixToLink", "path", "", "parameters", "Lio/ktor/http/Parameters;", "parseMatrixProtocolLink", "trimParens", "trimLink", "overlaps", "", "other", "matrixProtocol", "Lio/ktor/http/URLProtocol;", "trixnity-core"})
    @SourceDebugExtension(value={"SMAP\nReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reference.kt\nnet/folivo/trixnity/core/util/Reference$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,206:1\n1#2:207\n666#3:208\n747#3,4:209\n1563#4:213\n1634#4,3:214\n1563#4:217\n1634#4,3:218\n1104#5,3:221\n1104#5,3:224\n*S KotlinDebug\n*F\n+ 1 Reference.kt\nnet/folivo/trixnity/core/util/Reference$Companion\n*L\n80#1:208\n80#1:209,4\n123#1:213\n123#1:214,3\n155#1:217\n155#1:218,3\n188#1:221,3\n189#1:224,3\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final URLProtocol matrixProtocol;

        private Companion() {
        }

        @NotNull
        public final Map<IntRange, Reference> findReferences(@NotNull String message) {
            Map map;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Map candidates = MapsKt.plus(this.findLinkReferences(message), this.findIdReferences(message));
            Map $this$findReferences_u24lambda_u241 = map = MapsKt.createMapBuilder();
            boolean bl = false;
            for (Map.Entry entry : candidates.entrySet()) {
                Object v0;
                Reference candidateValue;
                IntRange candidateKey;
                block3: {
                    candidateKey = (IntRange)entry.getKey();
                    candidateValue = (Reference)entry.getValue();
                    Iterable iterable = $this$findReferences_u24lambda_u241.keySet();
                    for (Object t : iterable) {
                        IntRange it = (IntRange)t;
                        boolean bl2 = false;
                        if (!$$INSTANCE.overlaps(candidateKey, it)) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                IntRange overlapKey = v0;
                if (overlapKey == null) {
                    $this$findReferences_u24lambda_u241.put(candidateKey, candidateValue);
                    continue;
                }
                if (overlapKey.getLast() - overlapKey.getFirst() >= candidateKey.getLast() - candidateKey.getFirst()) continue;
                $this$findReferences_u24lambda_u241.remove(overlapKey);
                $this$findReferences_u24lambda_u241.put(candidateKey, candidateValue);
            }
            return MapsKt.build((Map)map);
        }

        private final Map<IntRange, Reference> findIdReferences(String content) {
            return MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)MatrixIdRegex.INSTANCE.getAutolinkId(), (CharSequence)content, (int)0, (int)2, null), Companion::findIdReferences$lambda$2));
        }

        /*
         * WARNING - void declaration
         */
        private final Map<IntRange, Reference> findLinkReferences(String content) {
            void $this$associateTo$iv$iv;
            Sequence $this$associate$iv = Regex.findAll$default((Regex)Patterns.INSTANCE.getAUTOLINK_MATRIX_URI(), (CharSequence)content, (int)0, (int)2, null);
            boolean $i$f$associate = false;
            Sequence sequence = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                MatchResult it = (MatchResult)element$iv$iv;
                boolean bl = false;
                String trimmedContent = $$INSTANCE.trimLink(it.getValue());
                IntRange intRange = RangesKt.until((int)it.getRange().getFirst(), (int)(it.getRange().getFirst() + trimmedContent.length()));
                Reference reference = $$INSTANCE.parseLink(trimmedContent);
                if (reference == null) {
                    reference = new Link(trimmedContent);
                }
                Pair pair = new Pair((Object)intRange, (Object)reference);
                map.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv;
        }

        private final Reference parseMatrixId(String id) {
            Reference reference;
            if (id.length() > 255) {
                ReferenceKt.access$getLog$p().trace(() -> Companion.parseMatrixId$lambda$4(id));
                reference = null;
            } else {
                reference = StringsKt.startsWith$default((CharSequence)id, (char)'@', (boolean)false, (int)2, null) ? (Reference)new User(new UserId(id), null, 2, null) : (StringsKt.startsWith$default((CharSequence)id, (char)'#', (boolean)false, (int)2, null) ? (Reference)new RoomAlias(new RoomAliasId(id), null, 2, null) : null);
            }
            return reference;
        }

        @Nullable
        public final Reference parseLink(@NotNull String href) {
            Intrinsics.checkNotNullParameter((Object)href, (String)"href");
            Url url = URLUtilsKt.Url((String)href);
            if (Intrinsics.areEqual((Object)url.getProtocol(), (Object)matrixProtocol)) {
                return this.parseMatrixProtocolLink(url.getSegments(), url.getParameters());
            }
            if (Intrinsics.areEqual((Object)url.getProtocol(), (Object)URLProtocol.Companion.getHTTPS()) && Intrinsics.areEqual((Object)url.getHost(), (Object)"matrix.to") && url.getSegments().isEmpty()) {
                String path = StringsKt.removePrefix((String)StringsKt.substringBefore$default((String)url.getFragment(), (char)'?', null, (int)2, null), (CharSequence)"/");
                String query = StringsKt.substringAfter((String)url.getFragment(), (char)'?', (String)"");
                char[] cArray = new char[]{'/'};
                List segments = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)path, (CharSequence)"/"), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                Parameters parameters = QueryKt.parseQueryString$default((String)query, (int)0, (int)0, (boolean)false, (int)6, null);
                return this.parseMatrixToLink(segments, parameters);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final Reference parseMatrixToLink(List<String> path, Parameters parameters) {
            Reference reference;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = path;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object;
                void id;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (id.length() > 255) {
                    ReferenceKt.access$getLog$p().trace(() -> Companion.parseMatrixToLink$lambda$7$lambda$5((String)id));
                    return null;
                }
                if (StringsKt.startsWith$default((CharSequence)((CharSequence)id), (char)'#', (boolean)false, (int)2, null)) {
                    object = new RoomAliasId((String)id);
                } else if (StringsKt.startsWith$default((CharSequence)((CharSequence)id), (char)'!', (boolean)false, (int)2, null)) {
                    object = new RoomId((String)id);
                } else if (StringsKt.startsWith$default((CharSequence)((CharSequence)id), (char)'@', (boolean)false, (int)2, null)) {
                    object = new UserId((String)id);
                } else if (StringsKt.startsWith$default((CharSequence)((CharSequence)id), (char)'$', (boolean)false, (int)2, null)) {
                    object = new EventId((String)id);
                } else {
                    ReferenceKt.access$getLog$p().trace(() -> Companion.parseMatrixToLink$lambda$7$lambda$6((String)id));
                    object = null;
                }
                collection.add(object);
            }
            List parts = (List)destination$iv$iv;
            Object first = CollectionsKt.getOrNull((List)parts, (int)0);
            Object second = CollectionsKt.getOrNull((List)parts, (int)1);
            if (first instanceof UserId) {
                reference = new User((UserId)first, parameters);
            } else if (first instanceof RoomAliasId) {
                reference = new RoomAlias((RoomAliasId)first, parameters);
            } else if (first instanceof EventId) {
                reference = new Event(null, (EventId)first, parameters);
            } else if (first instanceof RoomId && second instanceof EventId) {
                reference = new Event((RoomId)first, (EventId)second, parameters);
            } else if (first instanceof RoomId) {
                reference = new Room((RoomId)first, parameters);
            } else {
                ReferenceKt.access$getLog$p().trace(Companion::parseMatrixToLink$lambda$8);
                reference = null;
            }
            return reference;
        }

        /*
         * WARNING - void declaration
         */
        private final Reference parseMatrixProtocolLink(List<String> path, Parameters parameters) {
            Reference reference;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.windowed$default((Iterable)path, (int)2, (int)2, (boolean)false, (int)4, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String type = (String)list.get(0);
                String id = (String)list.get(1);
                if (id.length() > 255) {
                    ReferenceKt.access$getLog$p().trace(() -> Companion.parseMatrixProtocolLink$lambda$11$lambda$9(id));
                    return null;
                }
                if (Intrinsics.areEqual((Object)type, (Object)"roomid")) {
                    object = new RoomId("!" + id);
                } else if (Intrinsics.areEqual((Object)type, (Object)"r")) {
                    object = new RoomAliasId("#" + id);
                } else if (Intrinsics.areEqual((Object)type, (Object)"u")) {
                    object = new UserId("@" + id);
                } else if (Intrinsics.areEqual((Object)type, (Object)"e")) {
                    object = new EventId("$" + id);
                } else {
                    ReferenceKt.access$getLog$p().trace(() -> Companion.parseMatrixProtocolLink$lambda$11$lambda$10(type));
                    object = null;
                }
                collection.add(object);
            }
            List parts = (List)destination$iv$iv;
            Object first = CollectionsKt.getOrNull((List)parts, (int)0);
            Object second = CollectionsKt.getOrNull((List)parts, (int)1);
            if (first instanceof UserId) {
                reference = new User((UserId)first, parameters);
            } else if (first instanceof RoomAliasId) {
                reference = new RoomAlias((RoomAliasId)first, parameters);
            } else if (first instanceof RoomId && second instanceof EventId) {
                reference = new Event((RoomId)first, (EventId)second, parameters);
            } else if (first instanceof RoomId) {
                reference = new Room((RoomId)first, parameters);
            } else {
                ReferenceKt.access$getLog$p().trace(Companion::parseMatrixProtocolLink$lambda$12);
                reference = null;
            }
            return reference;
        }

        private final String trimParens(String $this$trimParens) {
            String string;
            if (StringsKt.endsWith$default((CharSequence)$this$trimParens, (char)')', (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{')'};
                String trimmed = StringsKt.trimEnd((String)$this$trimParens, (char[])cArray);
                CharSequence $this$count$iv = trimmed;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!(it == '(')) continue;
                    ++count$iv;
                }
                int openingParens = count$iv;
                CharSequence $this$count$iv2 = trimmed;
                boolean $i$f$count2 = false;
                int count$iv2 = 0;
                for (int i = 0; i < $this$count$iv2.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv2.charAt(i);
                    boolean bl = false;
                    if (!(it == ')')) continue;
                    ++count$iv2;
                }
                int closingParens = count$iv2;
                int endingParens = $this$trimParens.length() - trimmed.length();
                int openParens = openingParens - closingParens;
                int desiredParens = Math.min(endingParens, openParens);
                string = StringsKt.take((String)$this$trimParens, (int)(trimmed.length() + desiredParens));
            } else {
                string = $this$trimParens;
            }
            return string;
        }

        private final String trimLink(String $this$trimLink) {
            char[] cArray = new char[]{',', '.', '!', '?', ':'};
            return this.trimParens(StringsKt.trimEnd((String)$this$trimLink, (char[])cArray));
        }

        private final boolean overlaps(IntRange $this$overlaps, IntRange other) {
            return $this$overlaps.getFirst() <= other.getLast() && other.getFirst() <= $this$overlaps.getLast();
        }

        private static final Pair findIdReferences$lambda$2(MatchResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Reference reference = $$INSTANCE.parseMatrixId(it.getValue());
            if (reference == null) {
                return null;
            }
            return new Pair((Object)it.getRange(), (Object)reference);
        }

        private static final Object parseMatrixId$lambda$4(String $id) {
            return "malformed matrix id: id too long: " + $id.length() + " (max length: 255)";
        }

        private static final Object parseMatrixToLink$lambda$7$lambda$5(String $id) {
            return "malformed matrix link: id too long: " + $id.length() + " (max length: 255)";
        }

        private static final Object parseMatrixToLink$lambda$7$lambda$6(String $id) {
            return "malformed matrix link: invalid id type: " + StringsKt.firstOrNull((CharSequence)$id) + " (known types: #, !, @, $)";
        }

        private static final Object parseMatrixToLink$lambda$8() {
            return "malformed matrix link: unknown format";
        }

        private static final Object parseMatrixProtocolLink$lambda$11$lambda$9(String $id) {
            return "malformed matrix link: id too long: " + $id.length() + " (max length: 255)";
        }

        private static final Object parseMatrixProtocolLink$lambda$11$lambda$10(String $type) {
            return "malformed matrix link: invalid id type: " + $type + " (known types: roomid, r, u, e)";
        }

        private static final Object parseMatrixProtocolLink$lambda$12() {
            return "malformed matrix link: unknown format";
        }

        static {
            $$INSTANCE = new Companion();
            matrixProtocol = new URLProtocol("matrix", 0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lnet/folivo/trixnity/core/util/Reference$Event;", "Lnet/folivo/trixnity/core/util/Reference;", "roomId", "Lnet/folivo/trixnity/core/model/RoomId;", "eventId", "Lnet/folivo/trixnity/core/model/EventId;", "parameters", "Lio/ktor/http/Parameters;", "<init>", "(Lnet/folivo/trixnity/core/model/RoomId;Lnet/folivo/trixnity/core/model/EventId;Lio/ktor/http/Parameters;)V", "getRoomId", "()Lnet/folivo/trixnity/core/model/RoomId;", "getEventId", "()Lnet/folivo/trixnity/core/model/EventId;", "getParameters", "()Lio/ktor/http/Parameters;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "trixnity-core"})
    public static final class Event
    implements Reference {
        @Nullable
        private final RoomId roomId;
        @NotNull
        private final EventId eventId;
        @NotNull
        private final Parameters parameters;

        public Event(@Nullable RoomId roomId, @NotNull EventId eventId, @NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.roomId = roomId;
            this.eventId = eventId;
            this.parameters = parameters;
        }

        public /* synthetic */ Event(RoomId roomId, EventId eventId, Parameters parameters, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                roomId = null;
            }
            if ((n & 4) != 0) {
                parameters = ParametersKt.parametersOf();
            }
            this(roomId, eventId, parameters);
        }

        @Nullable
        public final RoomId getRoomId() {
            return this.roomId;
        }

        @NotNull
        public final EventId getEventId() {
            return this.eventId;
        }

        @NotNull
        public final Parameters getParameters() {
            return this.parameters;
        }

        @Nullable
        public final RoomId component1() {
            return this.roomId;
        }

        @NotNull
        public final EventId component2() {
            return this.eventId;
        }

        @NotNull
        public final Parameters component3() {
            return this.parameters;
        }

        @NotNull
        public final Event copy(@Nullable RoomId roomId, @NotNull EventId eventId, @NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            return new Event(roomId, eventId, parameters);
        }

        public static /* synthetic */ Event copy$default(Event event, RoomId roomId, EventId eventId, Parameters parameters, int n, Object object) {
            if ((n & 1) != 0) {
                roomId = event.roomId;
            }
            if ((n & 2) != 0) {
                eventId = event.eventId;
            }
            if ((n & 4) != 0) {
                parameters = event.parameters;
            }
            return event.copy(roomId, eventId, parameters);
        }

        @NotNull
        public String toString() {
            return "Event(roomId=" + this.roomId + ", eventId=" + this.eventId + ", parameters=" + this.parameters + ")";
        }

        public int hashCode() {
            int result = this.roomId == null ? 0 : this.roomId.hashCode();
            result = result * 31 + this.eventId.hashCode();
            result = result * 31 + this.parameters.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Event)) {
                return false;
            }
            Event event = (Event)other;
            if (!Intrinsics.areEqual((Object)this.roomId, (Object)event.roomId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.eventId, (Object)event.eventId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.parameters, (Object)event.parameters);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lnet/folivo/trixnity/core/util/Reference$Link;", "Lnet/folivo/trixnity/core/util/Reference;", "url", "", "<init>", "(Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "trixnity-core"})
    public static final class Link
    implements Reference {
        @NotNull
        private final String url;

        public Link(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final Link copy(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new Link(url);
        }

        public static /* synthetic */ Link copy$default(Link link, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = link.url;
            }
            return link.copy(string);
        }

        @NotNull
        public String toString() {
            return "Link(url=" + this.url + ")";
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Link)) {
                return false;
            }
            Link link = (Link)other;
            return Intrinsics.areEqual((Object)this.url, (Object)link.url);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lnet/folivo/trixnity/core/util/Reference$Room;", "Lnet/folivo/trixnity/core/util/Reference;", "roomId", "Lnet/folivo/trixnity/core/model/RoomId;", "parameters", "Lio/ktor/http/Parameters;", "<init>", "(Lnet/folivo/trixnity/core/model/RoomId;Lio/ktor/http/Parameters;)V", "getRoomId", "()Lnet/folivo/trixnity/core/model/RoomId;", "getParameters", "()Lio/ktor/http/Parameters;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "trixnity-core"})
    public static final class Room
    implements Reference {
        @NotNull
        private final RoomId roomId;
        @NotNull
        private final Parameters parameters;

        public Room(@NotNull RoomId roomId, @NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.roomId = roomId;
            this.parameters = parameters;
        }

        public /* synthetic */ Room(RoomId roomId, Parameters parameters, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                parameters = ParametersKt.parametersOf();
            }
            this(roomId, parameters);
        }

        @NotNull
        public final RoomId getRoomId() {
            return this.roomId;
        }

        @NotNull
        public final Parameters getParameters() {
            return this.parameters;
        }

        @NotNull
        public final RoomId component1() {
            return this.roomId;
        }

        @NotNull
        public final Parameters component2() {
            return this.parameters;
        }

        @NotNull
        public final Room copy(@NotNull RoomId roomId, @NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            return new Room(roomId, parameters);
        }

        public static /* synthetic */ Room copy$default(Room room, RoomId roomId, Parameters parameters, int n, Object object) {
            if ((n & 1) != 0) {
                roomId = room.roomId;
            }
            if ((n & 2) != 0) {
                parameters = room.parameters;
            }
            return room.copy(roomId, parameters);
        }

        @NotNull
        public String toString() {
            return "Room(roomId=" + this.roomId + ", parameters=" + this.parameters + ")";
        }

        public int hashCode() {
            int result = this.roomId.hashCode();
            result = result * 31 + this.parameters.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Room)) {
                return false;
            }
            Room room = (Room)other;
            if (!Intrinsics.areEqual((Object)this.roomId, (Object)room.roomId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.parameters, (Object)room.parameters);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lnet/folivo/trixnity/core/util/Reference$RoomAlias;", "Lnet/folivo/trixnity/core/util/Reference;", "roomAliasId", "Lnet/folivo/trixnity/core/model/RoomAliasId;", "parameters", "Lio/ktor/http/Parameters;", "<init>", "(Lnet/folivo/trixnity/core/model/RoomAliasId;Lio/ktor/http/Parameters;)V", "getRoomAliasId", "()Lnet/folivo/trixnity/core/model/RoomAliasId;", "getParameters", "()Lio/ktor/http/Parameters;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "trixnity-core"})
    public static final class RoomAlias
    implements Reference {
        @NotNull
        private final RoomAliasId roomAliasId;
        @NotNull
        private final Parameters parameters;

        public RoomAlias(@NotNull RoomAliasId roomAliasId, @NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)roomAliasId, (String)"roomAliasId");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.roomAliasId = roomAliasId;
            this.parameters = parameters;
        }

        public /* synthetic */ RoomAlias(RoomAliasId roomAliasId, Parameters parameters, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                parameters = ParametersKt.parametersOf();
            }
            this(roomAliasId, parameters);
        }

        @NotNull
        public final RoomAliasId getRoomAliasId() {
            return this.roomAliasId;
        }

        @NotNull
        public final Parameters getParameters() {
            return this.parameters;
        }

        @NotNull
        public final RoomAliasId component1() {
            return this.roomAliasId;
        }

        @NotNull
        public final Parameters component2() {
            return this.parameters;
        }

        @NotNull
        public final RoomAlias copy(@NotNull RoomAliasId roomAliasId, @NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)roomAliasId, (String)"roomAliasId");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            return new RoomAlias(roomAliasId, parameters);
        }

        public static /* synthetic */ RoomAlias copy$default(RoomAlias roomAlias, RoomAliasId roomAliasId, Parameters parameters, int n, Object object) {
            if ((n & 1) != 0) {
                roomAliasId = roomAlias.roomAliasId;
            }
            if ((n & 2) != 0) {
                parameters = roomAlias.parameters;
            }
            return roomAlias.copy(roomAliasId, parameters);
        }

        @NotNull
        public String toString() {
            return "RoomAlias(roomAliasId=" + this.roomAliasId + ", parameters=" + this.parameters + ")";
        }

        public int hashCode() {
            int result = this.roomAliasId.hashCode();
            result = result * 31 + this.parameters.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RoomAlias)) {
                return false;
            }
            RoomAlias roomAlias = (RoomAlias)other;
            if (!Intrinsics.areEqual((Object)this.roomAliasId, (Object)roomAlias.roomAliasId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.parameters, (Object)roomAlias.parameters);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lnet/folivo/trixnity/core/util/Reference$User;", "Lnet/folivo/trixnity/core/util/Reference;", "userId", "Lnet/folivo/trixnity/core/model/UserId;", "parameters", "Lio/ktor/http/Parameters;", "<init>", "(Lnet/folivo/trixnity/core/model/UserId;Lio/ktor/http/Parameters;)V", "getUserId", "()Lnet/folivo/trixnity/core/model/UserId;", "getParameters", "()Lio/ktor/http/Parameters;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "trixnity-core"})
    public static final class User
    implements Reference {
        @NotNull
        private final UserId userId;
        @NotNull
        private final Parameters parameters;

        public User(@NotNull UserId userId, @NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.userId = userId;
            this.parameters = parameters;
        }

        public /* synthetic */ User(UserId userId, Parameters parameters, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                parameters = ParametersKt.parametersOf();
            }
            this(userId, parameters);
        }

        @NotNull
        public final UserId getUserId() {
            return this.userId;
        }

        @NotNull
        public final Parameters getParameters() {
            return this.parameters;
        }

        @NotNull
        public final UserId component1() {
            return this.userId;
        }

        @NotNull
        public final Parameters component2() {
            return this.parameters;
        }

        @NotNull
        public final User copy(@NotNull UserId userId, @NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            return new User(userId, parameters);
        }

        public static /* synthetic */ User copy$default(User user, UserId userId, Parameters parameters, int n, Object object) {
            if ((n & 1) != 0) {
                userId = user.userId;
            }
            if ((n & 2) != 0) {
                parameters = user.parameters;
            }
            return user.copy(userId, parameters);
        }

        @NotNull
        public String toString() {
            return "User(userId=" + this.userId + ", parameters=" + this.parameters + ")";
        }

        public int hashCode() {
            int result = this.userId.hashCode();
            result = result * 31 + this.parameters.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof User)) {
                return false;
            }
            User user = (User)other;
            if (!Intrinsics.areEqual((Object)this.userId, (Object)user.userId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.parameters, (Object)user.parameters);
        }
    }
}

