/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.trixnity.core.model.keys;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonPrimitive;
import net.folivo.trixnity.core.model.UserId;
import net.folivo.trixnity.core.model.UserIdSerializer;
import net.folivo.trixnity.core.model.keys.KeyValue;
import net.folivo.trixnity.core.model.keys.Keys;
import net.folivo.trixnity.core.model.keys.Signed;
import net.folivo.trixnity.core.model.keys.SignedSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0004\u0018\u0019\u001a\u001bB#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lnet/folivo/trixnity/core/model/keys/UnwrapKeyValueSerializer;", "T", "Lnet/folivo/trixnity/core/model/keys/KeyValue;", "Lkotlinx/serialization/KSerializer;", "name", "", "builder", "Lkotlin/Function1;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Lnet/folivo/trixnity/core/model/keys/KeyValue;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Lnet/folivo/trixnity/core/model/keys/KeyValue;)V", "Ed25519KeyValueSerializer", "Curve25519KeyValueSerializer", "SignedCurve25519KeyValueSerializer", "UnknownKeyValueSerializer", "trixnity-core"})
public abstract class UnwrapKeyValueSerializer<T extends KeyValue>
implements KSerializer<T> {
    @NotNull
    private final Function1<String, T> builder;
    @NotNull
    private final SerialDescriptor descriptor;

    public UnwrapKeyValueSerializer(@NotNull String name, @NotNull Function1<? super String, ? extends T> builder) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.builder = builder;
        this.descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)name, (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return (T)((KeyValue)this.builder.invoke((Object)decoder.decodeString()));
    }

    public void serialize(@NotNull Encoder encoder, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        encoder.encodeString(value.getValue());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lnet/folivo/trixnity/core/model/keys/UnwrapKeyValueSerializer$Curve25519KeyValueSerializer;", "Lnet/folivo/trixnity/core/model/keys/UnwrapKeyValueSerializer;", "Lnet/folivo/trixnity/core/model/keys/KeyValue$Curve25519KeyValue;", "<init>", "()V", "trixnity-core"})
    public static final class Curve25519KeyValueSerializer
    extends UnwrapKeyValueSerializer<KeyValue.Curve25519KeyValue> {
        @NotNull
        public static final Curve25519KeyValueSerializer INSTANCE = new Curve25519KeyValueSerializer();

        private Curve25519KeyValueSerializer() {
            super("Curve25519KeyValue", 1.INSTANCE);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lnet/folivo/trixnity/core/model/keys/UnwrapKeyValueSerializer$Ed25519KeyValueSerializer;", "Lnet/folivo/trixnity/core/model/keys/UnwrapKeyValueSerializer;", "Lnet/folivo/trixnity/core/model/keys/KeyValue$Ed25519KeyValue;", "<init>", "()V", "trixnity-core"})
    public static final class Ed25519KeyValueSerializer
    extends UnwrapKeyValueSerializer<KeyValue.Ed25519KeyValue> {
        @NotNull
        public static final Ed25519KeyValueSerializer INSTANCE = new Ed25519KeyValueSerializer();

        private Ed25519KeyValueSerializer() {
            super("Ed25519KeyValue", 1.INSTANCE);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lnet/folivo/trixnity/core/model/keys/UnwrapKeyValueSerializer$SignedCurve25519KeyValueSerializer;", "Lkotlinx/serialization/KSerializer;", "Lnet/folivo/trixnity/core/model/keys/KeyValue$SignedCurve25519KeyValue;", "<init>", "()V", "delegate", "Lnet/folivo/trixnity/core/model/keys/SignedSerializer;", "Lnet/folivo/trixnity/core/model/keys/KeyValue$SignedCurve25519KeyValue$SignedCurve25519KeyValueSignable;", "Lnet/folivo/trixnity/core/model/UserId;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "trixnity-core"})
    public static final class SignedCurve25519KeyValueSerializer
    implements KSerializer<KeyValue.SignedCurve25519KeyValue> {
        @NotNull
        public static final SignedCurve25519KeyValueSerializer INSTANCE = new SignedCurve25519KeyValueSerializer();
        @NotNull
        private static final SignedSerializer<KeyValue.SignedCurve25519KeyValue.SignedCurve25519KeyValueSignable, UserId> delegate = new SignedSerializer(KeyValue.SignedCurve25519KeyValue.SignedCurve25519KeyValueSignable.Companion.serializer(), UserIdSerializer.INSTANCE);
        @NotNull
        private static final SerialDescriptor descriptor = SerialDescriptorsKt.buildClassSerialDescriptor$default((String)"SignedCurve25519KeyValue", (SerialDescriptor[])new SerialDescriptor[0], null, (int)4, null);

        private SignedCurve25519KeyValueSerializer() {
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return descriptor;
        }

        @NotNull
        public KeyValue.SignedCurve25519KeyValue deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            Object signed = delegate.deserialize(decoder);
            Map<UserId, Keys> map = ((Signed)signed).getSignatures();
            if (map == null) {
                throw new SerializationException("no signatures found for curve25519 key");
            }
            return new KeyValue.SignedCurve25519KeyValue(((KeyValue.SignedCurve25519KeyValue.SignedCurve25519KeyValueSignable)((Signed)signed).getSigned()).getKey(), ((KeyValue.SignedCurve25519KeyValue.SignedCurve25519KeyValueSignable)((Signed)signed).getSigned()).getFallback(), map);
        }

        public void serialize(@NotNull Encoder encoder, @NotNull KeyValue.SignedCurve25519KeyValue value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            delegate.serialize(encoder, value);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lnet/folivo/trixnity/core/model/keys/UnwrapKeyValueSerializer$UnknownKeyValueSerializer;", "Lkotlinx/serialization/KSerializer;", "Lnet/folivo/trixnity/core/model/keys/KeyValue$UnknownKeyValue;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "trixnity-core"})
    public static final class UnknownKeyValueSerializer
    implements KSerializer<KeyValue.UnknownKeyValue> {
        @NotNull
        public static final UnknownKeyValueSerializer INSTANCE = new UnknownKeyValueSerializer();
        @NotNull
        private static final SerialDescriptor descriptor = SerialDescriptorsKt.buildClassSerialDescriptor$default((String)"UnknownKeyValue", (SerialDescriptor[])new SerialDescriptor[0], null, (int)4, null);

        private UnknownKeyValueSerializer() {
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return descriptor;
        }

        @NotNull
        public KeyValue.UnknownKeyValue deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            if (!(decoder instanceof JsonDecoder)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            JsonElement raw = ((JsonDecoder)decoder).decodeJsonElement();
            Object object = raw instanceof JsonPrimitive ? (JsonPrimitive)raw : null;
            if (object == null || (object = object.getContent()) == null) {
                object = "unknown";
            }
            return new KeyValue.UnknownKeyValue((String)object, raw);
        }

        public void serialize(@NotNull Encoder encoder, @NotNull KeyValue.UnknownKeyValue value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (!(encoder instanceof JsonEncoder)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ((JsonEncoder)encoder).encodeJsonElement(value.getRaw());
        }
    }
}

