/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.trixnity.core.model;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import net.folivo.trixnity.core.model.UserIdSerializer;
import net.folivo.trixnity.core.util.MatrixIdRegex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=UserIdSerializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bJ\b\u0010\u0014\u001a\u00020\u0003H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\r\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0011\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lnet/folivo/trixnity/core/model/UserId;", "", "full", "", "<init>", "(Ljava/lang/String;)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;)V", "getFull", "()Ljava/lang/String;", "getLocalpart", "getDomain", "isValid", "", "()Z", "isValid$delegate", "Lkotlin/Lazy;", "isReasonable", "isReasonable$delegate", "toString", "component1", "copy", "equals", "other", "hashCode", "", "Companion", "trixnity-core"})
public final class UserId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String full;
    @NotNull
    private final Lazy isValid$delegate;
    @NotNull
    private final Lazy isReasonable$delegate;
    public static final char sigilCharacter = '@';

    public UserId(@NotNull String full) {
        Intrinsics.checkNotNullParameter((Object)full, (String)"full");
        this.full = full;
        this.isValid$delegate = LazyKt.lazy(() -> UserId.isValid_delegate$lambda$0(this));
        this.isReasonable$delegate = LazyKt.lazy(() -> UserId.isReasonable_delegate$lambda$1(this));
    }

    @NotNull
    public final String getFull() {
        return this.full;
    }

    public UserId(@NotNull String localpart, @NotNull String domain) {
        Intrinsics.checkNotNullParameter((Object)localpart, (String)"localpart");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        this("@" + localpart + ":" + domain);
    }

    @NotNull
    public final String getLocalpart() {
        char[] cArray = new char[]{'@'};
        return StringsKt.substringBefore$default((String)StringsKt.trimStart((String)this.full, (char[])cArray), (char)':', null, (int)2, null);
    }

    @NotNull
    public final String getDomain() {
        char[] cArray = new char[]{'@'};
        return StringsKt.substringAfter$default((String)StringsKt.trimStart((String)this.full, (char[])cArray), (char)':', null, (int)2, null);
    }

    public final boolean isValid() {
        Lazy lazy = this.isValid$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isReasonable() {
        Lazy lazy = this.isReasonable$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return this.full;
    }

    @NotNull
    public final String component1() {
        return this.full;
    }

    @NotNull
    public final UserId copy(@NotNull String full) {
        Intrinsics.checkNotNullParameter((Object)full, (String)"full");
        return new UserId(full);
    }

    public static /* synthetic */ UserId copy$default(UserId userId, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = userId.full;
        }
        return userId.copy(string);
    }

    public int hashCode() {
        return this.full.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UserId)) {
            return false;
        }
        UserId userId = (UserId)other;
        return Intrinsics.areEqual((Object)this.full, (Object)userId.full);
    }

    private static final boolean isValid_delegate$lambda$0(UserId this$0) {
        return Companion.isValid(this$0.full);
    }

    private static final boolean isReasonable_delegate$lambda$1(UserId this$0) {
        return Companion.isReasonable(this$0.full);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/folivo/trixnity/core/model/UserId$Companion;", "", "<init>", "()V", "sigilCharacter", "", "isValid", "", "id", "", "isReasonable", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/folivo/trixnity/core/model/UserId;", "trixnity-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isValid(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (id.length() > 255) return false;
            CharSequence charSequence = id;
            if (!MatrixIdRegex.INSTANCE.getUserId().matches(charSequence)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isReasonable(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (id.length() > 255) return false;
            CharSequence charSequence = id;
            if (!MatrixIdRegex.INSTANCE.getReasonableUserId().matches(charSequence)) return false;
            return true;
        }

        @NotNull
        public final KSerializer<UserId> serializer() {
            return UserIdSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

