/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.trixnity.core.model.keys;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.json.JsonElement;
import net.folivo.trixnity.core.model.UserId;
import net.folivo.trixnity.core.model.keys.Curve25519KeySerializer;
import net.folivo.trixnity.core.model.keys.Ed25519KeySerializer;
import net.folivo.trixnity.core.model.keys.KeyAlgorithm;
import net.folivo.trixnity.core.model.keys.Keys;
import net.folivo.trixnity.core.model.keys.Signed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u000e\u000f\u0010\u0011R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u0082\u0001\u0004\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lnet/folivo/trixnity/core/model/keys/Key;", "", "algorithm", "Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm;", "getAlgorithm", "()Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm;", "fullKeyId", "", "getFullKeyId", "()Ljava/lang/String;", "keyId", "getKeyId", "value", "getValue", "Curve25519Key", "Ed25519Key", "SignedCurve25519Key", "UnknownKey", "Lnet/folivo/trixnity/core/model/keys/Key$Curve25519Key;", "Lnet/folivo/trixnity/core/model/keys/Key$Ed25519Key;", "Lnet/folivo/trixnity/core/model/keys/Key$SignedCurve25519Key;", "Lnet/folivo/trixnity/core/model/keys/Key$UnknownKey;", "trixnity-core"})
public interface Key {
    @NotNull
    public KeyAlgorithm getAlgorithm();

    @Nullable
    public String getKeyId();

    @NotNull
    public String getValue();

    @Nullable
    public String getFullKeyId();

    @Serializable(with=Curve25519KeySerializer.class)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB/\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J:\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lnet/folivo/trixnity/core/model/keys/Key$Curve25519Key;", "Lnet/folivo/trixnity/core/model/keys/Key;", "keyId", "", "value", "fallback", "", "algorithm", "Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$Curve25519;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$Curve25519;)V", "getAlgorithm", "()Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$Curve25519;", "getFallback", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getKeyId", "()Ljava/lang/String;", "getValue", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$Curve25519;)Lnet/folivo/trixnity/core/model/keys/Key$Curve25519Key;", "equals", "other", "", "hashCode", "", "toString", "Companion", "trixnity-core"})
    public static final class Curve25519Key
    implements Key {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String keyId;
        @NotNull
        private final String value;
        @Nullable
        private final Boolean fallback;
        @NotNull
        private final KeyAlgorithm.Curve25519 algorithm;

        public Curve25519Key(@Nullable String keyId, @NotNull String value, @Nullable Boolean fallback, @NotNull KeyAlgorithm.Curve25519 algorithm) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            this.keyId = keyId;
            this.value = value;
            this.fallback = fallback;
            this.algorithm = algorithm;
        }

        public /* synthetic */ Curve25519Key(String string, String string2, Boolean bl, KeyAlgorithm.Curve25519 curve25519, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                bl = null;
            }
            if ((n & 8) != 0) {
                curve25519 = KeyAlgorithm.Curve25519.INSTANCE;
            }
            this(string, string2, bl, curve25519);
        }

        @Override
        @Nullable
        public String getKeyId() {
            return this.keyId;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @Nullable
        public final Boolean getFallback() {
            return this.fallback;
        }

        @Override
        @NotNull
        public KeyAlgorithm.Curve25519 getAlgorithm() {
            return this.algorithm;
        }

        @Override
        @Nullable
        public String getFullKeyId() {
            return DefaultImpls.getFullKeyId(this);
        }

        @Nullable
        public final String component1() {
            return this.keyId;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @Nullable
        public final Boolean component3() {
            return this.fallback;
        }

        @NotNull
        public final KeyAlgorithm.Curve25519 component4() {
            return this.algorithm;
        }

        @NotNull
        public final Curve25519Key copy(@Nullable String keyId, @NotNull String value, @Nullable Boolean fallback, @NotNull KeyAlgorithm.Curve25519 algorithm) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            return new Curve25519Key(keyId, value, fallback, algorithm);
        }

        public static /* synthetic */ Curve25519Key copy$default(Curve25519Key curve25519Key, String string, String string2, Boolean bl, KeyAlgorithm.Curve25519 curve25519, int n, Object object) {
            if ((n & 1) != 0) {
                string = curve25519Key.keyId;
            }
            if ((n & 2) != 0) {
                string2 = curve25519Key.value;
            }
            if ((n & 4) != 0) {
                bl = curve25519Key.fallback;
            }
            if ((n & 8) != 0) {
                curve25519 = curve25519Key.algorithm;
            }
            return curve25519Key.copy(string, string2, bl, curve25519);
        }

        @NotNull
        public String toString() {
            return "Curve25519Key(keyId=" + this.keyId + ", value=" + this.value + ", fallback=" + this.fallback + ", algorithm=" + this.algorithm + ")";
        }

        public int hashCode() {
            int result = this.keyId == null ? 0 : this.keyId.hashCode();
            result = result * 31 + this.value.hashCode();
            result = result * 31 + (this.fallback == null ? 0 : ((Object)this.fallback).hashCode());
            result = result * 31 + this.algorithm.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Curve25519Key)) {
                return false;
            }
            Curve25519Key curve25519Key = (Curve25519Key)other;
            if (!Intrinsics.areEqual((Object)this.keyId, (Object)curve25519Key.keyId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)curve25519Key.value)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fallback, (Object)curve25519Key.fallback)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.algorithm, (Object)curve25519Key.algorithm);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lnet/folivo/trixnity/core/model/keys/Key$Curve25519Key$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/folivo/trixnity/core/model/keys/Key$Curve25519Key;", "trixnity-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Curve25519Key> serializer() {
                return Curve25519KeySerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static String getFullKeyId(@NotNull Key $this) {
            return $this.getKeyId() != null ? $this.getAlgorithm().getName() + ":" + $this.getKeyId() : null;
        }
    }

    @Serializable(with=Ed25519KeySerializer.class)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B#\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lnet/folivo/trixnity/core/model/keys/Key$Ed25519Key;", "Lnet/folivo/trixnity/core/model/keys/Key;", "keyId", "", "value", "algorithm", "Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$Ed25519;", "(Ljava/lang/String;Ljava/lang/String;Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$Ed25519;)V", "getAlgorithm", "()Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$Ed25519;", "getKeyId", "()Ljava/lang/String;", "getValue", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "trixnity-core"})
    public static final class Ed25519Key
    implements Key {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String keyId;
        @NotNull
        private final String value;
        @NotNull
        private final KeyAlgorithm.Ed25519 algorithm;

        public Ed25519Key(@Nullable String keyId, @NotNull String value, @NotNull KeyAlgorithm.Ed25519 algorithm) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            this.keyId = keyId;
            this.value = value;
            this.algorithm = algorithm;
        }

        public /* synthetic */ Ed25519Key(String string, String string2, KeyAlgorithm.Ed25519 ed25519, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                ed25519 = KeyAlgorithm.Ed25519.INSTANCE;
            }
            this(string, string2, ed25519);
        }

        @Override
        @Nullable
        public String getKeyId() {
            return this.keyId;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public KeyAlgorithm.Ed25519 getAlgorithm() {
            return this.algorithm;
        }

        @Override
        @Nullable
        public String getFullKeyId() {
            return DefaultImpls.getFullKeyId(this);
        }

        @Nullable
        public final String component1() {
            return this.keyId;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final KeyAlgorithm.Ed25519 component3() {
            return this.algorithm;
        }

        @NotNull
        public final Ed25519Key copy(@Nullable String keyId, @NotNull String value, @NotNull KeyAlgorithm.Ed25519 algorithm) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            return new Ed25519Key(keyId, value, algorithm);
        }

        public static /* synthetic */ Ed25519Key copy$default(Ed25519Key ed25519Key, String string, String string2, KeyAlgorithm.Ed25519 ed25519, int n, Object object) {
            if ((n & 1) != 0) {
                string = ed25519Key.keyId;
            }
            if ((n & 2) != 0) {
                string2 = ed25519Key.value;
            }
            if ((n & 4) != 0) {
                ed25519 = ed25519Key.algorithm;
            }
            return ed25519Key.copy(string, string2, ed25519);
        }

        @NotNull
        public String toString() {
            return "Ed25519Key(keyId=" + this.keyId + ", value=" + this.value + ", algorithm=" + this.algorithm + ")";
        }

        public int hashCode() {
            int result = this.keyId == null ? 0 : this.keyId.hashCode();
            result = result * 31 + this.value.hashCode();
            result = result * 31 + this.algorithm.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Ed25519Key)) {
                return false;
            }
            Ed25519Key ed25519Key = (Ed25519Key)other;
            if (!Intrinsics.areEqual((Object)this.keyId, (Object)ed25519Key.keyId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)ed25519Key.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.algorithm, (Object)ed25519Key.algorithm);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lnet/folivo/trixnity/core/model/keys/Key$Ed25519Key$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/folivo/trixnity/core/model/keys/Key$Ed25519Key;", "trixnity-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Ed25519Key> serializer() {
                return Ed25519KeySerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002BM\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u001c\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\u0004`\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lnet/folivo/trixnity/core/model/keys/Key$SignedCurve25519Key;", "Lnet/folivo/trixnity/core/model/keys/Key;", "Lnet/folivo/trixnity/core/model/keys/Signed;", "Lnet/folivo/trixnity/core/model/keys/Key$Curve25519Key;", "Lnet/folivo/trixnity/core/model/UserId;", "keyId", "", "value", "signatures", "", "Lnet/folivo/trixnity/core/model/keys/Keys;", "Lnet/folivo/trixnity/core/model/keys/Signatures;", "fallback", "", "algorithm", "Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$SignedCurve25519;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Boolean;Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$SignedCurve25519;)V", "getAlgorithm", "()Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$SignedCurve25519;", "getFallback", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getKeyId", "()Ljava/lang/String;", "getValue", "trixnity-core"})
    public static final class SignedCurve25519Key
    extends Signed<Curve25519Key, UserId>
    implements Key {
        @Nullable
        private final String keyId;
        @NotNull
        private final String value;
        @Nullable
        private final Boolean fallback;
        @NotNull
        private final KeyAlgorithm.SignedCurve25519 algorithm;

        public SignedCurve25519Key(@Nullable String keyId, @NotNull String value, @NotNull Map<UserId, Keys> signatures, @Nullable Boolean fallback, @NotNull KeyAlgorithm.SignedCurve25519 algorithm) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(signatures, (String)"signatures");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            super(new Curve25519Key(keyId, value, fallback, null, 8, null), signatures);
            this.keyId = keyId;
            this.value = value;
            this.fallback = fallback;
            this.algorithm = algorithm;
        }

        public /* synthetic */ SignedCurve25519Key(String string, String string2, Map map, Boolean bl, KeyAlgorithm.SignedCurve25519 signedCurve25519, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 8) != 0) {
                bl = null;
            }
            if ((n & 0x10) != 0) {
                signedCurve25519 = KeyAlgorithm.SignedCurve25519.INSTANCE;
            }
            this(string, string2, map, bl, signedCurve25519);
        }

        @Override
        @Nullable
        public String getKeyId() {
            return this.keyId;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @Nullable
        public final Boolean getFallback() {
            return this.fallback;
        }

        @Override
        @NotNull
        public KeyAlgorithm.SignedCurve25519 getAlgorithm() {
            return this.algorithm;
        }

        @Override
        @Nullable
        public String getFullKeyId() {
            return DefaultImpls.getFullKeyId(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001d"}, d2={"Lnet/folivo/trixnity/core/model/keys/Key$UnknownKey;", "Lnet/folivo/trixnity/core/model/keys/Key;", "keyId", "", "value", "raw", "Lkotlinx/serialization/json/JsonElement;", "algorithm", "Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$Unknown;", "(Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/json/JsonElement;Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$Unknown;)V", "getAlgorithm", "()Lnet/folivo/trixnity/core/model/keys/KeyAlgorithm$Unknown;", "getKeyId", "()Ljava/lang/String;", "getRaw", "()Lkotlinx/serialization/json/JsonElement;", "getValue", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "trixnity-core"})
    public static final class UnknownKey
    implements Key {
        @Nullable
        private final String keyId;
        @NotNull
        private final String value;
        @NotNull
        private final JsonElement raw;
        @NotNull
        private final KeyAlgorithm.Unknown algorithm;

        public UnknownKey(@Nullable String keyId, @NotNull String value, @NotNull JsonElement raw, @NotNull KeyAlgorithm.Unknown algorithm) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            this.keyId = keyId;
            this.value = value;
            this.raw = raw;
            this.algorithm = algorithm;
        }

        public /* synthetic */ UnknownKey(String string, String string2, JsonElement jsonElement, KeyAlgorithm.Unknown unknown, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string, string2, jsonElement, unknown);
        }

        @Override
        @Nullable
        public String getKeyId() {
            return this.keyId;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @NotNull
        public final JsonElement getRaw() {
            return this.raw;
        }

        @Override
        @NotNull
        public KeyAlgorithm.Unknown getAlgorithm() {
            return this.algorithm;
        }

        @Override
        @Nullable
        public String getFullKeyId() {
            return DefaultImpls.getFullKeyId(this);
        }

        @Nullable
        public final String component1() {
            return this.keyId;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final JsonElement component3() {
            return this.raw;
        }

        @NotNull
        public final KeyAlgorithm.Unknown component4() {
            return this.algorithm;
        }

        @NotNull
        public final UnknownKey copy(@Nullable String keyId, @NotNull String value, @NotNull JsonElement raw, @NotNull KeyAlgorithm.Unknown algorithm) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            return new UnknownKey(keyId, value, raw, algorithm);
        }

        public static /* synthetic */ UnknownKey copy$default(UnknownKey unknownKey, String string, String string2, JsonElement jsonElement, KeyAlgorithm.Unknown unknown, int n, Object object) {
            if ((n & 1) != 0) {
                string = unknownKey.keyId;
            }
            if ((n & 2) != 0) {
                string2 = unknownKey.value;
            }
            if ((n & 4) != 0) {
                jsonElement = unknownKey.raw;
            }
            if ((n & 8) != 0) {
                unknown = unknownKey.algorithm;
            }
            return unknownKey.copy(string, string2, jsonElement, unknown);
        }

        @NotNull
        public String toString() {
            return "UnknownKey(keyId=" + this.keyId + ", value=" + this.value + ", raw=" + this.raw + ", algorithm=" + this.algorithm + ")";
        }

        public int hashCode() {
            int result = this.keyId == null ? 0 : this.keyId.hashCode();
            result = result * 31 + this.value.hashCode();
            result = result * 31 + this.raw.hashCode();
            result = result * 31 + this.algorithm.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnknownKey)) {
                return false;
            }
            UnknownKey unknownKey = (UnknownKey)other;
            if (!Intrinsics.areEqual((Object)this.keyId, (Object)unknownKey.keyId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)unknownKey.value)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.raw, (Object)unknownKey.raw)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.algorithm, (Object)unknownKey.algorithm);
        }
    }
}

