package net.folivo.trixnity.core.serialization.events

import kotlinx.serialization.KSerializer
import net.folivo.trixnity.core.model.events.EventContent
import net.folivo.trixnity.core.model.events.MessageEventContent
import net.folivo.trixnity.core.model.events.StateEventContent
import kotlin.reflect.KClass

interface EventContentSerializerMapping<C : EventContent> {
    val type: String
    val kClass: KClass<out C>
    val serializer: KSerializer<C>
}

class EventContentSerializerMappingImpl<C : EventContent>(
    override val type: String,
    override val kClass: KClass<out C>,
    serializer: KSerializer<out C>,
) : EventContentSerializerMapping<C> {
    override val serializer: KSerializer<C> =
        @Suppress("UNCHECKED_CAST")
        EventContentSerializer(type, serializer as KSerializer<C>)

    override fun toString(): String =
        "EventContentSerializerMapping(type=$type, kClass=$kClass, serializer=$serializer)"
}

class MessageEventContentSerializerMapping(
    override val type: String,
    override val kClass: KClass<out MessageEventContent>,
    serializer: KSerializer<out MessageEventContent>,
) : EventContentSerializerMapping<MessageEventContent> {
    override val serializer: KSerializer<MessageEventContent> =
        @Suppress("UNCHECKED_CAST")
        MessageEventContentSerializer(type, serializer as KSerializer<MessageEventContent>)

    override fun toString(): String =
        "MessageEventContentSerializerMapping(type=$type, kClass=$kClass, serializer=$serializer)"
}

class StateEventContentSerializerMapping(
    override val type: String,
    override val kClass: KClass<out StateEventContent>,
    serializer: KSerializer<out StateEventContent>,
) : EventContentSerializerMapping<StateEventContent> {
    override val serializer: KSerializer<StateEventContent> =
        @Suppress("UNCHECKED_CAST")
        StateEventContentSerializer(type, serializer as KSerializer<StateEventContent>)

    override fun toString(): String =
        "StateEventContentSerializerMapping(type=$type, kClass=$kClass, serializer=$serializer)"
}