/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.trixnity.core.model;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.folivo.trixnity.core.model.RoomAliasId;
import net.folivo.trixnity.core.model.RoomId;
import net.folivo.trixnity.core.model.UserId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId;", "", "full", "", "sigilCharacter", "", "(Ljava/lang/String;C)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;C)V", "getDomain", "()Ljava/lang/String;", "getFull", "getLocalpart", "getSigilCharacter", "()C", "equals", "", "other", "hashCode", "", "toString", "Companion", "trixnity-core"})
public abstract class MatrixId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String full;
    private final char sigilCharacter;
    @NotNull
    private final String localpart;
    @NotNull
    private final String domain;

    @NotNull
    public final String getFull() {
        return this.full;
    }

    public final char getSigilCharacter() {
        return this.sigilCharacter;
    }

    @NotNull
    public final String getLocalpart() {
        return this.localpart;
    }

    @NotNull
    public final String getDomain() {
        return this.domain;
    }

    public MatrixId(@NotNull String full, char sigilCharacter) {
        Intrinsics.checkNotNullParameter((Object)full, (String)"full");
        this.full = full;
        this.sigilCharacter = sigilCharacter;
        char[] cArray = new char[]{sigilCharacter};
        String s = StringsKt.trimStart((String)full, (char[])cArray);
        this.localpart = StringsKt.substringBefore$default((String)s, (char)':', null, (int)2, null);
        this.domain = StringsKt.substringAfter((String)s, (char)':', (String)"");
        if (((CharSequence)full).length() == 0) {
            throw new IllegalArgumentException("matrix identifier must not be empty");
        }
        if (sigilCharacter != StringsKt.first((CharSequence)full)) {
            throw new IllegalArgumentException("given sigil character " + sigilCharacter + " does not match with full string " + full);
        }
        if (((CharSequence)this.localpart).length() == 0) {
            throw new IllegalArgumentException("localpart must not be empty");
        }
        if (((CharSequence)this.domain).length() == 0) {
            throw new IllegalArgumentException("domain must not be empty");
        }
    }

    public MatrixId(@NotNull String localpart, @NotNull String domain, char sigilCharacter) {
        Intrinsics.checkNotNullParameter((Object)localpart, (String)"localpart");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        this.full = sigilCharacter + localpart + ":" + domain;
        this.sigilCharacter = sigilCharacter;
        this.localpart = localpart;
        this.domain = domain;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MatrixId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((MatrixId)other).full, (Object)this.full);
    }

    public int hashCode() {
        return this.full.hashCode();
    }

    @NotNull
    public String toString() {
        return this.full;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId$Companion;", "", "()V", "of", "Lnet/folivo/trixnity/core/model/MatrixId;", "full", "", "trixnity-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MatrixId of(@NotNull String full) {
            MatrixId matrixId;
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            if (((CharSequence)full).length() == 0) {
                throw new IllegalArgumentException("matrix identifier must not be empty");
            }
            char c = StringsKt.first((CharSequence)full);
            if (c == '@') {
                matrixId = new UserId(full);
            } else if (c == '!') {
                matrixId = new RoomId(full);
            } else if (c == '#') {
                matrixId = new RoomAliasId(full);
            } else {
                throw new IllegalArgumentException("not a valid matrix identifier");
            }
            return matrixId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

