/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.trixnity.core.model;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import net.folivo.trixnity.core.serialization.MatrixIdSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=MatrixIdSerializer.class)
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00162\u00020\u0001:\u0005\u0016\u0017\u0018\u0019\u001aB\u0017\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0004\u001b\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId;", "", "full", "", "sigilCharacter", "", "(Ljava/lang/String;C)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;C)V", "getDomain", "()Ljava/lang/String;", "getFull", "getLocalpart", "getSigilCharacter", "()C", "equals", "", "other", "hashCode", "", "toString", "Companion", "EventId", "RoomAliasId", "RoomId", "UserId", "Lnet/folivo/trixnity/core/model/MatrixId$UserId;", "Lnet/folivo/trixnity/core/model/MatrixId$RoomId;", "Lnet/folivo/trixnity/core/model/MatrixId$RoomAliasId;", "Lnet/folivo/trixnity/core/model/MatrixId$EventId;", "trixnity-core"})
public abstract class MatrixId {
    @NotNull
    private final String full;
    private final char sigilCharacter;
    @NotNull
    private final String localpart;
    @NotNull
    private final String domain;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getFull() {
        return this.full;
    }

    public final char getSigilCharacter() {
        return this.sigilCharacter;
    }

    @NotNull
    public final String getLocalpart() {
        return this.localpart;
    }

    @NotNull
    public final String getDomain() {
        return this.domain;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MatrixId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((MatrixId)other).full, (Object)this.full);
    }

    public int hashCode() {
        return this.full.hashCode();
    }

    @NotNull
    public String toString() {
        return this.full;
    }

    private MatrixId(String full, char sigilCharacter) {
        this.full = full;
        this.sigilCharacter = sigilCharacter;
        String s = StringsKt.trimStart((String)full, (char[])new char[]{sigilCharacter});
        this.localpart = StringsKt.substringBefore$default((String)s, (char)':', null, (int)2, null);
        this.domain = StringsKt.substringAfter$default((String)s, (char)':', null, (int)2, null);
        CharSequence charSequence = full;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("matrix identifier must not be empty");
        }
        if (sigilCharacter != StringsKt.first((CharSequence)full)) {
            throw (Throwable)new IllegalArgumentException("given sigil character " + sigilCharacter + " does not match with full string " + full);
        }
        charSequence = this.localpart;
        bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("localpart must not be empty");
        }
        charSequence = this.domain;
        bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("domain must not be empty");
        }
    }

    private MatrixId(String localpart, String domain, char sigilCharacter) {
        this.full = sigilCharacter + localpart + ':' + domain;
        this.sigilCharacter = sigilCharacter;
        this.localpart = localpart;
        this.domain = domain;
    }

    public /* synthetic */ MatrixId(String full, char sigilCharacter, DefaultConstructorMarker $constructor_marker) {
        this(full, sigilCharacter);
    }

    public /* synthetic */ MatrixId(String localpart, String domain, char sigilCharacter, DefaultConstructorMarker $constructor_marker) {
        this(localpart, domain, sigilCharacter);
    }

    @Serializable(with=MatrixIdSerializer.class)
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId$UserId;", "Lnet/folivo/trixnity/core/model/MatrixId;", "full", "", "(Ljava/lang/String;)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;)V", "Companion", "trixnity-core"})
    public static final class UserId
    extends MatrixId {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public UserId(@NotNull String full) {
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            super(full, '@', null);
        }

        public UserId(@NotNull String localpart, @NotNull String domain) {
            Intrinsics.checkNotNullParameter((Object)localpart, (String)"localpart");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            super(localpart, domain, '@', null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId$UserId$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/folivo/trixnity/core/model/MatrixId$UserId;", "trixnity-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @NotNull
            public final KSerializer<UserId> serializer() {
                return MatrixIdSerializer.INSTANCE;
            }
        }
    }

    @Serializable(with=MatrixIdSerializer.class)
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId$RoomId;", "Lnet/folivo/trixnity/core/model/MatrixId;", "full", "", "(Ljava/lang/String;)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;)V", "Companion", "trixnity-core"})
    public static final class RoomId
    extends MatrixId {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public RoomId(@NotNull String full) {
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            super(full, '!', null);
        }

        public RoomId(@NotNull String localpart, @NotNull String domain) {
            Intrinsics.checkNotNullParameter((Object)localpart, (String)"localpart");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            super(localpart, domain, '!', null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId$RoomId$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/folivo/trixnity/core/model/MatrixId$RoomId;", "trixnity-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @NotNull
            public final KSerializer<RoomId> serializer() {
                return MatrixIdSerializer.INSTANCE;
            }
        }
    }

    @Serializable(with=MatrixIdSerializer.class)
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId$RoomAliasId;", "Lnet/folivo/trixnity/core/model/MatrixId;", "full", "", "(Ljava/lang/String;)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;)V", "Companion", "trixnity-core"})
    public static final class RoomAliasId
    extends MatrixId {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public RoomAliasId(@NotNull String full) {
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            super(full, '#', null);
        }

        public RoomAliasId(@NotNull String localpart, @NotNull String domain) {
            Intrinsics.checkNotNullParameter((Object)localpart, (String)"localpart");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            super(localpart, domain, '#', null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId$RoomAliasId$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/folivo/trixnity/core/model/MatrixId$RoomAliasId;", "trixnity-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @NotNull
            public final KSerializer<RoomAliasId> serializer() {
                return MatrixIdSerializer.INSTANCE;
            }
        }
    }

    @Serializable(with=MatrixIdSerializer.class)
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId$EventId;", "Lnet/folivo/trixnity/core/model/MatrixId;", "full", "", "(Ljava/lang/String;)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;)V", "Companion", "trixnity-core"})
    public static final class EventId
    extends MatrixId {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public EventId(@NotNull String full) {
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            super(full, '$', null);
        }

        public EventId(@NotNull String localpart, @NotNull String domain) {
            Intrinsics.checkNotNullParameter((Object)localpart, (String)"localpart");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            super(localpart, domain, '$', null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId$EventId$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/folivo/trixnity/core/model/MatrixId$EventId;", "trixnity-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @NotNull
            public final KSerializer<EventId> serializer() {
                return MatrixIdSerializer.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u00c6\u0001\u00a8\u0006\t"}, d2={"Lnet/folivo/trixnity/core/model/MatrixId$Companion;", "", "()V", "of", "Lnet/folivo/trixnity/core/model/MatrixId;", "full", "", "serializer", "Lkotlinx/serialization/KSerializer;", "trixnity-core"})
    public static final class Companion {
        @NotNull
        public final MatrixId of(@NotNull String full) {
            MatrixId matrixId;
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            CharSequence charSequence = full;
            boolean bl = false;
            if (charSequence.length() == 0) {
                throw (Throwable)new IllegalArgumentException("matrix identifier must not be empty");
            }
            switch (StringsKt.first((CharSequence)full)) {
                case '@': {
                    matrixId = new UserId(full);
                    break;
                }
                case '!': {
                    matrixId = new RoomId(full);
                    break;
                }
                case '#': {
                    matrixId = new RoomAliasId(full);
                    break;
                }
                case '$': {
                    matrixId = new EventId(full);
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("not a valid matrix identifier");
                }
            }
            return matrixId;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @NotNull
        public final KSerializer<MatrixId> serializer() {
            return MatrixIdSerializer.INSTANCE;
        }
    }
}

