package net.folivo.trixnity.client.store.sqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.String
import kotlin.Unit

public interface RoomTimelineQueries : Transacter {
  public fun getTimelineEvent(event_id: String, room_id: String): Query<String>

  public fun <T : Any> getTimelineEventRelation(
    related_event_id: String,
    room_id: String,
    mapper: (
      event_id: String,
      room_id: String,
      relation_type: String,
      related_event_id: String
    ) -> T
  ): Query<T>

  public fun getTimelineEventRelation(related_event_id: String, room_id: String):
      Query<Sql_room_timeline_event_relation>

  public fun <T : Any> getTimelineEventRelationByRelationType(
    related_event_id: String,
    room_id: String,
    relation_type: String,
    mapper: (
      event_id: String,
      room_id: String,
      relation_type: String,
      related_event_id: String
    ) -> T
  ): Query<T>

  public fun getTimelineEventRelationByRelationType(
    related_event_id: String,
    room_id: String,
    relation_type: String
  ): Query<Sql_room_timeline_event_relation>

  public fun saveTimelineEvent(
    event_id: String,
    room_id: String,
    timeline_event: String
  ): Unit

  public fun deleteTimelineEvent(event_id: String, room_id: String): Unit

  public fun deleteAllTimelineEvents(): Unit

  public
      fun saveTimelineEventRelation(sql_room_timeline_event_relation: Sql_room_timeline_event_relation):
      Unit

  public fun deleteTimelineEventRelation(related_event_id: String, room_id: String): Unit

  public fun deleteTimelineEventRelationByRelationType(
    related_event_id: String,
    room_id: String,
    relation_type: String
  ): Unit

  public fun deleteAllTimelineEventRelations(): Unit
}
