package net.folivo.trixnity.client.store.sqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface KeysQueries : Transacter {
  public fun getDeviceKeys(user_id: String): Query<String>

  public fun getCrossSigningKeys(user_id: String): Query<String>

  public fun <T : Any> getOutdatedDeviceKeys(id: Long,
      mapper: (outdated_device_keys: String?) -> T): Query<T>

  public fun getOutdatedDeviceKeys(id: Long): Query<GetOutdatedDeviceKeys>

  public fun getKeyVerificationState(key_id: String, key_algorithm: String): Query<String>

  public fun <T : Any> getKeyChainLinkBySigningKey(
    signing_user_id: String,
    signing_key_id: String,
    signing_key_value: String,
    mapper: (
      signing_user_id: String,
      signing_key_id: String,
      signing_key_value: String,
      signed_user_id: String,
      signed_key_id: String,
      signed_key_value: String
    ) -> T
  ): Query<T>

  public fun getKeyChainLinkBySigningKey(
    signing_user_id: String,
    signing_key_id: String,
    signing_key_value: String
  ): Query<Sql_key_chain_link>

  public fun <T : Any> getSecrets(id: Long, mapper: (secrets: String?) -> T): Query<T>

  public fun getSecrets(id: Long): Query<GetSecrets>

  public fun <T : Any> getAllSecretKeyRequests(mapper: (id: String,
      secret_key_request: String) -> T): Query<T>

  public fun getAllSecretKeyRequests(): Query<Sql_secret_key_request>

  public fun <T : Any> getSecretKeyRequest(id: String, mapper: (id: String,
      secret_key_request: String) -> T): Query<T>

  public fun getSecretKeyRequest(id: String): Query<Sql_secret_key_request>

  public fun saveDeviceKeys(user_id: String, device_keys: String): Unit

  public fun deleteDeviceKeys(user_id: String): Unit

  public fun deleteAllDeviceKeys(): Unit

  public fun saveCrossSigningKeys(user_id: String, cross_signing_keys: String): Unit

  public fun deleteCrossSigningKeys(user_id: String): Unit

  public fun deleteAllCrossSigningKeys(): Unit

  public fun saveOutdatedDeviceKeys(sql_outdated_device_keys: Sql_outdated_device_keys): Unit

  public fun deleteOutdatedDeviceKeys(id: Long): Unit

  public fun deleteAllOutdatedDeviceKeys(): Unit

  public fun saveKeyVerificationState(sql_key_verification_state: Sql_key_verification_state): Unit

  public fun deleteKeyVerificationState(key_id: String, key_algorithm: String): Unit

  public fun deleteAllKeyVerificationStates(): Unit

  public fun saveKeyChainLink(sql_key_chain_link: Sql_key_chain_link): Unit

  public fun deleteKeyChainLinkBySignedgKey(
    signed_user_id: String,
    signed_key_id: String,
    signed_key_value: String
  ): Unit

  public fun deleteAllKeyChainLinks(): Unit

  public fun saveSecrets(sql_secrets: Sql_secrets): Unit

  public fun deleteSecrets(id: Long): Unit

  public fun deleteAllSecrets(): Unit

  public fun saveSecretKeyRequest(id: String, secret_key_request: String): Unit

  public fun deleteSecretKeyRequest(id: String): Unit

  public fun deleteAllSecretKeyRequests(): Unit
}
