package net.folivo.trixnity.client.store.sqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.String
import kotlin.Unit

public interface RoomUserQueries : Transacter {
  public fun getRoomUser(room_id: String, user_id: String): Query<String>

  public fun <T : Any> getRoomUsers(room_id: String, mapper: (
    room_id: String,
    user_id: String,
    room_user: String
  ) -> T): Query<T>

  public fun getRoomUsers(room_id: String): Query<Sql_room_user>

  public fun saveRoomUser(
    room_id: String,
    user_id: String,
    room_user: String
  ): Unit

  public fun deleteRoomUser(room_id: String, user_id: String): Unit

  public fun deleteRoomUsers(room_id: String): Unit

  public fun deleteAllRoomUsers(): Unit
}
