package net.folivo.trixnity.client.store.sqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.ByteArray
import kotlin.String
import kotlin.Unit

public interface MediaQueries : Transacter {
  public fun getMedia(url: String): Query<ByteArray>

  public fun <T : Any> getUploadMedia(cache_uri: String, mapper: (
    cache_uri: String,
    mxc_uri: String?,
    content_type: String?
  ) -> T): Query<T>

  public fun getUploadMedia(cache_uri: String): Query<Sql_upload_media>

  public fun saveMedia(url: String, media: ByteArray): Unit

  public fun deleteMedia(url: String): Unit

  public fun deleteAllMedia(): Unit

  public fun saveUploadMedia(
    cache_uri: String,
    mxc_uri: String?,
    content_type: String?
  ): Unit

  public fun deleteUploadMedia(cache_uri: String): Unit

  public fun deleteAllUploadMedia(): Unit

  public fun changeUri(
    url: String,
    url_: String,
    url__: String
  ): Unit
}
