package net.folivo.trixnity.client.store.sqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface AccountQueries : Transacter {
  public fun <T : Any> getAccount(id: Long, mapper: (
    id: Long,
    olm_pickle_key: String?,
    base_url: String?,
    user_id: String?,
    device_id: String?,
    access_token: String?,
    sync_batch_token: String?,
    filter_id: String?,
    background_filter_id: String?,
    display_name: String?,
    avatar_url: String?
  ) -> T): Query<T>

  public fun getAccount(id: Long): Query<Sql_account>

  public fun saveAccount(sql_account: Sql_account): Unit

  public fun deleteAccount(id: Long): Unit

  public fun deleteAllAccounts(): Unit
}
