package net.folivo.trixnity.client.store.sqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.String
import kotlin.Unit

public interface RoomQueries : Transacter {
  public fun <T : Any> getAllRooms(mapper: (room_id: String, room: String) -> T): Query<T>

  public fun getAllRooms(): Query<Sql_room>

  public fun <T : Any> getRoom(room_id: String, mapper: (room_id: String, room: String) -> T):
      Query<T>

  public fun getRoom(room_id: String): Query<Sql_room>

  public fun saveRoom(room_id: String, room: String): Unit

  public fun deleteRoom(room_id: String): Unit

  public fun deleteAllRooms(): Unit
}
