package net.folivo.trixnity.client.store.sqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Boolean
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface OlmQueries : Transacter {
  public fun <T : Any> getOlmAccount(id: Long, mapper: (pickled_account: String?) -> T): Query<T>

  public fun getOlmAccount(id: Long): Query<GetOlmAccount>

  public fun getOlmSessions(sender_key: String): Query<String>

  public fun <T : Any> getInboundMegolmSession(
    sender_key: String,
    session_id: String,
    room_id: String,
    mapper: (
      sender_key: String,
      session_id: String,
      room_id: String,
      first_known_index: Long,
      has_been_backed_up: Boolean,
      is_trusted: Boolean,
      sender_signing_key: String,
      forwarding_curve25519_key_chain: String,
      pickled_session: String
    ) -> T
  ): Query<T>

  public fun getInboundMegolmSession(
    sender_key: String,
    session_id: String,
    room_id: String
  ): Query<Sql_inbound_megolm_session>

  public fun <T : Any> getNotBackedUpInboundMegolmSessions(mapper: (
    sender_key: String,
    session_id: String,
    room_id: String,
    first_known_index: Long,
    has_been_backed_up: Boolean,
    is_trusted: Boolean,
    sender_signing_key: String,
    forwarding_curve25519_key_chain: String,
    pickled_session: String
  ) -> T): Query<T>

  public fun getNotBackedUpInboundMegolmSessions(): Query<Sql_inbound_megolm_session>

  public fun <T : Any> getInboundMegolmSessionIndex(
    sender_key: String,
    session_id: String,
    room_id: String,
    message_index: Long,
    mapper: (
      sender_key: String,
      session_id: String,
      room_id: String,
      message_index: Long,
      event_id: String,
      origin_timestamp: Long
    ) -> T
  ): Query<T>

  public fun getInboundMegolmSessionIndex(
    sender_key: String,
    session_id: String,
    room_id: String,
    message_index: Long
  ): Query<Sql_inbound_megolm_session_index>

  public fun getOutboundMegolmSession(room_id: String): Query<String>

  public fun saveOlmAccount(id: Long?, pickled_account: String?): Unit

  public fun deleteOlmAccount(id: Long): Unit

  public fun deleteAllOlmAccounts(): Unit

  public fun saveOlmSessions(sender_key: String, olm_sessions: String): Unit

  public fun deleteOlmSessions(sender_key: String): Unit

  public fun deleteAllOlmSessions(): Unit

  public fun saveInboundMegolmSession(
    sender_key: String,
    session_id: String,
    room_id: String,
    first_known_index: Long,
    has_been_backed_up: Boolean,
    is_trusted: Boolean,
    sender_signing_key: String,
    forwarding_curve25519_key_chain: String,
    pickled_session: String
  ): Unit

  public fun deleteInboundMegolmSession(
    sender_key: String,
    session_id: String,
    room_id: String
  ): Unit

  public fun deleteAllInboundMegolmSessions(): Unit

  public fun saveInboundMegolmSessionIndex(
    sender_key: String,
    session_id: String,
    room_id: String,
    message_index: Long,
    event_id: String,
    origin_timestamp: Long
  ): Unit

  public fun deleteInboundMegolmSessionIndex(
    sender_key: String,
    session_id: String,
    room_id: String,
    message_index: Long
  ): Unit

  public fun deleteAllInboundMegolmSessionIndex(): Unit

  public fun saveOutboundMegolmSession(room_id: String, outbound_megolm_session: String): Unit

  public fun deleteOutboundMegolmSession(room_id: String): Unit

  public fun deleteAllOutboundMegolmSessions(): Unit
}
