package net.folivo.trixnity.client.store.sqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.String
import kotlin.Unit

public interface RoomAccountDataQueries : Transacter {
  public fun <T : Any> getRoomAccountData(
    room_id: String,
    type: String,
    mapper: (
      room_id: String,
      type: String,
      key: String,
      event: String
    ) -> T
  ): Query<T>

  public fun getRoomAccountData(room_id: String, type: String): Query<Sql_room_account_data>

  public fun <T : Any> getRoomAccountDataByKey(
    room_id: String,
    type: String,
    key: String,
    mapper: (
      room_id: String,
      type: String,
      key: String,
      event: String
    ) -> T
  ): Query<T>

  public fun getRoomAccountDataByKey(
    room_id: String,
    type: String,
    key: String
  ): Query<Sql_room_account_data>

  public fun saveRoomAccountData(
    room_id: String,
    type: String,
    key: String,
    event: String
  ): Unit

  public fun deleteRoomAccountData(room_id: String, type: String): Unit

  public fun deleteRoomAccountDataByKey(
    room_id: String,
    type: String,
    key: String
  ): Unit
}
