package net.folivo.trixnity.client.store.sqldelight.db.trixnityclientsqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.TransacterImpl
import com.squareup.sqldelight.`internal`.copyOnWriteList
import com.squareup.sqldelight.db.SqlCursor
import com.squareup.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.ByteArray
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.MutableList
import kotlin.reflect.KClass
import net.folivo.trixnity.client.store.sqldelight.AccountQueries
import net.folivo.trixnity.client.store.sqldelight.DeviceKeysQueries
import net.folivo.trixnity.client.store.sqldelight.GetOlmAccount
import net.folivo.trixnity.client.store.sqldelight.GetOutdatedDeviceKeys
import net.folivo.trixnity.client.store.sqldelight.GlobalAccountDataQueries
import net.folivo.trixnity.client.store.sqldelight.MediaQueries
import net.folivo.trixnity.client.store.sqldelight.OlmQueries
import net.folivo.trixnity.client.store.sqldelight.RoomAccountDataQueries
import net.folivo.trixnity.client.store.sqldelight.RoomOutboxMessageQueries
import net.folivo.trixnity.client.store.sqldelight.RoomQueries
import net.folivo.trixnity.client.store.sqldelight.RoomStateQueries
import net.folivo.trixnity.client.store.sqldelight.RoomTimelineQueries
import net.folivo.trixnity.client.store.sqldelight.RoomUserQueries
import net.folivo.trixnity.client.store.sqldelight.Sql_account
import net.folivo.trixnity.client.store.sqldelight.Sql_global_account_data
import net.folivo.trixnity.client.store.sqldelight.Sql_inbound_megolm_session_index
import net.folivo.trixnity.client.store.sqldelight.Sql_outdated_device_keys
import net.folivo.trixnity.client.store.sqldelight.Sql_room
import net.folivo.trixnity.client.store.sqldelight.Sql_room_account_data
import net.folivo.trixnity.client.store.sqldelight.Sql_room_outbox_message
import net.folivo.trixnity.client.store.sqldelight.Sql_room_state
import net.folivo.trixnity.client.store.sqldelight.Sql_room_user
import net.folivo.trixnity.client.store.sqldelight.Sql_upload_media
import net.folivo.trixnity.client.store.sqldelight.Sql_verified_keys
import net.folivo.trixnity.client.store.sqldelight.db.Database

internal val KClass<Database>.schema: SqlDriver.Schema
  get() = DatabaseImpl.Schema

internal fun KClass<Database>.newInstance(driver: SqlDriver): Database = DatabaseImpl(driver)

private class DatabaseImpl(
  driver: SqlDriver
) : TransacterImpl(driver), Database {
  public override val accountQueries: AccountQueriesImpl = AccountQueriesImpl(this, driver)

  public override val deviceKeysQueries: DeviceKeysQueriesImpl = DeviceKeysQueriesImpl(this, driver)

  public override val globalAccountDataQueries: GlobalAccountDataQueriesImpl =
      GlobalAccountDataQueriesImpl(this, driver)

  public override val mediaQueries: MediaQueriesImpl = MediaQueriesImpl(this, driver)

  public override val olmQueries: OlmQueriesImpl = OlmQueriesImpl(this, driver)

  public override val roomQueries: RoomQueriesImpl = RoomQueriesImpl(this, driver)

  public override val roomAccountDataQueries: RoomAccountDataQueriesImpl =
      RoomAccountDataQueriesImpl(this, driver)

  public override val roomOutboxMessageQueries: RoomOutboxMessageQueriesImpl =
      RoomOutboxMessageQueriesImpl(this, driver)

  public override val roomStateQueries: RoomStateQueriesImpl = RoomStateQueriesImpl(this, driver)

  public override val roomTimelineQueries: RoomTimelineQueriesImpl = RoomTimelineQueriesImpl(this,
      driver)

  public override val roomUserQueries: RoomUserQueriesImpl = RoomUserQueriesImpl(this, driver)

  public object Schema : SqlDriver.Schema {
    public override val version: Int
      get() = 1

    public override fun create(driver: SqlDriver): Unit {
      driver.execute(null, """
          |CREATE TABLE sql_room_account_data (
          |    room_id TEXT NOT NULL,
          |    type TEXT NOT NULL,
          |    event TEXT NOT NULL,
          |    PRIMARY KEY (room_id, type)
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_room_user (
          |  user_id TEXT NOT NULL,
          |  room_id TEXT NOT NULL,
          |  room_user TEXT NOT NULL,
          |  PRIMARY KEY(user_id,room_id)
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_olm_account (
          |  id INTEGER NOT NULL PRIMARY KEY,
          |  pickled_account TEXT
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_olm_sessions(
          |  sender_key TEXT PRIMARY KEY NOT NULL,
          |  olm_sessions TEXT NOT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_inbound_megolm_session(
          |  sender_key TEXT NOT NULL,
          |  session_id TEXT NOT NULL,
          |  room_id TEXT NOT NULL,
          |  pickled_session TEXT NOT NULL,
          |  PRIMARY KEY(sender_key, session_id, room_id)
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_inbound_megolm_session_index(
          |  sender_key TEXT NOT NULL,
          |  session_id TEXT NOT NULL,
          |  room_id TEXT NOT NULL,
          |  message_index INTEGER NOT NULL,
          |  event_id TEXT NOT NULL,
          |  origin_timestamp INTEGER NOT NULL,
          |  PRIMARY KEY(sender_key, session_id, room_id, message_index)
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_outbound_megolm_session(
          |  room_id TEXT PRIMARY KEY NOT NULL,
          |  outbound_megolm_session TEXT NOT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_room (
          |  room_id TEXT PRIMARY KEY NOT NULL,
          |  room TEXT NOT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_account (
          |  id INTEGER NOT NULL PRIMARY KEY,
          |  base_url TEXT,
          |  user_id TEXT,
          |  device_id TEXT,
          |  access_token TEXT,
          |  sync_batch_token TEXT,
          |  filter_id TEXT
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_media (
          |  url TEXT PRIMARY KEY NOT NULL,
          |  media BLOB NOT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_upload_media (
          |  cache_uri TEXT PRIMARY KEY NOT NULL,
          |  mxc_uri TEXT,
          |  content_type TEXT
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_room_state (
          |  room_id TEXT NOT NULL,
          |  type TEXT NOT NULL,
          |  state_key TEXT NOT NULL,
          |  event TEXT NOT NULL,
          |  PRIMARY KEY(room_id,type,state_key)
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_room_outbox_message (
          |  transaction_id TEXT PRIMARY KEY NOT NULL,
          |  room_id TEXT NOT NULL,
          |  type TEXT NOT NULL,
          |  content TEXT NOT NULL,
          |  sent_at INTEGER
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_device_keys(
          |  user_id TEXT PRIMARY KEY NOT NULL,
          |  device_keys TEXT NOT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_outdated_device_keys (
          |  id INTEGER NOT NULL PRIMARY KEY,
          |  outdated_device_keys TEXT
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_verified_keys (
          |    user_id TEXT NOT NULL,
          |    device_id TEXT,
          |    key_id TEXT NOT NULL,
          |    key_algorithm TEXT NOT NULL,
          |    key_value TEXT NOT NULL,
          |    PRIMARY KEY (user_id,device_id,key_algorithm,key_algorithm)
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_global_account_data (
          |    type TEXT NOT NULL PRIMARY KEY ,
          |    event TEXT NOT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE sql_room_timeline_event (
          |  event_id TEXT NOT NULL,
          |  room_id TEXT NOT NULL,
          |  timeline_event TEXT NOT NULL,
          |  PRIMARY KEY(event_id,room_id)
          |)
          """.trimMargin(), 0)
    }

    public override fun migrate(
      driver: SqlDriver,
      oldVersion: Int,
      newVersion: Int
    ): Unit {
    }
  }
}

private class RoomAccountDataQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), RoomAccountDataQueries {
  internal val getRoomAccountData: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> getRoomAccountData(
    room_id: String,
    type: String,
    mapper: (
      room_id: String,
      type: String,
      event: String
    ) -> T
  ): Query<T> = GetRoomAccountDataQuery(room_id, type) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!
    )
  }

  public override fun getRoomAccountData(room_id: String, type: String):
      Query<Sql_room_account_data> = getRoomAccountData(room_id, type) { room_id_, type_, event ->
    Sql_room_account_data(
      room_id_,
      type_,
      event
    )
  }

  public override fun saveRoomAccountData(
    room_id: String,
    type: String,
    event: String
  ): Unit {
    driver.execute(155622331, """
    |INSERT OR REPLACE INTO sql_room_account_data
    |VALUES (?, ?, ?)
    """.trimMargin(), 3) {
      bindString(1, room_id)
      bindString(2, type)
      bindString(3, event)
    }
    notifyQueries(155622331, {database.roomAccountDataQueries.getRoomAccountData})
  }

  public override fun deleteRoomAccountData(room_id: String, type: String): Unit {
    driver.execute(-1896296755, """
    |DELETE FROM sql_room_account_data
    |WHERE room_id = ? AND type = ?
    """.trimMargin(), 2) {
      bindString(1, room_id)
      bindString(2, type)
    }
    notifyQueries(-1896296755, {database.roomAccountDataQueries.getRoomAccountData})
  }

  private inner class GetRoomAccountDataQuery<out T : Any>(
    public val room_id: String,
    public val type: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getRoomAccountData, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1962973558, """
    |SELECT * FROM sql_room_account_data
    |WHERE room_id = ? AND type = ?
    """.trimMargin(), 2) {
      bindString(1, room_id)
      bindString(2, type)
    }

    public override fun toString(): String = "roomAccountData.sq:getRoomAccountData"
  }
}

private class RoomUserQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), RoomUserQueries {
  internal val getRoomUser: MutableList<Query<*>> = copyOnWriteList()

  internal val getRoomUsers: MutableList<Query<*>> = copyOnWriteList()

  public override fun getRoomUser(user_id: String, room_id: String): Query<String> =
      GetRoomUserQuery(user_id, room_id) { cursor ->
    cursor.getString(0)!!
  }

  public override fun <T : Any> getRoomUsers(room_id: String, mapper: (
    user_id: String,
    room_id: String,
    room_user: String
  ) -> T): Query<T> = GetRoomUsersQuery(room_id) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!
    )
  }

  public override fun getRoomUsers(room_id: String): Query<Sql_room_user> = getRoomUsers(room_id) {
      user_id, room_id_, room_user ->
    Sql_room_user(
      user_id,
      room_id_,
      room_user
    )
  }

  public override fun saveRoomUser(
    user_id: String,
    room_id: String,
    room_user: String
  ): Unit {
    driver.execute(1680092989, """
    |INSERT OR REPLACE INTO sql_room_user
    |VALUES (?, ?, ?)
    """.trimMargin(), 3) {
      bindString(1, user_id)
      bindString(2, room_id)
      bindString(3, room_user)
    }
    notifyQueries(1680092989, {database.roomUserQueries.getRoomUser +
        database.roomUserQueries.getRoomUsers})
  }

  public override fun deleteRoomUser(user_id: String, room_id: String): Unit {
    driver.execute(-1789692181, """
    |DELETE FROM sql_room_user
    |WHERE user_id = ? AND room_id = ?
    """.trimMargin(), 2) {
      bindString(1, user_id)
      bindString(2, room_id)
    }
    notifyQueries(-1789692181, {database.roomUserQueries.getRoomUser +
        database.roomUserQueries.getRoomUsers})
  }

  public override fun deleteRoomUsers(room_id: String): Unit {
    driver.execute(354117352, """
    |DELETE FROM sql_room_user
    |WHERE room_id = ?
    """.trimMargin(), 1) {
      bindString(1, room_id)
    }
    notifyQueries(354117352, {database.roomUserQueries.getRoomUser +
        database.roomUserQueries.getRoomUsers})
  }

  private inner class GetRoomUserQuery<out T : Any>(
    public val user_id: String,
    public val room_id: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getRoomUser, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(581012002, """
    |SELECT room_user FROM sql_room_user
    |WHERE user_id = ? AND room_id = ?
    """.trimMargin(), 2) {
      bindString(1, user_id)
      bindString(2, room_id)
    }

    public override fun toString(): String = "roomUser.sq:getRoomUser"
  }

  private inner class GetRoomUsersQuery<out T : Any>(
    public val room_id: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getRoomUsers, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(831502993, """
    |SELECT * FROM sql_room_user
    |WHERE room_id = ?
    """.trimMargin(), 1) {
      bindString(1, room_id)
    }

    public override fun toString(): String = "roomUser.sq:getRoomUsers"
  }
}

private class OlmQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), OlmQueries {
  internal val getOlmAccount: MutableList<Query<*>> = copyOnWriteList()

  internal val getOlmSessions: MutableList<Query<*>> = copyOnWriteList()

  internal val getInboundMegolmSession: MutableList<Query<*>> = copyOnWriteList()

  internal val getInboundMegolmSessionIndex: MutableList<Query<*>> = copyOnWriteList()

  internal val getOutboundMegolmSession: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> getOlmAccount(id: Long, mapper: (pickled_account: String?) -> T):
      Query<T> = GetOlmAccountQuery(id) { cursor ->
    mapper(
      cursor.getString(0)
    )
  }

  public override fun getOlmAccount(id: Long): Query<GetOlmAccount> = getOlmAccount(id) {
      pickled_account ->
    GetOlmAccount(
      pickled_account
    )
  }

  public override fun getOlmSessions(sender_key: String): Query<String> =
      GetOlmSessionsQuery(sender_key) { cursor ->
    cursor.getString(0)!!
  }

  public override fun getInboundMegolmSession(
    sender_key: String,
    session_id: String,
    room_id: String
  ): Query<String> = GetInboundMegolmSessionQuery(sender_key, session_id, room_id) { cursor ->
    cursor.getString(0)!!
  }

  public override fun <T : Any> getInboundMegolmSessionIndex(
    sender_key: String,
    session_id: String,
    room_id: String,
    message_index: Long,
    mapper: (
      sender_key: String,
      session_id: String,
      room_id: String,
      message_index: Long,
      event_id: String,
      origin_timestamp: Long
    ) -> T
  ): Query<T> = GetInboundMegolmSessionIndexQuery(sender_key, session_id, room_id, message_index) {
      cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getLong(3)!!,
      cursor.getString(4)!!,
      cursor.getLong(5)!!
    )
  }

  public override fun getInboundMegolmSessionIndex(
    sender_key: String,
    session_id: String,
    room_id: String,
    message_index: Long
  ): Query<Sql_inbound_megolm_session_index> = getInboundMegolmSessionIndex(sender_key, session_id,
      room_id, message_index) { sender_key_, session_id_, room_id_, message_index_, event_id,
      origin_timestamp ->
    Sql_inbound_megolm_session_index(
      sender_key_,
      session_id_,
      room_id_,
      message_index_,
      event_id,
      origin_timestamp
    )
  }

  public override fun getOutboundMegolmSession(room_id: String): Query<String> =
      GetOutboundMegolmSessionQuery(room_id) { cursor ->
    cursor.getString(0)!!
  }

  public override fun saveOlmAccount(id: Long?, pickled_account: String?): Unit {
    driver.execute(-862973198, """
    |INSERT OR REPLACE INTO sql_olm_account
    |VALUES (?, ?)
    """.trimMargin(), 2) {
      bindLong(1, id)
      bindString(2, pickled_account)
    }
    notifyQueries(-862973198, {database.olmQueries.getOlmAccount})
  }

  public override fun deleteOlmAccount(id: Long): Unit {
    driver.execute(-1977686112, """
    |DELETE FROM sql_olm_account
    |WHERE id = ?
    """.trimMargin(), 1) {
      bindLong(1, id)
    }
    notifyQueries(-1977686112, {database.olmQueries.getOlmAccount})
  }

  public override fun saveOlmSessions(sender_key: String, olm_sessions: String): Unit {
    driver.execute(-1735106440, """
    |INSERT OR REPLACE INTO sql_olm_sessions
    |VALUES (?, ?)
    """.trimMargin(), 2) {
      bindString(1, sender_key)
      bindString(2, olm_sessions)
    }
    notifyQueries(-1735106440, {database.olmQueries.getOlmSessions})
  }

  public override fun deleteOlmSessions(sender_key: String): Unit {
    driver.execute(-1931468406, """
    |DELETE FROM sql_olm_sessions
    |WHERE sender_key = ?
    """.trimMargin(), 1) {
      bindString(1, sender_key)
    }
    notifyQueries(-1931468406, {database.olmQueries.getOlmSessions})
  }

  public override fun saveInboundMegolmSession(
    sender_key: String,
    session_id: String,
    room_id: String,
    pickled_session: String
  ): Unit {
    driver.execute(-552590031, """
    |INSERT OR REPLACE INTO sql_inbound_megolm_session
    |VALUES (?, ?, ?, ?)
    """.trimMargin(), 4) {
      bindString(1, sender_key)
      bindString(2, session_id)
      bindString(3, room_id)
      bindString(4, pickled_session)
    }
    notifyQueries(-552590031, {database.olmQueries.getInboundMegolmSession})
  }

  public override fun deleteInboundMegolmSession(
    sender_key: String,
    session_id: String,
    room_id: String
  ): Unit {
    driver.execute(446134367, """
    |DELETE FROM sql_inbound_megolm_session
    |WHERE sender_key = ? AND session_id = ? AND room_id = ?
    """.trimMargin(), 3) {
      bindString(1, sender_key)
      bindString(2, session_id)
      bindString(3, room_id)
    }
    notifyQueries(446134367, {database.olmQueries.getInboundMegolmSession})
  }

  public override fun saveInboundMegolmSessionIndex(
    sender_key: String,
    session_id: String,
    room_id: String,
    message_index: Long,
    event_id: String,
    origin_timestamp: Long
  ): Unit {
    driver.execute(-2045466079, """
    |INSERT OR REPLACE INTO sql_inbound_megolm_session_index
    |VALUES (?, ?, ?, ?, ?, ?)
    """.trimMargin(), 6) {
      bindString(1, sender_key)
      bindString(2, session_id)
      bindString(3, room_id)
      bindLong(4, message_index)
      bindString(5, event_id)
      bindLong(6, origin_timestamp)
    }
    notifyQueries(-2045466079, {database.olmQueries.getInboundMegolmSessionIndex})
  }

  public override fun deleteInboundMegolmSessionIndex(
    sender_key: String,
    session_id: String,
    room_id: String,
    message_index: Long
  ): Unit {
    driver.execute(1470636979, """
    |DELETE FROM sql_inbound_megolm_session_index
    |WHERE sender_key = ? AND session_id = ? AND room_id = ? AND message_index = ?
    """.trimMargin(), 4) {
      bindString(1, sender_key)
      bindString(2, session_id)
      bindString(3, room_id)
      bindLong(4, message_index)
    }
    notifyQueries(1470636979, {database.olmQueries.getInboundMegolmSessionIndex})
  }

  public override fun saveOutboundMegolmSession(room_id: String, outbound_megolm_session: String):
      Unit {
    driver.execute(631245840, """
    |INSERT OR REPLACE INTO sql_outbound_megolm_session
    |VALUES (?, ?)
    """.trimMargin(), 2) {
      bindString(1, room_id)
      bindString(2, outbound_megolm_session)
    }
    notifyQueries(631245840, {database.olmQueries.getOutboundMegolmSession})
  }

  public override fun deleteOutboundMegolmSession(room_id: String): Unit {
    driver.execute(1526931106, """
    |DELETE FROM sql_outbound_megolm_session
    |WHERE room_id = ?
    """.trimMargin(), 1) {
      bindString(1, room_id)
    }
    notifyQueries(1526931106, {database.olmQueries.getOutboundMegolmSession})
  }

  private inner class GetOlmAccountQuery<out T : Any>(
    public val id: Long,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getOlmAccount, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-760762597, """
    |SELECT pickled_account FROM sql_olm_account
    |WHERE id = ?
    """.trimMargin(), 1) {
      bindLong(1, id)
    }

    public override fun toString(): String = "olm.sq:getOlmAccount"
  }

  private inner class GetOlmSessionsQuery<out T : Any>(
    public val sender_key: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getOlmSessions, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(1433422191, """
    |SELECT olm_sessions FROM sql_olm_sessions
    |WHERE sender_key = ?
    """.trimMargin(), 1) {
      bindString(1, sender_key)
    }

    public override fun toString(): String = "olm.sq:getOlmSessions"
  }

  private inner class GetInboundMegolmSessionQuery<out T : Any>(
    public val sender_key: String,
    public val session_id: String,
    public val room_id: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getInboundMegolmSession, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1443536358, """
    |SELECT pickled_session FROM sql_inbound_megolm_session
    |WHERE sender_key = ? AND session_id = ? AND room_id = ?
    """.trimMargin(), 3) {
      bindString(1, sender_key)
      bindString(2, session_id)
      bindString(3, room_id)
    }

    public override fun toString(): String = "olm.sq:getInboundMegolmSession"
  }

  private inner class GetInboundMegolmSessionIndexQuery<out T : Any>(
    public val sender_key: String,
    public val session_id: String,
    public val room_id: String,
    public val message_index: Long,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getInboundMegolmSessionIndex, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1297213736, """
    |SELECT * FROM sql_inbound_megolm_session_index
    |WHERE sender_key = ? AND session_id = ? AND room_id = ? AND message_index = ?
    """.trimMargin(), 4) {
      bindString(1, sender_key)
      bindString(2, session_id)
      bindString(3, room_id)
      bindLong(4, message_index)
    }

    public override fun toString(): String = "olm.sq:getInboundMegolmSessionIndex"
  }

  private inner class GetOutboundMegolmSessionQuery<out T : Any>(
    public val room_id: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getOutboundMegolmSession, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1218286521, """
    |SELECT outbound_megolm_session FROM sql_outbound_megolm_session
    |WHERE room_id = ?
    """.trimMargin(), 1) {
      bindString(1, room_id)
    }

    public override fun toString(): String = "olm.sq:getOutboundMegolmSession"
  }
}

private class RoomQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), RoomQueries {
  internal val getAllRooms: MutableList<Query<*>> = copyOnWriteList()

  internal val getRoom: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> getAllRooms(mapper: (room_id: String, room: String) -> T): Query<T>
      = Query(-1670113410, getAllRooms, driver, "room.sq", "getAllRooms",
      "SELECT * FROM sql_room") { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!
    )
  }

  public override fun getAllRooms(): Query<Sql_room> = getAllRooms { room_id, room ->
    Sql_room(
      room_id,
      room
    )
  }

  public override fun <T : Any> getRoom(room_id: String, mapper: (room_id: String, room: String) ->
      T): Query<T> = GetRoomQuery(room_id) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!
    )
  }

  public override fun getRoom(room_id: String): Query<Sql_room> = getRoom(room_id) { room_id_,
      room ->
    Sql_room(
      room_id_,
      room
    )
  }

  public override fun saveRoom(room_id: String, room: String): Unit {
    driver.execute(-1327777433, """
    |INSERT OR REPLACE INTO sql_room
    |VALUES (?, ?)
    """.trimMargin(), 2) {
      bindString(1, room_id)
      bindString(2, room)
    }
    notifyQueries(-1327777433, {database.roomQueries.getAllRooms + database.roomQueries.getRoom})
  }

  public override fun deleteRoom(room_id: String): Unit {
    driver.execute(339089109, """
    |DELETE FROM sql_room
    |WHERE room_id = ?
    """.trimMargin(), 1) {
      bindString(1, room_id)
    }
    notifyQueries(339089109, {database.roomQueries.getAllRooms + database.roomQueries.getRoom})
  }

  private inner class GetRoomQuery<out T : Any>(
    public val room_id: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getRoom, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(1888515586, """
    |SELECT * FROM sql_room
    |WHERE room_id = ?
    """.trimMargin(), 1) {
      bindString(1, room_id)
    }

    public override fun toString(): String = "room.sq:getRoom"
  }
}

private class AccountQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), AccountQueries {
  internal val getAccount: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> getAccount(id: Long, mapper: (
    id: Long,
    base_url: String?,
    user_id: String?,
    device_id: String?,
    access_token: String?,
    sync_batch_token: String?,
    filter_id: String?
  ) -> T): Query<T> = GetAccountQuery(id) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1),
      cursor.getString(2),
      cursor.getString(3),
      cursor.getString(4),
      cursor.getString(5),
      cursor.getString(6)
    )
  }

  public override fun getAccount(id: Long): Query<Sql_account> = getAccount(id) { id_, base_url,
      user_id, device_id, access_token, sync_batch_token, filter_id ->
    Sql_account(
      id_,
      base_url,
      user_id,
      device_id,
      access_token,
      sync_batch_token,
      filter_id
    )
  }

  public override fun saveAccount(sql_account: Sql_account): Unit {
    driver.execute(-926491493, """
    |INSERT OR REPLACE INTO sql_account
    |VALUES (?, ?, ?, ?, ?, ?, ?)
    """.trimMargin(), 7) {
      bindLong(1, sql_account.id)
      bindString(2, sql_account.base_url)
      bindString(3, sql_account.user_id)
      bindString(4, sql_account.device_id)
      bindString(5, sql_account.access_token)
      bindString(6, sql_account.sync_batch_token)
      bindString(7, sql_account.filter_id)
    }
    notifyQueries(-926491493, {database.accountQueries.getAccount})
  }

  public override fun deleteAccount(id: Long): Unit {
    driver.execute(1141221869, """
    |DELETE FROM sql_account
    |WHERE id = ?
    """.trimMargin(), 1) {
      bindLong(1, id)
    }
    notifyQueries(1141221869, {database.accountQueries.getAccount})
  }

  private inner class GetAccountQuery<out T : Any>(
    public val id: Long,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getAccount, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1678667284, """
    |SELECT * FROM sql_account
    |WHERE id = ?
    """.trimMargin(), 1) {
      bindLong(1, id)
    }

    public override fun toString(): String = "account.sq:getAccount"
  }
}

private class MediaQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), MediaQueries {
  internal val getMedia: MutableList<Query<*>> = copyOnWriteList()

  internal val getUploadMedia: MutableList<Query<*>> = copyOnWriteList()

  public override fun getMedia(url: String): Query<ByteArray> = GetMediaQuery(url) { cursor ->
    cursor.getBytes(0)!!
  }

  public override fun <T : Any> getUploadMedia(cache_uri: String, mapper: (
    cache_uri: String,
    mxc_uri: String?,
    content_type: String?
  ) -> T): Query<T> = GetUploadMediaQuery(cache_uri) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1),
      cursor.getString(2)
    )
  }

  public override fun getUploadMedia(cache_uri: String): Query<Sql_upload_media> =
      getUploadMedia(cache_uri) { cache_uri_, mxc_uri, content_type ->
    Sql_upload_media(
      cache_uri_,
      mxc_uri,
      content_type
    )
  }

  public override fun saveMedia(url: String, media: ByteArray): Unit {
    driver.execute(-1177025797, """
    |INSERT OR REPLACE INTO sql_media
    |VALUES (?, ?)
    """.trimMargin(), 2) {
      bindString(1, url)
      bindBytes(2, media)
    }
    notifyQueries(-1177025797, {database.mediaQueries.getMedia})
  }

  public override fun deleteMedia(url: String): Unit {
    driver.execute(-20752755, """
    |DELETE FROM sql_media
    |WHERE url = ?
    """.trimMargin(), 1) {
      bindString(1, url)
    }
    notifyQueries(-20752755, {database.mediaQueries.getMedia})
  }

  public override fun saveUploadMedia(
    cache_uri: String,
    mxc_uri: String?,
    content_type: String?
  ): Unit {
    driver.execute(-1999392710, """
    |INSERT OR REPLACE INTO sql_upload_media
    |VALUES (?, ?, ?)
    """.trimMargin(), 3) {
      bindString(1, cache_uri)
      bindString(2, mxc_uri)
      bindString(3, content_type)
    }
    notifyQueries(-1999392710, {database.mediaQueries.getUploadMedia})
  }

  public override fun deleteUploadMedia(cache_uri: String): Unit {
    driver.execute(33721932, """
    |DELETE FROM sql_upload_media
    |WHERE cache_uri = ?
    """.trimMargin(), 1) {
      bindString(1, cache_uri)
    }
    notifyQueries(33721932, {database.mediaQueries.getUploadMedia})
  }

  public override fun changeUri(
    url: String,
    url_: String,
    url__: String
  ): Unit {
    driver.execute(-545621535, """
    |INSERT OR REPLACE INTO sql_media (url,media)
    |SELECT ?, media
    |FROM sql_media
    |WHERE url = ?
    """.trimMargin(), 2) {
      bindString(1, url)
      bindString(2, url_)
    }
    driver.execute(-545621534, """
    |DELETE FROM sql_media
    |WHERE url = ?
    """.trimMargin(), 1) {
      bindString(1, url__)
    }
    notifyQueries(111163952, {database.mediaQueries.getMedia})
  }

  private inner class GetMediaQuery<out T : Any>(
    public val url: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getMedia, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1131801318, """
    |SELECT media FROM sql_media
    |WHERE url = ?
    """.trimMargin(), 1) {
      bindString(1, url)
    }

    public override fun toString(): String = "media.sq:getMedia"
  }

  private inner class GetUploadMediaQuery<out T : Any>(
    public val cache_uri: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getUploadMedia, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-703500519, """
    |SELECT * FROM sql_upload_media
    |WHERE cache_uri = ?
    """.trimMargin(), 1) {
      bindString(1, cache_uri)
    }

    public override fun toString(): String = "media.sq:getUploadMedia"
  }
}

private class RoomStateQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), RoomStateQueries {
  internal val getRoomState: MutableList<Query<*>> = copyOnWriteList()

  internal val getRoomStateByStateKey: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> getRoomState(
    room_id: String,
    type: String,
    mapper: (
      room_id: String,
      type: String,
      state_key: String,
      event: String
    ) -> T
  ): Query<T> = GetRoomStateQuery(room_id, type) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3)!!
    )
  }

  public override fun getRoomState(room_id: String, type: String): Query<Sql_room_state> =
      getRoomState(room_id, type) { room_id_, type_, state_key, event ->
    Sql_room_state(
      room_id_,
      type_,
      state_key,
      event
    )
  }

  public override fun getRoomStateByStateKey(
    room_id: String,
    type: String,
    state_key: String
  ): Query<String> = GetRoomStateByStateKeyQuery(room_id, type, state_key) { cursor ->
    cursor.getString(0)!!
  }

  public override fun saveRoomState(
    room_id: String,
    type: String,
    state_key: String,
    event: String
  ): Unit {
    driver.execute(439333563, """
    |INSERT OR REPLACE INTO sql_room_state
    |VALUES (?, ?, ?, ?)
    """.trimMargin(), 4) {
      bindString(1, room_id)
      bindString(2, type)
      bindString(3, state_key)
      bindString(4, event)
    }
    notifyQueries(439333563, {database.roomStateQueries.getRoomState +
        database.roomStateQueries.getRoomStateByStateKey})
  }

  public override fun deleteRoomState(room_id: String, type: String): Unit {
    driver.execute(998635981, """
    |DELETE FROM sql_room_state
    |WHERE room_id = ? AND type = ?
    """.trimMargin(), 2) {
      bindString(1, room_id)
      bindString(2, type)
    }
    notifyQueries(998635981, {database.roomStateQueries.getRoomState +
        database.roomStateQueries.getRoomStateByStateKey})
  }

  private inner class GetRoomStateQuery<out T : Any>(
    public val room_id: String,
    public val type: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getRoomState, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-2083106242, """
    |SELECT * FROM sql_room_state
    |WHERE room_id = ? AND type = ?
    """.trimMargin(), 2) {
      bindString(1, room_id)
      bindString(2, type)
    }

    public override fun toString(): String = "roomState.sq:getRoomState"
  }

  private inner class GetRoomStateByStateKeyQuery<out T : Any>(
    public val room_id: String,
    public val type: String,
    public val state_key: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getRoomStateByStateKey, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-491852189, """
    |SELECT event FROM sql_room_state
    |WHERE room_id = ? AND type = ? AND state_key = ?
    """.trimMargin(), 3) {
      bindString(1, room_id)
      bindString(2, type)
      bindString(3, state_key)
    }

    public override fun toString(): String = "roomState.sq:getRoomStateByStateKey"
  }
}

private class RoomOutboxMessageQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), RoomOutboxMessageQueries {
  internal val getRoomOutboxMessage: MutableList<Query<*>> = copyOnWriteList()

  internal val getAllRoomOutboxMessages: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> getRoomOutboxMessage(transaction_id: String, mapper: (
    transaction_id: String,
    room_id: String,
    type: String,
    content: String,
    sent_at: Long?
  ) -> T): Query<T> = GetRoomOutboxMessageQuery(transaction_id) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3)!!,
      cursor.getLong(4)
    )
  }

  public override fun getRoomOutboxMessage(transaction_id: String): Query<Sql_room_outbox_message> =
      getRoomOutboxMessage(transaction_id) { transaction_id_, room_id, type, content, sent_at ->
    Sql_room_outbox_message(
      transaction_id_,
      room_id,
      type,
      content,
      sent_at
    )
  }

  public override fun <T : Any> getAllRoomOutboxMessages(mapper: (
    transaction_id: String,
    room_id: String,
    type: String,
    content: String,
    sent_at: Long?
  ) -> T): Query<T> = Query(1379918246, getAllRoomOutboxMessages, driver, "roomOutboxMessage.sq",
      "getAllRoomOutboxMessages", "SELECT * FROM sql_room_outbox_message") { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3)!!,
      cursor.getLong(4)
    )
  }

  public override fun getAllRoomOutboxMessages(): Query<Sql_room_outbox_message> =
      getAllRoomOutboxMessages { transaction_id, room_id, type, content, sent_at ->
    Sql_room_outbox_message(
      transaction_id,
      room_id,
      type,
      content,
      sent_at
    )
  }

  public override fun saveRoomOutboxMessage(sql_room_outbox_message: Sql_room_outbox_message):
      Unit {
    driver.execute(-1222667813, """
    |INSERT OR REPLACE INTO sql_room_outbox_message
    |VALUES (?, ?, ?, ?, ?)
    """.trimMargin(), 5) {
      bindString(1, sql_room_outbox_message.transaction_id)
      bindString(2, sql_room_outbox_message.room_id)
      bindString(3, sql_room_outbox_message.type)
      bindString(4, sql_room_outbox_message.content)
      bindLong(5, sql_room_outbox_message.sent_at)
    }
    notifyQueries(-1222667813, {database.roomOutboxMessageQueries.getRoomOutboxMessage +
        database.roomOutboxMessageQueries.getAllRoomOutboxMessages})
  }

  public override fun deleteRoomOutboxMessage(transaction_id: String): Unit {
    driver.execute(-1724827347, """
    |DELETE FROM sql_room_outbox_message
    |WHERE transaction_id = ?
    """.trimMargin(), 1) {
      bindString(1, transaction_id)
    }
    notifyQueries(-1724827347, {database.roomOutboxMessageQueries.getRoomOutboxMessage +
        database.roomOutboxMessageQueries.getAllRoomOutboxMessages})
  }

  private inner class GetRoomOutboxMessageQuery<out T : Any>(
    public val transaction_id: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getRoomOutboxMessage, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(504556848, """
    |SELECT * FROM sql_room_outbox_message
    |WHERE transaction_id = ?
    """.trimMargin(), 1) {
      bindString(1, transaction_id)
    }

    public override fun toString(): String = "roomOutboxMessage.sq:getRoomOutboxMessage"
  }
}

private class DeviceKeysQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), DeviceKeysQueries {
  internal val getDeviceKeys: MutableList<Query<*>> = copyOnWriteList()

  internal val getOutdatedDeviceKeys: MutableList<Query<*>> = copyOnWriteList()

  internal val getVerifiedKey: MutableList<Query<*>> = copyOnWriteList()

  public override fun getDeviceKeys(user_id: String): Query<String> = GetDeviceKeysQuery(user_id) {
      cursor ->
    cursor.getString(0)!!
  }

  public override fun <T : Any> getOutdatedDeviceKeys(id: Long,
      mapper: (outdated_device_keys: String?) -> T): Query<T> = GetOutdatedDeviceKeysQuery(id) {
      cursor ->
    mapper(
      cursor.getString(0)
    )
  }

  public override fun getOutdatedDeviceKeys(id: Long): Query<GetOutdatedDeviceKeys> =
      getOutdatedDeviceKeys(id) { outdated_device_keys ->
    GetOutdatedDeviceKeys(
      outdated_device_keys
    )
  }

  public override fun getVerifiedKey(
    user_id: String,
    device_id: String?,
    key_id: String,
    key_algorithm: String
  ): Query<String> = GetVerifiedKeyQuery(user_id, device_id, key_id, key_algorithm) { cursor ->
    cursor.getString(0)!!
  }

  public override fun saveDeviceKeys(user_id: String, device_keys: String): Unit {
    driver.execute(-1058865339, """
    |INSERT OR REPLACE INTO sql_device_keys
    |VALUES (?, ?)
    """.trimMargin(), 2) {
      bindString(1, user_id)
      bindString(2, device_keys)
    }
    notifyQueries(-1058865339, {database.deviceKeysQueries.getDeviceKeys})
  }

  public override fun deleteDeviceKeys(user_id: String): Unit {
    driver.execute(-1922319757, """
    |DELETE FROM sql_device_keys
    |WHERE user_id = ?
    """.trimMargin(), 1) {
      bindString(1, user_id)
    }
    notifyQueries(-1922319757, {database.deviceKeysQueries.getDeviceKeys})
  }

  public override fun saveOutdatedDeviceKeys(sql_outdated_device_keys: Sql_outdated_device_keys):
      Unit {
    driver.execute(-715340211, """
    |INSERT OR REPLACE INTO sql_outdated_device_keys
    |VALUES  (?, ?)
    """.trimMargin(), 2) {
      bindLong(1, sql_outdated_device_keys.id)
      bindString(2, sql_outdated_device_keys.outdated_device_keys)
    }
    notifyQueries(-715340211, {database.deviceKeysQueries.getOutdatedDeviceKeys})
  }

  public override fun deleteOutdatedDeviceKeys(id: Long): Unit {
    driver.execute(994472827, """
    |DELETE FROM sql_outdated_device_keys
    |WHERE id = ?
    """.trimMargin(), 1) {
      bindLong(1, id)
    }
    notifyQueries(994472827, {database.deviceKeysQueries.getOutdatedDeviceKeys})
  }

  public override fun saveVerifiedKey(sql_verified_keys: Sql_verified_keys): Unit {
    driver.execute(695407612, """
    |INSERT OR REPLACE INTO sql_verified_keys
    |VALUES  (?, ?, ?, ?, ?)
    """.trimMargin(), 5) {
      bindString(1, sql_verified_keys.user_id)
      bindString(2, sql_verified_keys.device_id)
      bindString(3, sql_verified_keys.key_id)
      bindString(4, sql_verified_keys.key_algorithm)
      bindString(5, sql_verified_keys.key_value)
    }
    notifyQueries(695407612, {database.deviceKeysQueries.getVerifiedKey})
  }

  public override fun deleteVerifiedKey(
    user_id: String,
    device_id: String?,
    key_id: String,
    key_algorithm: String
  ): Unit {
    driver.execute(null, """
    |DELETE FROM sql_verified_keys
    |WHERE user_id = ? AND device_id ${ if (device_id == null) "IS" else "=" } ? AND key_id = ? AND key_algorithm = ?
    """.trimMargin(), 4) {
      bindString(1, user_id)
      bindString(2, device_id)
      bindString(3, key_id)
      bindString(4, key_algorithm)
    }
    notifyQueries(-301875570, {database.deviceKeysQueries.getVerifiedKey})
  }

  private inner class GetDeviceKeysQuery<out T : Any>(
    public val user_id: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getDeviceKeys, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1736236766, """
    |SELECT device_keys FROM sql_device_keys
    |WHERE user_id = ?
    """.trimMargin(), 1) {
      bindString(1, user_id)
    }

    public override fun toString(): String = "deviceKeys.sq:getDeviceKeys"
  }

  private inner class GetOutdatedDeviceKeysQuery<out T : Any>(
    public val id: Long,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getOutdatedDeviceKeys, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-564151510, """
    |SELECT outdated_device_keys FROM sql_outdated_device_keys
    |WHERE id = ?
    """.trimMargin(), 1) {
      bindLong(1, id)
    }

    public override fun toString(): String = "deviceKeys.sq:getOutdatedDeviceKeys"
  }

  private inner class GetVerifiedKeyQuery<out T : Any>(
    public val user_id: String,
    public val device_id: String?,
    public val key_id: String,
    public val key_algorithm: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getVerifiedKey, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(null, """
    |SELECT key_value FROM sql_verified_keys
    |WHERE user_id = ? AND device_id ${ if (device_id == null) "IS" else "=" } ? AND key_id = ? AND key_algorithm = ?
    """.trimMargin(), 4) {
      bindString(1, user_id)
      bindString(2, device_id)
      bindString(3, key_id)
      bindString(4, key_algorithm)
    }

    public override fun toString(): String = "deviceKeys.sq:getVerifiedKey"
  }
}

private class GlobalAccountDataQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), GlobalAccountDataQueries {
  internal val getGlobalAccountData: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> getGlobalAccountData(type: String, mapper: (type: String,
      event: String) -> T): Query<T> = GetGlobalAccountDataQuery(type) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getString(1)!!
    )
  }

  public override fun getGlobalAccountData(type: String): Query<Sql_global_account_data> =
      getGlobalAccountData(type) { type_, event ->
    Sql_global_account_data(
      type_,
      event
    )
  }

  public override fun saveGlobalAccountData(type: String, event: String): Unit {
    driver.execute(1002061179, """
    |INSERT OR REPLACE INTO sql_global_account_data
    |VALUES (?, ?)
    """.trimMargin(), 2) {
      bindString(1, type)
      bindString(2, event)
    }
    notifyQueries(1002061179, {database.globalAccountDataQueries.getGlobalAccountData})
  }

  public override fun deleteGlobalAccountData(type: String): Unit {
    driver.execute(-516832755, """
    |DELETE FROM sql_global_account_data
    |WHERE  type = ?
    """.trimMargin(), 1) {
      bindString(1, type)
    }
    notifyQueries(-516832755, {database.globalAccountDataQueries.getGlobalAccountData})
  }

  private inner class GetGlobalAccountDataQuery<out T : Any>(
    public val type: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getGlobalAccountData, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(855592186, """
    |SELECT * FROM sql_global_account_data
    |WHERE type = ?
    """.trimMargin(), 1) {
      bindString(1, type)
    }

    public override fun toString(): String = "globalAccountData.sq:getGlobalAccountData"
  }
}

private class RoomTimelineQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), RoomTimelineQueries {
  internal val getTimelineEvent: MutableList<Query<*>> = copyOnWriteList()

  public override fun getTimelineEvent(event_id: String, room_id: String): Query<String> =
      GetTimelineEventQuery(event_id, room_id) { cursor ->
    cursor.getString(0)!!
  }

  public override fun saveTimelineEvent(
    event_id: String,
    room_id: String,
    timeline_event: String
  ): Unit {
    driver.execute(-1527414004, """
    |INSERT OR REPLACE INTO sql_room_timeline_event
    |VALUES (?, ?, ?)
    """.trimMargin(), 3) {
      bindString(1, event_id)
      bindString(2, room_id)
      bindString(3, timeline_event)
    }
    notifyQueries(-1527414004, {database.roomTimelineQueries.getTimelineEvent})
  }

  public override fun deleteTimelineEvent(event_id: String, room_id: String): Unit {
    driver.execute(957582750, """
    |DELETE FROM sql_room_timeline_event
    |WHERE event_id = ? AND room_id = ?
    """.trimMargin(), 2) {
      bindString(1, event_id)
      bindString(2, room_id)
    }
    notifyQueries(957582750, {database.roomTimelineQueries.getTimelineEvent})
  }

  private inner class GetTimelineEventQuery<out T : Any>(
    public val event_id: String,
    public val room_id: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getTimelineEvent, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(641204851, """
    |SELECT timeline_event FROM sql_room_timeline_event
    |WHERE event_id = ? AND room_id = ?
    """.trimMargin(), 2) {
      bindString(1, event_id)
      bindString(2, room_id)
    }

    public override fun toString(): String = "roomTimeline.sq:getTimelineEvent"
  }
}
