package net.folivo.trixnity.client.store.sqldelight.db

import com.squareup.sqldelight.Transacter
import com.squareup.sqldelight.db.SqlDriver
import net.folivo.trixnity.client.store.sqldelight.AccountQueries
import net.folivo.trixnity.client.store.sqldelight.DeviceKeysQueries
import net.folivo.trixnity.client.store.sqldelight.GlobalAccountDataQueries
import net.folivo.trixnity.client.store.sqldelight.MediaQueries
import net.folivo.trixnity.client.store.sqldelight.OlmQueries
import net.folivo.trixnity.client.store.sqldelight.RoomAccountDataQueries
import net.folivo.trixnity.client.store.sqldelight.RoomOutboxMessageQueries
import net.folivo.trixnity.client.store.sqldelight.RoomQueries
import net.folivo.trixnity.client.store.sqldelight.RoomStateQueries
import net.folivo.trixnity.client.store.sqldelight.RoomTimelineQueries
import net.folivo.trixnity.client.store.sqldelight.RoomUserQueries
import net.folivo.trixnity.client.store.sqldelight.db.trixnityclientsqldelight.newInstance
import net.folivo.trixnity.client.store.sqldelight.db.trixnityclientsqldelight.schema

public interface Database : Transacter {
  public val accountQueries: AccountQueries

  public val deviceKeysQueries: DeviceKeysQueries

  public val globalAccountDataQueries: GlobalAccountDataQueries

  public val mediaQueries: MediaQueries

  public val olmQueries: OlmQueries

  public val roomQueries: RoomQueries

  public val roomAccountDataQueries: RoomAccountDataQueries

  public val roomOutboxMessageQueries: RoomOutboxMessageQueries

  public val roomStateQueries: RoomStateQueries

  public val roomTimelineQueries: RoomTimelineQueries

  public val roomUserQueries: RoomUserQueries

  public companion object {
    public val Schema: SqlDriver.Schema
      get() = Database::class.schema

    public operator fun invoke(driver: SqlDriver): Database = Database::class.newInstance(driver)
  }
}
