package net.folivo.trixnity.client.store.sqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.String
import kotlin.Unit

public interface RoomStateQueries : Transacter {
  public fun <T : Any> getRoomState(
    room_id: String,
    type: String,
    mapper: (
      room_id: String,
      type: String,
      state_key: String,
      event: String
    ) -> T
  ): Query<T>

  public fun getRoomState(room_id: String, type: String): Query<Sql_room_state>

  public fun getRoomStateByStateKey(
    room_id: String,
    type: String,
    state_key: String
  ): Query<String>

  public fun saveRoomState(
    room_id: String,
    type: String,
    state_key: String,
    event: String
  ): Unit

  public fun deleteRoomState(room_id: String, type: String): Unit
}
