package net.folivo.trixnity.client.store.sqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface DeviceKeysQueries : Transacter {
  public fun getDeviceKeys(user_id: String): Query<String>

  public fun <T : Any> getOutdatedDeviceKeys(id: Long, mapper: (outdated_device_keys: String?) ->
      T): Query<T>

  public fun getOutdatedDeviceKeys(id: Long): Query<GetOutdatedDeviceKeys>

  public fun getVerifiedKey(
    user_id: String,
    device_id: String?,
    key_id: String,
    key_algorithm: String
  ): Query<String>

  public fun saveDeviceKeys(user_id: String, device_keys: String): Unit

  public fun deleteDeviceKeys(user_id: String): Unit

  public fun saveOutdatedDeviceKeys(sql_outdated_device_keys: Sql_outdated_device_keys): Unit

  public fun deleteOutdatedDeviceKeys(id: Long): Unit

  public fun saveVerifiedKey(sql_verified_keys: Sql_verified_keys): Unit

  public fun deleteVerifiedKey(
    user_id: String,
    device_id: String?,
    key_id: String,
    key_algorithm: String
  ): Unit
}
