package net.folivo.trixnity.client.store.sqldelight

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface MediaQueries : Transacter {
  public fun <T : Any> getUploadMedia(cache_uri: String, mapper: (
    cache_uri: String,
    mxc_uri: String?,
    size: Long?,
    content_type: String?
  ) -> T): Query<T>

  public fun getUploadMedia(cache_uri: String): Query<Sql_media_cache_mapping>

  public fun saveUploadMedia(
    cache_uri: String,
    mxc_uri: String?,
    size: Long?,
    content_type: String?
  ): Unit

  public fun deleteUploadMedia(cache_uri: String): Unit

  public fun deleteAllUploadMedia(): Unit
}
