package net.folivo.trixnity.client.store.repository.room

import androidx.room.InvalidationTracker
import androidx.room.RoomOpenDelegate
import androidx.room.migration.AutoMigrationSpec
import androidx.room.migration.Migration
import androidx.room.util.TableInfo
import androidx.room.util.TableInfo.Companion.read
import androidx.room.util.dropFtsSyncTriggers
import androidx.sqlite.SQLiteConnection
import androidx.sqlite.execSQL
import javax.`annotation`.processing.Generated
import kotlin.Lazy
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.collections.MutableList
import kotlin.collections.MutableMap
import kotlin.collections.MutableSet
import kotlin.collections.Set
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf
import kotlin.collections.mutableSetOf
import kotlin.reflect.KClass

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class TrixnityRoomDatabase_Impl : TrixnityRoomDatabase() {
  private val _accountDao: Lazy<AccountDao> = lazy {
    AccountDao_Impl(this)
  }

  private val _serverDataDao: Lazy<ServerDataDao> = lazy {
    ServerDataDao_Impl(this)
  }

  private val _crossSigningKeysDao: Lazy<CrossSigningKeysDao> = lazy {
    CrossSigningKeysDao_Impl(this)
  }

  private val _deviceKeysDao: Lazy<DeviceKeysDao> = lazy {
    DeviceKeysDao_Impl(this)
  }

  private val _globalAccountDataDao: Lazy<GlobalAccountDataDao> = lazy {
    GlobalAccountDataDao_Impl(this)
  }

  private val _inboundMegolmMessageIndexDao: Lazy<InboundMegolmMessageIndexDao> = lazy {
    InboundMegolmMessageIndexDao_Impl(this)
  }

  private val _inboundMegolmSessionDao: Lazy<InboundMegolmSessionDao> = lazy {
    InboundMegolmSessionDao_Impl(this)
  }

  private val _keyChainLinkDao: Lazy<KeyChainLinkDao> = lazy {
    KeyChainLinkDao_Impl(this)
  }

  private val _keyVerificationStateDao: Lazy<KeyVerificationStateDao> = lazy {
    KeyVerificationStateDao_Impl(this)
  }

  private val _mediaCacheMappingDao: Lazy<MediaCacheMappingDao> = lazy {
    MediaCacheMappingDao_Impl(this)
  }

  private val _olmAccountDao: Lazy<OlmAccountDao> = lazy {
    OlmAccountDao_Impl(this)
  }

  private val _olmForgetFallbackKeyAfterDao: Lazy<OlmForgetFallbackKeyAfterDao> = lazy {
    OlmForgetFallbackKeyAfterDao_Impl(this)
  }

  private val _olmSessionDao: Lazy<OlmSessionDao> = lazy {
    OlmSessionDao_Impl(this)
  }

  private val _outboundMegolmSessionDao: Lazy<OutboundMegolmSessionDao> = lazy {
    OutboundMegolmSessionDao_Impl(this)
  }

  private val _outdatedKeysDao: Lazy<OutdatedKeysDao> = lazy {
    OutdatedKeysDao_Impl(this)
  }

  private val _roomAccountDataDao: Lazy<RoomAccountDataDao> = lazy {
    RoomAccountDataDao_Impl(this)
  }

  private val _roomKeyRequestDao: Lazy<RoomKeyRequestDao> = lazy {
    RoomKeyRequestDao_Impl(this)
  }

  private val _roomOutboxMessageDao: Lazy<RoomOutboxMessageDao> = lazy {
    RoomOutboxMessageDao_Impl(this)
  }

  private val _roomRoomDao: Lazy<RoomRoomDao> = lazy {
    RoomRoomDao_Impl(this)
  }

  private val _roomStateDao: Lazy<RoomStateDao> = lazy {
    RoomStateDao_Impl(this)
  }

  private val _roomUserDao: Lazy<RoomUserDao> = lazy {
    RoomUserDao_Impl(this)
  }

  private val _roomUserReceiptsDao: Lazy<RoomUserReceiptsDao> = lazy {
    RoomUserReceiptsDao_Impl(this)
  }

  private val _secretKeyRequestDao: Lazy<SecretKeyRequestDao> = lazy {
    SecretKeyRequestDao_Impl(this)
  }

  private val _secretsDao: Lazy<SecretsDao> = lazy {
    SecretsDao_Impl(this)
  }

  private val _timelineEventRelationDao: Lazy<TimelineEventRelationDao> = lazy {
    TimelineEventRelationDao_Impl(this)
  }

  private val _timelineEventDao: Lazy<TimelineEventDao> = lazy {
    TimelineEventDao_Impl(this)
  }

  protected override fun createOpenDelegate(): RoomOpenDelegate {
    val _openDelegate: RoomOpenDelegate = object : RoomOpenDelegate(3,
        "f2032cb00195f1ddcea7eef0a99b66c9", "08ef0a4953dba7878c254589805f0694") {
      public override fun createAllTables(connection: SQLiteConnection) {
        connection.execSQL("CREATE TABLE IF NOT EXISTS `Account` (`id` INTEGER NOT NULL, `olmPickleKey` TEXT, `baseUrl` TEXT, `userId` TEXT, `deviceId` TEXT, `accessToken` TEXT, `refreshToken` TEXT, `syncBatchToken` TEXT, `filterId` TEXT, `backgroundFilterId` TEXT, `displayName` TEXT, `avatarUrl` TEXT, `isLocked` INTEGER NOT NULL, PRIMARY KEY(`id`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `ServerData` (`id` INTEGER NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`id`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `CrossSigningKeys` (`userId` TEXT NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`userId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `DeviceKeys` (`userId` TEXT NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`userId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `GlobalAccountData` (`type` TEXT NOT NULL, `key` TEXT NOT NULL, `event` TEXT NOT NULL, PRIMARY KEY(`type`, `key`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `InboundMegolmMessageIndex` (`sessionId` TEXT NOT NULL, `roomId` TEXT NOT NULL, `messageIndex` INTEGER NOT NULL, `eventId` TEXT NOT NULL, `originTimestamp` INTEGER NOT NULL, PRIMARY KEY(`sessionId`, `roomId`, `messageIndex`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `InboundMegolmSession` (`senderKey` TEXT NOT NULL, `sessionId` TEXT NOT NULL, `roomId` TEXT NOT NULL, `firstKnownIndex` INTEGER NOT NULL, `hasBeenBackedUp` INTEGER NOT NULL, `isTrusted` INTEGER NOT NULL, `senderSigningKey` TEXT NOT NULL, `forwardingCurve25519KeyChain` TEXT NOT NULL, `pickled` TEXT NOT NULL, PRIMARY KEY(`senderKey`, `sessionId`, `roomId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `KeyChainLink` (`signingUserId` TEXT NOT NULL, `signingKeyId` TEXT NOT NULL, `signingKeyValue` TEXT NOT NULL, `signedUserId` TEXT NOT NULL, `signedKeyId` TEXT NOT NULL, `signedKeyValue` TEXT NOT NULL, PRIMARY KEY(`signingUserId`, `signingKeyId`, `signingKeyValue`, `signedUserId`, `signedKeyId`, `signedKeyValue`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `KeyVerificationState` (`keyId` TEXT NOT NULL, `keyAlgorithm` TEXT NOT NULL, `verificationState` TEXT NOT NULL, PRIMARY KEY(`keyId`, `keyAlgorithm`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `MediaCacheMapping` (`cacheUri` TEXT NOT NULL, `mxcUri` TEXT, `size` INTEGER NOT NULL, `contentType` TEXT, PRIMARY KEY(`cacheUri`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `OlmAccount` (`id` INTEGER NOT NULL, `pickled` TEXT NOT NULL, PRIMARY KEY(`id`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `OlmForgetFallbackKeyAfter` (`id` INTEGER NOT NULL, `instant` INTEGER NOT NULL, PRIMARY KEY(`id`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `OlmSession` (`senderKey` TEXT NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`senderKey`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `OutboundMegolmSession` (`roomId` TEXT NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`roomId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `OutdatedKeys` (`id` INTEGER NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`id`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `RoomAccountData` (`roomId` TEXT NOT NULL, `type` TEXT NOT NULL, `key` TEXT NOT NULL, `event` TEXT NOT NULL, PRIMARY KEY(`roomId`, `type`, `key`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `RoomKeyRequest` (`id` TEXT NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`id`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `RoomOutboxMessage2` (`roomId` TEXT NOT NULL, `transactionId` TEXT NOT NULL, `value` TEXT NOT NULL, `contentType` TEXT NOT NULL, PRIMARY KEY(`roomId`, `transactionId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `Room` (`roomId` TEXT NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`roomId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `RoomState` (`roomId` TEXT NOT NULL, `type` TEXT NOT NULL, `stateKey` TEXT NOT NULL, `event` TEXT NOT NULL, PRIMARY KEY(`roomId`, `type`, `stateKey`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `RoomUser` (`userId` TEXT NOT NULL, `roomId` TEXT NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`userId`, `roomId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `RoomUserReceipts` (`userId` TEXT NOT NULL, `roomId` TEXT NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`userId`, `roomId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `SecretKeyRequest` (`id` TEXT NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`id`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `Secrets` (`id` INTEGER NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`id`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `TimelineEventRelation` (`roomId` TEXT NOT NULL, `eventId` TEXT NOT NULL, `relationType` TEXT NOT NULL, `relatedEventId` TEXT NOT NULL, PRIMARY KEY(`roomId`, `eventId`, `relationType`, `relatedEventId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `TimelineEvent` (`roomId` TEXT NOT NULL, `eventId` TEXT NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`roomId`, `eventId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)")
        connection.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'f2032cb00195f1ddcea7eef0a99b66c9')")
      }

      public override fun dropAllTables(connection: SQLiteConnection) {
        connection.execSQL("DROP TABLE IF EXISTS `Account`")
        connection.execSQL("DROP TABLE IF EXISTS `ServerData`")
        connection.execSQL("DROP TABLE IF EXISTS `CrossSigningKeys`")
        connection.execSQL("DROP TABLE IF EXISTS `DeviceKeys`")
        connection.execSQL("DROP TABLE IF EXISTS `GlobalAccountData`")
        connection.execSQL("DROP TABLE IF EXISTS `InboundMegolmMessageIndex`")
        connection.execSQL("DROP TABLE IF EXISTS `InboundMegolmSession`")
        connection.execSQL("DROP TABLE IF EXISTS `KeyChainLink`")
        connection.execSQL("DROP TABLE IF EXISTS `KeyVerificationState`")
        connection.execSQL("DROP TABLE IF EXISTS `MediaCacheMapping`")
        connection.execSQL("DROP TABLE IF EXISTS `OlmAccount`")
        connection.execSQL("DROP TABLE IF EXISTS `OlmForgetFallbackKeyAfter`")
        connection.execSQL("DROP TABLE IF EXISTS `OlmSession`")
        connection.execSQL("DROP TABLE IF EXISTS `OutboundMegolmSession`")
        connection.execSQL("DROP TABLE IF EXISTS `OutdatedKeys`")
        connection.execSQL("DROP TABLE IF EXISTS `RoomAccountData`")
        connection.execSQL("DROP TABLE IF EXISTS `RoomKeyRequest`")
        connection.execSQL("DROP TABLE IF EXISTS `RoomOutboxMessage2`")
        connection.execSQL("DROP TABLE IF EXISTS `Room`")
        connection.execSQL("DROP TABLE IF EXISTS `RoomState`")
        connection.execSQL("DROP TABLE IF EXISTS `RoomUser`")
        connection.execSQL("DROP TABLE IF EXISTS `RoomUserReceipts`")
        connection.execSQL("DROP TABLE IF EXISTS `SecretKeyRequest`")
        connection.execSQL("DROP TABLE IF EXISTS `Secrets`")
        connection.execSQL("DROP TABLE IF EXISTS `TimelineEventRelation`")
        connection.execSQL("DROP TABLE IF EXISTS `TimelineEvent`")
      }

      public override fun onCreate(connection: SQLiteConnection) {
      }

      public override fun onOpen(connection: SQLiteConnection) {
        internalInitInvalidationTracker(connection)
      }

      public override fun onPreMigrate(connection: SQLiteConnection) {
        dropFtsSyncTriggers(connection)
      }

      public override fun onPostMigrate(connection: SQLiteConnection) {
      }

      public override fun onValidateSchema(connection: SQLiteConnection):
          RoomOpenDelegate.ValidationResult {
        val _columnsAccount: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsAccount.put("id", TableInfo.Column("id", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("olmPickleKey", TableInfo.Column("olmPickleKey", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("baseUrl", TableInfo.Column("baseUrl", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("userId", TableInfo.Column("userId", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("deviceId", TableInfo.Column("deviceId", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("accessToken", TableInfo.Column("accessToken", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("refreshToken", TableInfo.Column("refreshToken", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("syncBatchToken", TableInfo.Column("syncBatchToken", "TEXT", false, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("filterId", TableInfo.Column("filterId", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("backgroundFilterId", TableInfo.Column("backgroundFilterId", "TEXT",
            false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("displayName", TableInfo.Column("displayName", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("avatarUrl", TableInfo.Column("avatarUrl", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsAccount.put("isLocked", TableInfo.Column("isLocked", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysAccount: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesAccount: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoAccount: TableInfo = TableInfo("Account", _columnsAccount, _foreignKeysAccount,
            _indicesAccount)
        val _existingAccount: TableInfo = read(connection, "Account")
        if (!_infoAccount.equals(_existingAccount)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |Account(net.folivo.trixnity.client.store.repository.room.RoomAccount).
              | Expected:
              |""".trimMargin() + _infoAccount + """
              |
              | Found:
              |""".trimMargin() + _existingAccount)
        }
        val _columnsServerData: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsServerData.put("id", TableInfo.Column("id", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsServerData.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysServerData: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesServerData: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoServerData: TableInfo = TableInfo("ServerData", _columnsServerData,
            _foreignKeysServerData, _indicesServerData)
        val _existingServerData: TableInfo = read(connection, "ServerData")
        if (!_infoServerData.equals(_existingServerData)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |ServerData(net.folivo.trixnity.client.store.repository.room.RoomServerData).
              | Expected:
              |""".trimMargin() + _infoServerData + """
              |
              | Found:
              |""".trimMargin() + _existingServerData)
        }
        val _columnsCrossSigningKeys: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsCrossSigningKeys.put("userId", TableInfo.Column("userId", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsCrossSigningKeys.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysCrossSigningKeys: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesCrossSigningKeys: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoCrossSigningKeys: TableInfo = TableInfo("CrossSigningKeys",
            _columnsCrossSigningKeys, _foreignKeysCrossSigningKeys, _indicesCrossSigningKeys)
        val _existingCrossSigningKeys: TableInfo = read(connection, "CrossSigningKeys")
        if (!_infoCrossSigningKeys.equals(_existingCrossSigningKeys)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |CrossSigningKeys(net.folivo.trixnity.client.store.repository.room.RoomCrossSigningKeys).
              | Expected:
              |""".trimMargin() + _infoCrossSigningKeys + """
              |
              | Found:
              |""".trimMargin() + _existingCrossSigningKeys)
        }
        val _columnsDeviceKeys: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsDeviceKeys.put("userId", TableInfo.Column("userId", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsDeviceKeys.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysDeviceKeys: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesDeviceKeys: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoDeviceKeys: TableInfo = TableInfo("DeviceKeys", _columnsDeviceKeys,
            _foreignKeysDeviceKeys, _indicesDeviceKeys)
        val _existingDeviceKeys: TableInfo = read(connection, "DeviceKeys")
        if (!_infoDeviceKeys.equals(_existingDeviceKeys)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |DeviceKeys(net.folivo.trixnity.client.store.repository.room.RoomDeviceKeys).
              | Expected:
              |""".trimMargin() + _infoDeviceKeys + """
              |
              | Found:
              |""".trimMargin() + _existingDeviceKeys)
        }
        val _columnsGlobalAccountData: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsGlobalAccountData.put("type", TableInfo.Column("type", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsGlobalAccountData.put("key", TableInfo.Column("key", "TEXT", true, 2, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsGlobalAccountData.put("event", TableInfo.Column("event", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysGlobalAccountData: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesGlobalAccountData: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoGlobalAccountData: TableInfo = TableInfo("GlobalAccountData",
            _columnsGlobalAccountData, _foreignKeysGlobalAccountData, _indicesGlobalAccountData)
        val _existingGlobalAccountData: TableInfo = read(connection, "GlobalAccountData")
        if (!_infoGlobalAccountData.equals(_existingGlobalAccountData)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |GlobalAccountData(net.folivo.trixnity.client.store.repository.room.RoomGlobalAccountData).
              | Expected:
              |""".trimMargin() + _infoGlobalAccountData + """
              |
              | Found:
              |""".trimMargin() + _existingGlobalAccountData)
        }
        val _columnsInboundMegolmMessageIndex: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsInboundMegolmMessageIndex.put("sessionId", TableInfo.Column("sessionId", "TEXT",
            true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmMessageIndex.put("roomId", TableInfo.Column("roomId", "TEXT", true, 2,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmMessageIndex.put("messageIndex", TableInfo.Column("messageIndex",
            "INTEGER", true, 3, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmMessageIndex.put("eventId", TableInfo.Column("eventId", "TEXT", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmMessageIndex.put("originTimestamp", TableInfo.Column("originTimestamp",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysInboundMegolmMessageIndex: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesInboundMegolmMessageIndex: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoInboundMegolmMessageIndex: TableInfo = TableInfo("InboundMegolmMessageIndex",
            _columnsInboundMegolmMessageIndex, _foreignKeysInboundMegolmMessageIndex,
            _indicesInboundMegolmMessageIndex)
        val _existingInboundMegolmMessageIndex: TableInfo = read(connection,
            "InboundMegolmMessageIndex")
        if (!_infoInboundMegolmMessageIndex.equals(_existingInboundMegolmMessageIndex)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |InboundMegolmMessageIndex(net.folivo.trixnity.client.store.repository.room.RoomInboundMegolmMessageIndex).
              | Expected:
              |""".trimMargin() + _infoInboundMegolmMessageIndex + """
              |
              | Found:
              |""".trimMargin() + _existingInboundMegolmMessageIndex)
        }
        val _columnsInboundMegolmSession: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsInboundMegolmSession.put("senderKey", TableInfo.Column("senderKey", "TEXT", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmSession.put("sessionId", TableInfo.Column("sessionId", "TEXT", true, 2,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmSession.put("roomId", TableInfo.Column("roomId", "TEXT", true, 3, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmSession.put("firstKnownIndex", TableInfo.Column("firstKnownIndex",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmSession.put("hasBeenBackedUp", TableInfo.Column("hasBeenBackedUp",
            "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmSession.put("isTrusted", TableInfo.Column("isTrusted", "INTEGER", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmSession.put("senderSigningKey", TableInfo.Column("senderSigningKey",
            "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmSession.put("forwardingCurve25519KeyChain",
            TableInfo.Column("forwardingCurve25519KeyChain", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsInboundMegolmSession.put("pickled", TableInfo.Column("pickled", "TEXT", true, 0,
            null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysInboundMegolmSession: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesInboundMegolmSession: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoInboundMegolmSession: TableInfo = TableInfo("InboundMegolmSession",
            _columnsInboundMegolmSession, _foreignKeysInboundMegolmSession,
            _indicesInboundMegolmSession)
        val _existingInboundMegolmSession: TableInfo = read(connection, "InboundMegolmSession")
        if (!_infoInboundMegolmSession.equals(_existingInboundMegolmSession)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |InboundMegolmSession(net.folivo.trixnity.client.store.repository.room.RoomInboundMegolmSession).
              | Expected:
              |""".trimMargin() + _infoInboundMegolmSession + """
              |
              | Found:
              |""".trimMargin() + _existingInboundMegolmSession)
        }
        val _columnsKeyChainLink: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsKeyChainLink.put("signingUserId", TableInfo.Column("signingUserId", "TEXT", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsKeyChainLink.put("signingKeyId", TableInfo.Column("signingKeyId", "TEXT", true, 2,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsKeyChainLink.put("signingKeyValue", TableInfo.Column("signingKeyValue", "TEXT",
            true, 3, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsKeyChainLink.put("signedUserId", TableInfo.Column("signedUserId", "TEXT", true, 4,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsKeyChainLink.put("signedKeyId", TableInfo.Column("signedKeyId", "TEXT", true, 5,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsKeyChainLink.put("signedKeyValue", TableInfo.Column("signedKeyValue", "TEXT", true,
            6, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysKeyChainLink: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesKeyChainLink: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoKeyChainLink: TableInfo = TableInfo("KeyChainLink", _columnsKeyChainLink,
            _foreignKeysKeyChainLink, _indicesKeyChainLink)
        val _existingKeyChainLink: TableInfo = read(connection, "KeyChainLink")
        if (!_infoKeyChainLink.equals(_existingKeyChainLink)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |KeyChainLink(net.folivo.trixnity.client.store.repository.room.RoomKeyChainLink).
              | Expected:
              |""".trimMargin() + _infoKeyChainLink + """
              |
              | Found:
              |""".trimMargin() + _existingKeyChainLink)
        }
        val _columnsKeyVerificationState: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsKeyVerificationState.put("keyId", TableInfo.Column("keyId", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsKeyVerificationState.put("keyAlgorithm", TableInfo.Column("keyAlgorithm", "TEXT",
            true, 2, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsKeyVerificationState.put("verificationState", TableInfo.Column("verificationState",
            "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysKeyVerificationState: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesKeyVerificationState: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoKeyVerificationState: TableInfo = TableInfo("KeyVerificationState",
            _columnsKeyVerificationState, _foreignKeysKeyVerificationState,
            _indicesKeyVerificationState)
        val _existingKeyVerificationState: TableInfo = read(connection, "KeyVerificationState")
        if (!_infoKeyVerificationState.equals(_existingKeyVerificationState)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |KeyVerificationState(net.folivo.trixnity.client.store.repository.room.RoomKeyVerificationState).
              | Expected:
              |""".trimMargin() + _infoKeyVerificationState + """
              |
              | Found:
              |""".trimMargin() + _existingKeyVerificationState)
        }
        val _columnsMediaCacheMapping: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsMediaCacheMapping.put("cacheUri", TableInfo.Column("cacheUri", "TEXT", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsMediaCacheMapping.put("mxcUri", TableInfo.Column("mxcUri", "TEXT", false, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsMediaCacheMapping.put("size", TableInfo.Column("size", "INTEGER", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsMediaCacheMapping.put("contentType", TableInfo.Column("contentType", "TEXT", false,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysMediaCacheMapping: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesMediaCacheMapping: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoMediaCacheMapping: TableInfo = TableInfo("MediaCacheMapping",
            _columnsMediaCacheMapping, _foreignKeysMediaCacheMapping, _indicesMediaCacheMapping)
        val _existingMediaCacheMapping: TableInfo = read(connection, "MediaCacheMapping")
        if (!_infoMediaCacheMapping.equals(_existingMediaCacheMapping)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |MediaCacheMapping(net.folivo.trixnity.client.store.repository.room.RoomMediaCacheMapping).
              | Expected:
              |""".trimMargin() + _infoMediaCacheMapping + """
              |
              | Found:
              |""".trimMargin() + _existingMediaCacheMapping)
        }
        val _columnsOlmAccount: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsOlmAccount.put("id", TableInfo.Column("id", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsOlmAccount.put("pickled", TableInfo.Column("pickled", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysOlmAccount: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesOlmAccount: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoOlmAccount: TableInfo = TableInfo("OlmAccount", _columnsOlmAccount,
            _foreignKeysOlmAccount, _indicesOlmAccount)
        val _existingOlmAccount: TableInfo = read(connection, "OlmAccount")
        if (!_infoOlmAccount.equals(_existingOlmAccount)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |OlmAccount(net.folivo.trixnity.client.store.repository.room.RoomOlmAccount).
              | Expected:
              |""".trimMargin() + _infoOlmAccount + """
              |
              | Found:
              |""".trimMargin() + _existingOlmAccount)
        }
        val _columnsOlmForgetFallbackKeyAfter: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsOlmForgetFallbackKeyAfter.put("id", TableInfo.Column("id", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsOlmForgetFallbackKeyAfter.put("instant", TableInfo.Column("instant", "INTEGER",
            true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysOlmForgetFallbackKeyAfter: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesOlmForgetFallbackKeyAfter: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoOlmForgetFallbackKeyAfter: TableInfo = TableInfo("OlmForgetFallbackKeyAfter",
            _columnsOlmForgetFallbackKeyAfter, _foreignKeysOlmForgetFallbackKeyAfter,
            _indicesOlmForgetFallbackKeyAfter)
        val _existingOlmForgetFallbackKeyAfter: TableInfo = read(connection,
            "OlmForgetFallbackKeyAfter")
        if (!_infoOlmForgetFallbackKeyAfter.equals(_existingOlmForgetFallbackKeyAfter)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |OlmForgetFallbackKeyAfter(net.folivo.trixnity.client.store.repository.room.RoomOlmForgetFallbackKeyAfter).
              | Expected:
              |""".trimMargin() + _infoOlmForgetFallbackKeyAfter + """
              |
              | Found:
              |""".trimMargin() + _existingOlmForgetFallbackKeyAfter)
        }
        val _columnsOlmSession: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsOlmSession.put("senderKey", TableInfo.Column("senderKey", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsOlmSession.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysOlmSession: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesOlmSession: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoOlmSession: TableInfo = TableInfo("OlmSession", _columnsOlmSession,
            _foreignKeysOlmSession, _indicesOlmSession)
        val _existingOlmSession: TableInfo = read(connection, "OlmSession")
        if (!_infoOlmSession.equals(_existingOlmSession)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |OlmSession(net.folivo.trixnity.client.store.repository.room.RoomOlmSession).
              | Expected:
              |""".trimMargin() + _infoOlmSession + """
              |
              | Found:
              |""".trimMargin() + _existingOlmSession)
        }
        val _columnsOutboundMegolmSession: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsOutboundMegolmSession.put("roomId", TableInfo.Column("roomId", "TEXT", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsOutboundMegolmSession.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysOutboundMegolmSession: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesOutboundMegolmSession: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoOutboundMegolmSession: TableInfo = TableInfo("OutboundMegolmSession",
            _columnsOutboundMegolmSession, _foreignKeysOutboundMegolmSession,
            _indicesOutboundMegolmSession)
        val _existingOutboundMegolmSession: TableInfo = read(connection, "OutboundMegolmSession")
        if (!_infoOutboundMegolmSession.equals(_existingOutboundMegolmSession)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |OutboundMegolmSession(net.folivo.trixnity.client.store.repository.room.RoomOutboundMegolmSession).
              | Expected:
              |""".trimMargin() + _infoOutboundMegolmSession + """
              |
              | Found:
              |""".trimMargin() + _existingOutboundMegolmSession)
        }
        val _columnsOutdatedKeys: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsOutdatedKeys.put("id", TableInfo.Column("id", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsOutdatedKeys.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysOutdatedKeys: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesOutdatedKeys: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoOutdatedKeys: TableInfo = TableInfo("OutdatedKeys", _columnsOutdatedKeys,
            _foreignKeysOutdatedKeys, _indicesOutdatedKeys)
        val _existingOutdatedKeys: TableInfo = read(connection, "OutdatedKeys")
        if (!_infoOutdatedKeys.equals(_existingOutdatedKeys)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |OutdatedKeys(net.folivo.trixnity.client.store.repository.room.RoomOutdatedKeys).
              | Expected:
              |""".trimMargin() + _infoOutdatedKeys + """
              |
              | Found:
              |""".trimMargin() + _existingOutdatedKeys)
        }
        val _columnsRoomAccountData: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsRoomAccountData.put("roomId", TableInfo.Column("roomId", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomAccountData.put("type", TableInfo.Column("type", "TEXT", true, 2, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomAccountData.put("key", TableInfo.Column("key", "TEXT", true, 3, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomAccountData.put("event", TableInfo.Column("event", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysRoomAccountData: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesRoomAccountData: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoRoomAccountData: TableInfo = TableInfo("RoomAccountData", _columnsRoomAccountData,
            _foreignKeysRoomAccountData, _indicesRoomAccountData)
        val _existingRoomAccountData: TableInfo = read(connection, "RoomAccountData")
        if (!_infoRoomAccountData.equals(_existingRoomAccountData)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |RoomAccountData(net.folivo.trixnity.client.store.repository.room.RoomRoomAccountData).
              | Expected:
              |""".trimMargin() + _infoRoomAccountData + """
              |
              | Found:
              |""".trimMargin() + _existingRoomAccountData)
        }
        val _columnsRoomKeyRequest: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsRoomKeyRequest.put("id", TableInfo.Column("id", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomKeyRequest.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysRoomKeyRequest: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesRoomKeyRequest: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoRoomKeyRequest: TableInfo = TableInfo("RoomKeyRequest", _columnsRoomKeyRequest,
            _foreignKeysRoomKeyRequest, _indicesRoomKeyRequest)
        val _existingRoomKeyRequest: TableInfo = read(connection, "RoomKeyRequest")
        if (!_infoRoomKeyRequest.equals(_existingRoomKeyRequest)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |RoomKeyRequest(net.folivo.trixnity.client.store.repository.room.RoomRoomKeyRequest).
              | Expected:
              |""".trimMargin() + _infoRoomKeyRequest + """
              |
              | Found:
              |""".trimMargin() + _existingRoomKeyRequest)
        }
        val _columnsRoomOutboxMessage2: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsRoomOutboxMessage2.put("roomId", TableInfo.Column("roomId", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomOutboxMessage2.put("transactionId", TableInfo.Column("transactionId", "TEXT",
            true, 2, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomOutboxMessage2.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomOutboxMessage2.put("contentType", TableInfo.Column("contentType", "TEXT", true,
            0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysRoomOutboxMessage2: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesRoomOutboxMessage2: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoRoomOutboxMessage2: TableInfo = TableInfo("RoomOutboxMessage2",
            _columnsRoomOutboxMessage2, _foreignKeysRoomOutboxMessage2, _indicesRoomOutboxMessage2)
        val _existingRoomOutboxMessage2: TableInfo = read(connection, "RoomOutboxMessage2")
        if (!_infoRoomOutboxMessage2.equals(_existingRoomOutboxMessage2)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |RoomOutboxMessage2(net.folivo.trixnity.client.store.repository.room.RoomRoomOutboxMessage).
              | Expected:
              |""".trimMargin() + _infoRoomOutboxMessage2 + """
              |
              | Found:
              |""".trimMargin() + _existingRoomOutboxMessage2)
        }
        val _columnsRoom: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsRoom.put("roomId", TableInfo.Column("roomId", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoom.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysRoom: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesRoom: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoRoom: TableInfo = TableInfo("Room", _columnsRoom, _foreignKeysRoom, _indicesRoom)
        val _existingRoom: TableInfo = read(connection, "Room")
        if (!_infoRoom.equals(_existingRoom)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |Room(net.folivo.trixnity.client.store.repository.room.RoomRoom).
              | Expected:
              |""".trimMargin() + _infoRoom + """
              |
              | Found:
              |""".trimMargin() + _existingRoom)
        }
        val _columnsRoomState: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsRoomState.put("roomId", TableInfo.Column("roomId", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomState.put("type", TableInfo.Column("type", "TEXT", true, 2, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomState.put("stateKey", TableInfo.Column("stateKey", "TEXT", true, 3, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomState.put("event", TableInfo.Column("event", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysRoomState: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesRoomState: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoRoomState: TableInfo = TableInfo("RoomState", _columnsRoomState,
            _foreignKeysRoomState, _indicesRoomState)
        val _existingRoomState: TableInfo = read(connection, "RoomState")
        if (!_infoRoomState.equals(_existingRoomState)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |RoomState(net.folivo.trixnity.client.store.repository.room.RoomRoomState).
              | Expected:
              |""".trimMargin() + _infoRoomState + """
              |
              | Found:
              |""".trimMargin() + _existingRoomState)
        }
        val _columnsRoomUser: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsRoomUser.put("userId", TableInfo.Column("userId", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomUser.put("roomId", TableInfo.Column("roomId", "TEXT", true, 2, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomUser.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysRoomUser: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesRoomUser: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoRoomUser: TableInfo = TableInfo("RoomUser", _columnsRoomUser, _foreignKeysRoomUser,
            _indicesRoomUser)
        val _existingRoomUser: TableInfo = read(connection, "RoomUser")
        if (!_infoRoomUser.equals(_existingRoomUser)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |RoomUser(net.folivo.trixnity.client.store.repository.room.RoomRoomUser).
              | Expected:
              |""".trimMargin() + _infoRoomUser + """
              |
              | Found:
              |""".trimMargin() + _existingRoomUser)
        }
        val _columnsRoomUserReceipts: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsRoomUserReceipts.put("userId", TableInfo.Column("userId", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomUserReceipts.put("roomId", TableInfo.Column("roomId", "TEXT", true, 2, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsRoomUserReceipts.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysRoomUserReceipts: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesRoomUserReceipts: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoRoomUserReceipts: TableInfo = TableInfo("RoomUserReceipts",
            _columnsRoomUserReceipts, _foreignKeysRoomUserReceipts, _indicesRoomUserReceipts)
        val _existingRoomUserReceipts: TableInfo = read(connection, "RoomUserReceipts")
        if (!_infoRoomUserReceipts.equals(_existingRoomUserReceipts)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |RoomUserReceipts(net.folivo.trixnity.client.store.repository.room.RoomRoomUserReceipts).
              | Expected:
              |""".trimMargin() + _infoRoomUserReceipts + """
              |
              | Found:
              |""".trimMargin() + _existingRoomUserReceipts)
        }
        val _columnsSecretKeyRequest: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsSecretKeyRequest.put("id", TableInfo.Column("id", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsSecretKeyRequest.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysSecretKeyRequest: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesSecretKeyRequest: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoSecretKeyRequest: TableInfo = TableInfo("SecretKeyRequest",
            _columnsSecretKeyRequest, _foreignKeysSecretKeyRequest, _indicesSecretKeyRequest)
        val _existingSecretKeyRequest: TableInfo = read(connection, "SecretKeyRequest")
        if (!_infoSecretKeyRequest.equals(_existingSecretKeyRequest)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |SecretKeyRequest(net.folivo.trixnity.client.store.repository.room.RoomSecretKeyRequest).
              | Expected:
              |""".trimMargin() + _infoSecretKeyRequest + """
              |
              | Found:
              |""".trimMargin() + _existingSecretKeyRequest)
        }
        val _columnsSecrets: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsSecrets.put("id", TableInfo.Column("id", "INTEGER", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsSecrets.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysSecrets: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesSecrets: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoSecrets: TableInfo = TableInfo("Secrets", _columnsSecrets, _foreignKeysSecrets,
            _indicesSecrets)
        val _existingSecrets: TableInfo = read(connection, "Secrets")
        if (!_infoSecrets.equals(_existingSecrets)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |Secrets(net.folivo.trixnity.client.store.repository.room.RoomSecrets).
              | Expected:
              |""".trimMargin() + _infoSecrets + """
              |
              | Found:
              |""".trimMargin() + _existingSecrets)
        }
        val _columnsTimelineEventRelation: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsTimelineEventRelation.put("roomId", TableInfo.Column("roomId", "TEXT", true, 1,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsTimelineEventRelation.put("eventId", TableInfo.Column("eventId", "TEXT", true, 2,
            null, TableInfo.CREATED_FROM_ENTITY))
        _columnsTimelineEventRelation.put("relationType", TableInfo.Column("relationType", "TEXT",
            true, 3, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsTimelineEventRelation.put("relatedEventId", TableInfo.Column("relatedEventId",
            "TEXT", true, 4, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysTimelineEventRelation: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesTimelineEventRelation: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoTimelineEventRelation: TableInfo = TableInfo("TimelineEventRelation",
            _columnsTimelineEventRelation, _foreignKeysTimelineEventRelation,
            _indicesTimelineEventRelation)
        val _existingTimelineEventRelation: TableInfo = read(connection, "TimelineEventRelation")
        if (!_infoTimelineEventRelation.equals(_existingTimelineEventRelation)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |TimelineEventRelation(net.folivo.trixnity.client.store.repository.room.RoomTimelineEventRelation).
              | Expected:
              |""".trimMargin() + _infoTimelineEventRelation + """
              |
              | Found:
              |""".trimMargin() + _existingTimelineEventRelation)
        }
        val _columnsTimelineEvent: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsTimelineEvent.put("roomId", TableInfo.Column("roomId", "TEXT", true, 1, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsTimelineEvent.put("eventId", TableInfo.Column("eventId", "TEXT", true, 2, null,
            TableInfo.CREATED_FROM_ENTITY))
        _columnsTimelineEvent.put("value", TableInfo.Column("value", "TEXT", true, 0, null,
            TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysTimelineEvent: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesTimelineEvent: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoTimelineEvent: TableInfo = TableInfo("TimelineEvent", _columnsTimelineEvent,
            _foreignKeysTimelineEvent, _indicesTimelineEvent)
        val _existingTimelineEvent: TableInfo = read(connection, "TimelineEvent")
        if (!_infoTimelineEvent.equals(_existingTimelineEvent)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |TimelineEvent(net.folivo.trixnity.client.store.repository.room.RoomTimelineEvent).
              | Expected:
              |""".trimMargin() + _infoTimelineEvent + """
              |
              | Found:
              |""".trimMargin() + _existingTimelineEvent)
        }
        return RoomOpenDelegate.ValidationResult(true, null)
      }
    }
    return _openDelegate
  }

  protected override fun createInvalidationTracker(): InvalidationTracker {
    val _shadowTablesMap: MutableMap<String, String> = mutableMapOf()
    val _viewTables: MutableMap<String, Set<String>> = mutableMapOf()
    return InvalidationTracker(this, _shadowTablesMap, _viewTables, "Account", "ServerData",
        "CrossSigningKeys", "DeviceKeys", "GlobalAccountData", "InboundMegolmMessageIndex",
        "InboundMegolmSession", "KeyChainLink", "KeyVerificationState", "MediaCacheMapping",
        "OlmAccount", "OlmForgetFallbackKeyAfter", "OlmSession", "OutboundMegolmSession",
        "OutdatedKeys", "RoomAccountData", "RoomKeyRequest", "RoomOutboxMessage2", "Room",
        "RoomState", "RoomUser", "RoomUserReceipts", "SecretKeyRequest", "Secrets",
        "TimelineEventRelation", "TimelineEvent")
  }

  protected override fun getRequiredTypeConverterClasses(): Map<KClass<*>, List<KClass<*>>> {
    val _typeConvertersMap: MutableMap<KClass<*>, List<KClass<*>>> = mutableMapOf()
    _typeConvertersMap.put(AccountDao::class, AccountDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(ServerDataDao::class, ServerDataDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(CrossSigningKeysDao::class,
        CrossSigningKeysDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(DeviceKeysDao::class, DeviceKeysDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(GlobalAccountDataDao::class,
        GlobalAccountDataDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(InboundMegolmMessageIndexDao::class,
        InboundMegolmMessageIndexDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(InboundMegolmSessionDao::class,
        InboundMegolmSessionDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(KeyChainLinkDao::class, KeyChainLinkDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(KeyVerificationStateDao::class,
        KeyVerificationStateDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(MediaCacheMappingDao::class,
        MediaCacheMappingDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(OlmAccountDao::class, OlmAccountDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(OlmForgetFallbackKeyAfterDao::class,
        OlmForgetFallbackKeyAfterDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(OlmSessionDao::class, OlmSessionDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(OutboundMegolmSessionDao::class,
        OutboundMegolmSessionDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(OutdatedKeysDao::class, OutdatedKeysDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(RoomAccountDataDao::class,
        RoomAccountDataDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(RoomKeyRequestDao::class, RoomKeyRequestDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(RoomOutboxMessageDao::class,
        RoomOutboxMessageDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(RoomRoomDao::class, RoomRoomDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(RoomStateDao::class, RoomStateDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(RoomUserDao::class, RoomUserDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(RoomUserReceiptsDao::class,
        RoomUserReceiptsDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(SecretKeyRequestDao::class,
        SecretKeyRequestDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(SecretsDao::class, SecretsDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(TimelineEventRelationDao::class,
        TimelineEventRelationDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(TimelineEventDao::class, TimelineEventDao_Impl.getRequiredConverters())
    return _typeConvertersMap
  }

  public override fun getRequiredAutoMigrationSpecClasses(): Set<KClass<out AutoMigrationSpec>> {
    val _autoMigrationSpecsSet: MutableSet<KClass<out AutoMigrationSpec>> = mutableSetOf()
    return _autoMigrationSpecsSet
  }

  public override
      fun createAutoMigrations(autoMigrationSpecs: Map<KClass<out AutoMigrationSpec>, AutoMigrationSpec>):
      List<Migration> {
    val _autoMigrations: MutableList<Migration> = mutableListOf()
    return _autoMigrations
  }

  public override fun account(): AccountDao = _accountDao.value

  public override fun serverData(): ServerDataDao = _serverDataDao.value

  public override fun crossSigningKeys(): CrossSigningKeysDao = _crossSigningKeysDao.value

  public override fun deviceKeys(): DeviceKeysDao = _deviceKeysDao.value

  public override fun globalAccountData(): GlobalAccountDataDao = _globalAccountDataDao.value

  public override fun inboundMegolmMessageIndex(): InboundMegolmMessageIndexDao =
      _inboundMegolmMessageIndexDao.value

  public override fun inboundMegolmSession(): InboundMegolmSessionDao =
      _inboundMegolmSessionDao.value

  public override fun keyChainLink(): KeyChainLinkDao = _keyChainLinkDao.value

  public override fun keyVerificationState(): KeyVerificationStateDao =
      _keyVerificationStateDao.value

  public override fun mediaCacheMapping(): MediaCacheMappingDao = _mediaCacheMappingDao.value

  public override fun olmAccount(): OlmAccountDao = _olmAccountDao.value

  public override fun olmForgetFallbackKeyAfter(): OlmForgetFallbackKeyAfterDao =
      _olmForgetFallbackKeyAfterDao.value

  public override fun olmSession(): OlmSessionDao = _olmSessionDao.value

  public override fun outboundMegolmSession(): OutboundMegolmSessionDao =
      _outboundMegolmSessionDao.value

  public override fun outdatedKeys(): OutdatedKeysDao = _outdatedKeysDao.value

  public override fun roomAccountData(): RoomAccountDataDao = _roomAccountDataDao.value

  public override fun roomKeyRequest(): RoomKeyRequestDao = _roomKeyRequestDao.value

  public override fun roomOutboxMessage(): RoomOutboxMessageDao = _roomOutboxMessageDao.value

  public override fun room(): RoomRoomDao = _roomRoomDao.value

  public override fun roomState(): RoomStateDao = _roomStateDao.value

  public override fun roomUser(): RoomUserDao = _roomUserDao.value

  public override fun roomUserReceipts(): RoomUserReceiptsDao = _roomUserReceiptsDao.value

  public override fun secretKeyRequest(): SecretKeyRequestDao = _secretKeyRequestDao.value

  public override fun secrets(): SecretsDao = _secretsDao.value

  public override fun timelineEventRelation(): TimelineEventRelationDao =
      _timelineEventRelationDao.value

  public override fun timelineEvent(): TimelineEventDao = _timelineEventDao.value
}
