package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.EventId
import net.folivo.trixnity.core.model.RoomId

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class TimelineEventDao_Impl(
  __db: RoomDatabase,
) : TimelineEventDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomTimelineEvent: EntityInsertAdapter<RoomTimelineEvent>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomTimelineEvent = object : EntityInsertAdapter<RoomTimelineEvent>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `TimelineEvent` (`roomId`,`eventId`,`value`) VALUES (?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomTimelineEvent) {
        val _tmp: String? = RoomIdConverter.to(entity.roomId)
        if (_tmp == null) {
          statement.bindNull(1)
        } else {
          statement.bindText(1, _tmp)
        }
        val _tmp_1: String? = EventIdConverter.to(entity.eventId)
        if (_tmp_1 == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmp_1)
        }
        statement.bindText(3, entity.value)
      }
    }
  }

  public override suspend fun insert(entity: RoomTimelineEvent): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfRoomTimelineEvent.insert(_connection, entity)
  }

  public override suspend fun `get`(roomId: RoomId, eventId: EventId): RoomTimelineEvent? {
    val _sql: String = "SELECT * FROM TimelineEvent WHERE roomId = ? AND eventId = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        val _tmp_1: String? = EventIdConverter.to(eventId)
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_1)
        }
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfEventId: Int = getColumnIndexOrThrow(_stmt, "eventId")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: RoomTimelineEvent?
        if (_stmt.step()) {
          val _tmpRoomId: RoomId
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_3: RoomId? = RoomIdConverter.from(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_3
          }
          val _tmpEventId: EventId
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfEventId)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfEventId)
          }
          val _tmp_5: EventId? = EventIdConverter.from(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.EventId', but it was NULL.")
          } else {
            _tmpEventId = _tmp_5
          }
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _result = RoomTimelineEvent(_tmpRoomId,_tmpEventId,_tmpValue)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId) {
    val _sql: String = "DELETE FROM TimelineEvent WHERE roomId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId, eventId: EventId) {
    val _sql: String = "DELETE FROM TimelineEvent WHERE roomId = ? AND eventId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        val _tmp_1: String? = EventIdConverter.to(eventId)
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_1)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM TimelineEvent"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
