package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.RoomId
import net.folivo.trixnity.core.model.UserId

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RoomUserDao_Impl(
  __db: RoomDatabase,
) : RoomUserDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomRoomUser: EntityInsertAdapter<RoomRoomUser>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomRoomUser = object : EntityInsertAdapter<RoomRoomUser>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `RoomUser` (`userId`,`roomId`,`value`) VALUES (?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomRoomUser) {
        val _tmp: String? = UserIdConverter.to(entity.userId)
        if (_tmp == null) {
          statement.bindNull(1)
        } else {
          statement.bindText(1, _tmp)
        }
        val _tmp_1: String? = RoomIdConverter.to(entity.roomId)
        if (_tmp_1 == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmp_1)
        }
        statement.bindText(3, entity.value)
      }
    }
  }

  public override suspend fun insert(entity: RoomRoomUser): Unit = performSuspending(__db, false,
      true) { _connection ->
    __insertAdapterOfRoomRoomUser.insert(_connection, entity)
  }

  public override suspend fun insertAll(entities: List<RoomRoomUser>): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRoomRoomUser.insert(_connection, entities)
  }

  public override suspend fun `get`(userId: UserId, roomId: RoomId): RoomRoomUser? {
    val _sql: String = "SELECT * FROM RoomUser WHERE userId = ? AND roomId = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = UserIdConverter.to(userId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        val _tmp_1: String? = RoomIdConverter.to(roomId)
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_1)
        }
        val _columnIndexOfUserId: Int = getColumnIndexOrThrow(_stmt, "userId")
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: RoomRoomUser?
        if (_stmt.step()) {
          val _tmpUserId: UserId
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfUserId)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfUserId)
          }
          val _tmp_3: UserId? = UserIdConverter.from(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.UserId', but it was NULL.")
          } else {
            _tmpUserId = _tmp_3
          }
          val _tmpRoomId: RoomId
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_5: RoomId? = RoomIdConverter.from(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_5
          }
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _result = RoomRoomUser(_tmpUserId,_tmpRoomId,_tmpValue)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun `get`(roomId: RoomId): List<RoomRoomUser> {
    val _sql: String = "SELECT * FROM RoomUser WHERE roomId = ?"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        val _columnIndexOfUserId: Int = getColumnIndexOrThrow(_stmt, "userId")
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: MutableList<RoomRoomUser> = mutableListOf()
        while (_stmt.step()) {
          val _item: RoomRoomUser
          val _tmpUserId: UserId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfUserId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfUserId)
          }
          val _tmp_2: UserId? = UserIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.UserId', but it was NULL.")
          } else {
            _tmpUserId = _tmp_2
          }
          val _tmpRoomId: RoomId
          val _tmp_3: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_4: RoomId? = RoomIdConverter.from(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_4
          }
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _item = RoomRoomUser(_tmpUserId,_tmpRoomId,_tmpValue)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId) {
    val _sql: String = "DELETE FROM RoomUser WHERE roomId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId, userId: UserId) {
    val _sql: String = "DELETE FROM RoomUser WHERE roomId = ? AND userId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        val _tmp_1: String? = UserIdConverter.to(userId)
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_1)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM RoomUser"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
