package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.RoomId

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RoomRoomDao_Impl(
  __db: RoomDatabase,
) : RoomRoomDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomRoom: EntityInsertAdapter<RoomRoom>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomRoom = object : EntityInsertAdapter<RoomRoom>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `Room` (`roomId`,`value`) VALUES (?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomRoom) {
        val _tmp: String? = RoomIdConverter.to(entity.roomId)
        if (_tmp == null) {
          statement.bindNull(1)
        } else {
          statement.bindText(1, _tmp)
        }
        statement.bindText(2, entity.value)
      }
    }
  }

  public override suspend fun insert(entity: RoomRoom): Unit = performSuspending(__db, false, true)
      { _connection ->
    __insertAdapterOfRoomRoom.insert(_connection, entity)
  }

  public override suspend fun `get`(roomId: RoomId): RoomRoom? {
    val _sql: String = "SELECT * FROM Room WHERE roomId = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: RoomRoom?
        if (_stmt.step()) {
          val _tmpRoomId: RoomId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_2: RoomId? = RoomIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_2
          }
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _result = RoomRoom(_tmpRoomId,_tmpValue)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getAll(): List<RoomRoom> {
    val _sql: String = "SELECT * FROM Room"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: MutableList<RoomRoom> = mutableListOf()
        while (_stmt.step()) {
          val _item: RoomRoom
          val _tmpRoomId: RoomId
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_1: RoomId? = RoomIdConverter.from(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_1
          }
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _item = RoomRoom(_tmpRoomId,_tmpValue)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId) {
    val _sql: String = "DELETE FROM Room WHERE roomId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM Room"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
