package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.RoomId

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RoomOutboxMessageDao_Impl(
  __db: RoomDatabase,
) : RoomOutboxMessageDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomRoomOutboxMessage: EntityInsertAdapter<RoomRoomOutboxMessage>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomRoomOutboxMessage = object :
        EntityInsertAdapter<RoomRoomOutboxMessage>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `RoomOutboxMessage2` (`roomId`,`transactionId`,`value`,`contentType`) VALUES (?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomRoomOutboxMessage) {
        val _tmp: String? = RoomIdConverter.to(entity.roomId)
        if (_tmp == null) {
          statement.bindNull(1)
        } else {
          statement.bindText(1, _tmp)
        }
        statement.bindText(2, entity.transactionId)
        statement.bindText(3, entity.value)
        statement.bindText(4, entity.contentType)
      }
    }
  }

  public override suspend fun insert(entity: RoomRoomOutboxMessage): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfRoomRoomOutboxMessage.insert(_connection, entity)
  }

  public override suspend fun `get`(roomId: RoomId, transactionId: String): RoomRoomOutboxMessage? {
    val _sql: String =
        "SELECT * FROM RoomOutboxMessage2 WHERE roomId = ? AND transactionId = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        _stmt.bindText(_argIndex, transactionId)
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfTransactionId: Int = getColumnIndexOrThrow(_stmt, "transactionId")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _columnIndexOfContentType: Int = getColumnIndexOrThrow(_stmt, "contentType")
        val _result: RoomRoomOutboxMessage?
        if (_stmt.step()) {
          val _tmpRoomId: RoomId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_2: RoomId? = RoomIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_2
          }
          val _tmpTransactionId: String
          _tmpTransactionId = _stmt.getText(_columnIndexOfTransactionId)
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          val _tmpContentType: String
          _tmpContentType = _stmt.getText(_columnIndexOfContentType)
          _result = RoomRoomOutboxMessage(_tmpRoomId,_tmpTransactionId,_tmpValue,_tmpContentType)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getAll(): List<RoomRoomOutboxMessage> {
    val _sql: String = "SELECT * FROM RoomOutboxMessage2"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfTransactionId: Int = getColumnIndexOrThrow(_stmt, "transactionId")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _columnIndexOfContentType: Int = getColumnIndexOrThrow(_stmt, "contentType")
        val _result: MutableList<RoomRoomOutboxMessage> = mutableListOf()
        while (_stmt.step()) {
          val _item: RoomRoomOutboxMessage
          val _tmpRoomId: RoomId
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_1: RoomId? = RoomIdConverter.from(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_1
          }
          val _tmpTransactionId: String
          _tmpTransactionId = _stmt.getText(_columnIndexOfTransactionId)
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          val _tmpContentType: String
          _tmpContentType = _stmt.getText(_columnIndexOfContentType)
          _item = RoomRoomOutboxMessage(_tmpRoomId,_tmpTransactionId,_tmpValue,_tmpContentType)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId, transactionId: String) {
    val _sql: String = "DELETE FROM RoomOutboxMessage2 WHERE roomId = ? AND transactionId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        _stmt.bindText(_argIndex, transactionId)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId) {
    val _sql: String = "DELETE FROM RoomOutboxMessage2 WHERE roomId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM RoomOutboxMessage2"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
