package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.keys.KeyAlgorithm

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class KeyVerificationStateDao_Impl(
  __db: RoomDatabase,
) : KeyVerificationStateDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomKeyVerificationState:
      EntityInsertAdapter<RoomKeyVerificationState>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomKeyVerificationState = object :
        EntityInsertAdapter<RoomKeyVerificationState>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `KeyVerificationState` (`keyId`,`keyAlgorithm`,`verificationState`) VALUES (?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomKeyVerificationState) {
        statement.bindText(1, entity.keyId)
        val _tmp: String? = KeyAlgorithmConverter.to(entity.keyAlgorithm)
        if (_tmp == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmp)
        }
        statement.bindText(3, entity.verificationState)
      }
    }
  }

  public override suspend fun insert(entity: RoomKeyVerificationState): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRoomKeyVerificationState.insert(_connection, entity)
  }

  public override suspend fun `get`(keyId: String, keyAlgorithm: KeyAlgorithm):
      RoomKeyVerificationState? {
    val _sql: String =
        "SELECT * FROM KeyVerificationState WHERE keyId = ? AND keyAlgorithm = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, keyId)
        _argIndex = 2
        val _tmp: String? = KeyAlgorithmConverter.to(keyAlgorithm)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        val _columnIndexOfKeyId: Int = getColumnIndexOrThrow(_stmt, "keyId")
        val _columnIndexOfKeyAlgorithm: Int = getColumnIndexOrThrow(_stmt, "keyAlgorithm")
        val _columnIndexOfVerificationState: Int = getColumnIndexOrThrow(_stmt, "verificationState")
        val _result: RoomKeyVerificationState?
        if (_stmt.step()) {
          val _tmpKeyId: String
          _tmpKeyId = _stmt.getText(_columnIndexOfKeyId)
          val _tmpKeyAlgorithm: KeyAlgorithm
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfKeyAlgorithm)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfKeyAlgorithm)
          }
          val _tmp_2: KeyAlgorithm? = KeyAlgorithmConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.keys.KeyAlgorithm', but it was NULL.")
          } else {
            _tmpKeyAlgorithm = _tmp_2
          }
          val _tmpVerificationState: String
          _tmpVerificationState = _stmt.getText(_columnIndexOfVerificationState)
          _result = RoomKeyVerificationState(_tmpKeyId,_tmpKeyAlgorithm,_tmpVerificationState)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(keyId: String, keyAlgorithm: KeyAlgorithm) {
    val _sql: String = "DELETE FROM KeyVerificationState WHERE keyId = ? AND keyAlgorithm = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, keyId)
        _argIndex = 2
        val _tmp: String? = KeyAlgorithmConverter.to(keyAlgorithm)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM KeyVerificationState"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
