package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.getTotalChangedRows
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.EventId
import net.folivo.trixnity.core.model.RoomId

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class InboundMegolmMessageIndexDao_Impl(
  __db: RoomDatabase,
) : InboundMegolmMessageIndexDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomInboundMegolmMessageIndex:
      EntityInsertAdapter<RoomInboundMegolmMessageIndex>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomInboundMegolmMessageIndex = object :
        EntityInsertAdapter<RoomInboundMegolmMessageIndex>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `InboundMegolmMessageIndex` (`sessionId`,`roomId`,`messageIndex`,`eventId`,`originTimestamp`) VALUES (?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement,
          entity: RoomInboundMegolmMessageIndex) {
        statement.bindText(1, entity.sessionId)
        val _tmp: String? = RoomIdConverter.to(entity.roomId)
        if (_tmp == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmp)
        }
        statement.bindLong(3, entity.messageIndex)
        val _tmp_1: String? = EventIdConverter.to(entity.eventId)
        if (_tmp_1 == null) {
          statement.bindNull(4)
        } else {
          statement.bindText(4, _tmp_1)
        }
        statement.bindLong(5, entity.originTimestamp)
      }
    }
  }

  public override suspend fun insert(entity: RoomInboundMegolmMessageIndex): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRoomInboundMegolmMessageIndex.insert(_connection, entity)
  }

  public override suspend fun `get`(
    sessionId: String,
    roomId: RoomId,
    messageIndex: Long,
  ): RoomInboundMegolmMessageIndex? {
    val _sql: String = """
        |
        |        SELECT * FROM InboundMegolmMessageIndex
        |        WHERE sessionId = ?
        |        AND roomId = ?
        |        AND messageIndex = ?
        |        LIMIT 1
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, sessionId)
        _argIndex = 2
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 3
        _stmt.bindLong(_argIndex, messageIndex)
        val _columnIndexOfSessionId: Int = getColumnIndexOrThrow(_stmt, "sessionId")
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfMessageIndex: Int = getColumnIndexOrThrow(_stmt, "messageIndex")
        val _columnIndexOfEventId: Int = getColumnIndexOrThrow(_stmt, "eventId")
        val _columnIndexOfOriginTimestamp: Int = getColumnIndexOrThrow(_stmt, "originTimestamp")
        val _result: RoomInboundMegolmMessageIndex?
        if (_stmt.step()) {
          val _tmpSessionId: String
          _tmpSessionId = _stmt.getText(_columnIndexOfSessionId)
          val _tmpRoomId: RoomId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_2: RoomId? = RoomIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_2
          }
          val _tmpMessageIndex: Long
          _tmpMessageIndex = _stmt.getLong(_columnIndexOfMessageIndex)
          val _tmpEventId: EventId
          val _tmp_3: String?
          if (_stmt.isNull(_columnIndexOfEventId)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getText(_columnIndexOfEventId)
          }
          val _tmp_4: EventId? = EventIdConverter.from(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.EventId', but it was NULL.")
          } else {
            _tmpEventId = _tmp_4
          }
          val _tmpOriginTimestamp: Long
          _tmpOriginTimestamp = _stmt.getLong(_columnIndexOfOriginTimestamp)
          _result =
              RoomInboundMegolmMessageIndex(_tmpSessionId,_tmpRoomId,_tmpMessageIndex,_tmpEventId,_tmpOriginTimestamp)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(
    sessionId: String,
    roomId: RoomId,
    messageIndex: Long,
  ): Int {
    val _sql: String = """
        |
        |        DELETE FROM InboundMegolmMessageIndex
        |        WHERE sessionId = ?
        |        AND roomId = ?
        |        AND messageIndex = ?
        |        
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, sessionId)
        _argIndex = 2
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 3
        _stmt.bindLong(_argIndex, messageIndex)
        _stmt.step()
        getTotalChangedRows(_connection)
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM InboundMegolmMessageIndex"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
