/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.matrix.appservice.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.folivo.matrix.appservice.api.AppserviceController;
import net.folivo.matrix.appservice.api.AppserviceHandler;
import net.folivo.matrix.appservice.api.AppserviceHandlerHelper;
import net.folivo.matrix.appservice.api.DefaultAppserviceHandler;
import net.folivo.matrix.appservice.api.event.MatrixAppserviceEventService;
import net.folivo.matrix.appservice.api.room.MatrixAppserviceRoomService;
import net.folivo.matrix.appservice.api.user.MatrixAppserviceUserService;
import net.folivo.matrix.appservice.config.ErrorResponseAttributes;
import net.folivo.matrix.appservice.config.MatrixAppserviceAutoconfiguration;
import net.folivo.matrix.appservice.config.MatrixAppserviceExceptionHandler;
import net.folivo.matrix.appservice.config.MatrixAppserviceProperties;
import net.folivo.matrix.appservice.config.MatrixHomeServerAuthenticationConverter;
import net.folivo.matrix.appservice.config.MatrixHomeServerAuthenticationManager;
import net.folivo.matrix.core.api.ErrorResponse;
import net.folivo.matrix.restclient.MatrixClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.web.reactive.config.EnableWebFlux;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableWebFluxSecurity
@EnableWebFlux
@EnableConfigurationProperties(value={MatrixAppserviceProperties.class})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J0\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\nH\u0017J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0017J\b\u0010\u0019\u001a\u00020\u001aH\u0017J\"\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/folivo/matrix/appservice/config/MatrixAppserviceAutoconfiguration;", "", "matrixAppserviceProperties", "Lnet/folivo/matrix/appservice/config/MatrixAppserviceProperties;", "(Lnet/folivo/matrix/appservice/config/MatrixAppserviceProperties;)V", "appserviceController", "Lnet/folivo/matrix/appservice/api/AppserviceController;", "appserviceHandler", "Lnet/folivo/matrix/appservice/api/AppserviceHandler;", "appserviceHandlerHelper", "Lnet/folivo/matrix/appservice/api/AppserviceHandlerHelper;", "matrixClient", "Lnet/folivo/matrix/restclient/MatrixClient;", "matrixAppserviceUserService", "Lnet/folivo/matrix/appservice/api/user/MatrixAppserviceUserService;", "matrixAppserviceRoomService", "Lnet/folivo/matrix/appservice/api/room/MatrixAppserviceRoomService;", "defaultAppserviceHandler", "matrixAppserviceEventService", "Lnet/folivo/matrix/appservice/api/event/MatrixAppserviceEventService;", "helper", "errorResponseAttributes", "Lnet/folivo/matrix/appservice/config/ErrorResponseAttributes;", "matrixAppserviceExceptionHandler", "Lnet/folivo/matrix/appservice/config/MatrixAppserviceExceptionHandler;", "matrixHomeServerAuthenticationManager", "Lorg/springframework/security/authentication/ReactiveAuthenticationManager;", "springSecurityFilterChain", "Lorg/springframework/security/web/server/SecurityWebFilterChain;", "http", "Lorg/springframework/security/config/web/server/ServerHttpSecurity;", "Lnet/folivo/matrix/appservice/config/MatrixHomeServerAuthenticationManager;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "matrix-spring-boot-rest-appservice"})
public class MatrixAppserviceAutoconfiguration {
    private final MatrixAppserviceProperties matrixAppserviceProperties;

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AppserviceHandlerHelper appserviceHandlerHelper(@NotNull MatrixClient matrixClient, @NotNull MatrixAppserviceUserService matrixAppserviceUserService, @NotNull MatrixAppserviceRoomService matrixAppserviceRoomService) {
        Intrinsics.checkNotNullParameter((Object)matrixClient, (String)"matrixClient");
        Intrinsics.checkNotNullParameter((Object)matrixAppserviceUserService, (String)"matrixAppserviceUserService");
        Intrinsics.checkNotNullParameter((Object)matrixAppserviceRoomService, (String)"matrixAppserviceRoomService");
        return new AppserviceHandlerHelper(matrixClient, matrixAppserviceUserService, matrixAppserviceRoomService);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AppserviceHandler defaultAppserviceHandler(@NotNull MatrixClient matrixClient, @NotNull MatrixAppserviceEventService matrixAppserviceEventService, @NotNull MatrixAppserviceUserService matrixAppserviceUserService, @NotNull MatrixAppserviceRoomService matrixAppserviceRoomService, @NotNull AppserviceHandlerHelper helper) {
        Intrinsics.checkNotNullParameter((Object)matrixClient, (String)"matrixClient");
        Intrinsics.checkNotNullParameter((Object)matrixAppserviceEventService, (String)"matrixAppserviceEventService");
        Intrinsics.checkNotNullParameter((Object)matrixAppserviceUserService, (String)"matrixAppserviceUserService");
        Intrinsics.checkNotNullParameter((Object)matrixAppserviceRoomService, (String)"matrixAppserviceRoomService");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        return new DefaultAppserviceHandler(matrixAppserviceEventService, matrixAppserviceUserService, matrixAppserviceRoomService, helper);
    }

    @Bean
    @NotNull
    public AppserviceController appserviceController(@NotNull AppserviceHandler appserviceHandler) {
        Intrinsics.checkNotNullParameter((Object)appserviceHandler, (String)"appserviceHandler");
        return new AppserviceController(appserviceHandler);
    }

    @Bean
    @NotNull
    public MatrixAppserviceExceptionHandler matrixAppserviceExceptionHandler() {
        return new MatrixAppserviceExceptionHandler();
    }

    @Bean
    @Nullable
    public SecurityWebFilterChain springSecurityFilterChain(@NotNull ServerHttpSecurity http, @NotNull MatrixHomeServerAuthenticationManager matrixHomeServerAuthenticationManager, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)matrixHomeServerAuthenticationManager, (String)"matrixHomeServerAuthenticationManager");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        AuthenticationWebFilter authenticationWebFilter = new AuthenticationWebFilter((ReactiveAuthenticationManager)matrixHomeServerAuthenticationManager);
        authenticationWebFilter.setServerAuthenticationConverter((ServerAuthenticationConverter)new MatrixHomeServerAuthenticationConverter());
        authenticationWebFilter.setSecurityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance());
        authenticationWebFilter.setAuthenticationFailureHandler(new ServerAuthenticationFailureHandler(objectMapper){
            final /* synthetic */ ObjectMapper $objectMapper;

            public final Mono<Void> onAuthenticationFailure(WebFilterExchange webFilterExchange, AuthenticationException $noName_1) {
                return Mono.defer((Supplier)new Supplier<Mono<? extends ServerHttpResponse>>(webFilterExchange){
                    final /* synthetic */ WebFilterExchange $webFilterExchange;

                    public final Mono<? extends ServerHttpResponse> get() {
                        WebFilterExchange webFilterExchange = this.$webFilterExchange;
                        Intrinsics.checkNotNullExpressionValue((Object)webFilterExchange, (String)"webFilterExchange");
                        ServerWebExchange serverWebExchange = webFilterExchange.getExchange();
                        Intrinsics.checkNotNullExpressionValue((Object)serverWebExchange, (String)"webFilterExchange.exchange");
                        return Mono.just((Object)serverWebExchange.getResponse());
                    }
                    {
                        this.$webFilterExchange = webFilterExchange;
                    }
                }).flatMap((Function)new Function<ServerHttpResponse, Mono<? extends Void>>(this){
                    final /* synthetic */ springSecurityFilterChain.1 this$0;

                    public final Mono<? extends Void> apply(@NotNull ServerHttpResponse response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        response.setStatusCode(HttpStatus.FORBIDDEN);
                        HttpHeaders httpHeaders = response.getHeaders();
                        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"response.headers");
                        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
                        DataBufferFactory dataBufferFactory = response.bufferFactory();
                        Intrinsics.checkNotNullExpressionValue((Object)dataBufferFactory, (String)"response.bufferFactory()");
                        DataBufferFactory dataBufferFactory2 = dataBufferFactory;
                        DataBuffer dataBuffer = dataBufferFactory2.wrap(this.this$0.$objectMapper.writeValueAsBytes((Object)new ErrorResponse("403", "NET.FOLIVO.MATRIX_FORBIDDEN")));
                        Intrinsics.checkNotNullExpressionValue((Object)dataBuffer, (String)"dataBufferFactory.wrap(\n\u2026                        )");
                        DataBuffer buffer = dataBuffer;
                        return response.writeWith((Publisher)Mono.just((Object)buffer)).doOnError((Consumer)new Consumer<Throwable>(buffer){
                            final /* synthetic */ DataBuffer $buffer;

                            public final void accept(Throwable it) {
                                DataBufferUtils.release((DataBuffer)this.$buffer);
                            }
                            {
                                this.$buffer = dataBuffer;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$objectMapper = objectMapper;
            }
        });
        ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.authorizeExchange().pathMatchers(new String[]{"/**"})).authenticated().and().csrf().disable().requestCache().disable().formLogin().disable().httpBasic().disable().logout().disable().addFilterAt((WebFilter)authenticationWebFilter, SecurityWebFiltersOrder.AUTHENTICATION).exceptionHandling();
        return http.build();
    }

    @Bean
    @NotNull
    public ReactiveAuthenticationManager matrixHomeServerAuthenticationManager() {
        return new MatrixHomeServerAuthenticationManager(this.matrixAppserviceProperties.getHsToken());
    }

    @Bean
    @NotNull
    public ErrorResponseAttributes errorResponseAttributes() {
        return new ErrorResponseAttributes();
    }

    public MatrixAppserviceAutoconfiguration(@NotNull MatrixAppserviceProperties matrixAppserviceProperties) {
        Intrinsics.checkNotNullParameter((Object)matrixAppserviceProperties, (String)"matrixAppserviceProperties");
        this.matrixAppserviceProperties = matrixAppserviceProperties;
    }
}

