/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.matrix.appservice.config;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.folivo.matrix.core.api.ErrorResponse;
import net.folivo.matrix.core.api.MatrixServerException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0017J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\nH\u0017\u00a8\u0006\f"}, d2={"Lnet/folivo/matrix/appservice/config/MatrixAppserviceExceptionHandler;", "", "()V", "handleAllOtherExceptions", "Lorg/springframework/http/ResponseEntity;", "Lnet/folivo/matrix/core/api/ErrorResponse;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleMatrixServerException", "Lnet/folivo/matrix/core/api/MatrixServerException;", "Companion", "matrix-spring-boot-rest-appservice"})
public class MatrixAppserviceExceptionHandler {
    private static final Logger LOG;
    public static final Companion Companion;

    @ExceptionHandler(value={Exception.class})
    @NotNull
    public ResponseEntity<ErrorResponse> handleAllOtherExceptions(@NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        LOG.error(exception.toString());
        return new ResponseEntity((Object)new ErrorResponse("M_UNKNOWN", exception.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={MatrixServerException.class})
    @NotNull
    public ResponseEntity<ErrorResponse> handleMatrixServerException(@NotNull MatrixServerException exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        return new ResponseEntity((Object)exception.getErrorResponse(), exception.getStatusCode());
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(Companion.getClass());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/folivo/matrix/appservice/config/MatrixAppserviceExceptionHandler$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "matrix-spring-boot-rest-appservice"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

