/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.matrix.appservice.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.folivo.matrix.appservice.api.AppserviceController;
import net.folivo.matrix.appservice.api.AppserviceHandler;
import net.folivo.matrix.appservice.api.DefaultAppserviceHandler;
import net.folivo.matrix.appservice.api.event.MatrixAppserviceEventService;
import net.folivo.matrix.appservice.api.room.MatrixAppserviceRoomService;
import net.folivo.matrix.appservice.api.user.MatrixAppserviceUserService;
import net.folivo.matrix.appservice.config.ErrorResponseAttributes;
import net.folivo.matrix.appservice.config.MatrixAppserviceAutoconfiguration;
import net.folivo.matrix.appservice.config.MatrixAppserviceExceptionHandler;
import net.folivo.matrix.appservice.config.MatrixAppserviceProperties;
import net.folivo.matrix.appservice.config.MatrixHomeServerAuthenticationConverter;
import net.folivo.matrix.appservice.config.MatrixHomeServerAuthenticationManager;
import net.folivo.matrix.core.api.ErrorResponse;
import net.folivo.matrix.restclient.MatrixClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.web.reactive.config.EnableWebFlux;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableWebFluxSecurity
@EnableWebFlux
@EnableConfigurationProperties(value={MatrixAppserviceProperties.class})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J(\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\b\u0010\u0016\u001a\u00020\u0017H\u0017J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/folivo/matrix/appservice/config/MatrixAppserviceAutoconfiguration;", "", "matrixAppserviceProperties", "Lnet/folivo/matrix/appservice/config/MatrixAppserviceProperties;", "(Lnet/folivo/matrix/appservice/config/MatrixAppserviceProperties;)V", "appserviceController", "Lnet/folivo/matrix/appservice/api/AppserviceController;", "appserviceHandler", "Lnet/folivo/matrix/appservice/api/AppserviceHandler;", "defaultAppserviceHandler", "matrixClient", "Lnet/folivo/matrix/restclient/MatrixClient;", "matrixAppserviceEventService", "Lnet/folivo/matrix/appservice/api/event/MatrixAppserviceEventService;", "matrixAppserviceUserService", "Lnet/folivo/matrix/appservice/api/user/MatrixAppserviceUserService;", "matrixAppserviceRoomService", "Lnet/folivo/matrix/appservice/api/room/MatrixAppserviceRoomService;", "errorResponseAttributes", "Lnet/folivo/matrix/appservice/config/ErrorResponseAttributes;", "matrixAppserviceExceptionHandler", "Lnet/folivo/matrix/appservice/config/MatrixAppserviceExceptionHandler;", "matrixHomeServerAuthenticationManager", "Lorg/springframework/security/authentication/ReactiveAuthenticationManager;", "springSecurityFilterChain", "Lorg/springframework/security/web/server/SecurityWebFilterChain;", "http", "Lorg/springframework/security/config/web/server/ServerHttpSecurity;", "Lnet/folivo/matrix/appservice/config/MatrixHomeServerAuthenticationManager;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "matrix-spring-boot-rest-appservice"})
public class MatrixAppserviceAutoconfiguration {
    private final MatrixAppserviceProperties matrixAppserviceProperties;

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AppserviceHandler defaultAppserviceHandler(@NotNull MatrixClient matrixClient, @NotNull MatrixAppserviceEventService matrixAppserviceEventService, @NotNull MatrixAppserviceUserService matrixAppserviceUserService, @NotNull MatrixAppserviceRoomService matrixAppserviceRoomService) {
        Intrinsics.checkParameterIsNotNull((Object)matrixClient, (String)"matrixClient");
        Intrinsics.checkParameterIsNotNull((Object)matrixAppserviceEventService, (String)"matrixAppserviceEventService");
        Intrinsics.checkParameterIsNotNull((Object)matrixAppserviceUserService, (String)"matrixAppserviceUserService");
        Intrinsics.checkParameterIsNotNull((Object)matrixAppserviceRoomService, (String)"matrixAppserviceRoomService");
        return new DefaultAppserviceHandler(matrixClient, matrixAppserviceEventService, matrixAppserviceUserService, matrixAppserviceRoomService);
    }

    @Bean
    @NotNull
    public AppserviceController appserviceController(@NotNull AppserviceHandler appserviceHandler) {
        Intrinsics.checkParameterIsNotNull((Object)appserviceHandler, (String)"appserviceHandler");
        return new AppserviceController(appserviceHandler);
    }

    @Bean
    @NotNull
    public MatrixAppserviceExceptionHandler matrixAppserviceExceptionHandler() {
        return new MatrixAppserviceExceptionHandler();
    }

    @Bean
    @Nullable
    public SecurityWebFilterChain springSecurityFilterChain(@NotNull ServerHttpSecurity http, @NotNull MatrixHomeServerAuthenticationManager matrixHomeServerAuthenticationManager, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull((Object)matrixHomeServerAuthenticationManager, (String)"matrixHomeServerAuthenticationManager");
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        AuthenticationWebFilter authenticationWebFilter = new AuthenticationWebFilter((ReactiveAuthenticationManager)matrixHomeServerAuthenticationManager);
        authenticationWebFilter.setServerAuthenticationConverter((ServerAuthenticationConverter)new MatrixHomeServerAuthenticationConverter());
        authenticationWebFilter.setSecurityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance());
        authenticationWebFilter.setAuthenticationFailureHandler(new ServerAuthenticationFailureHandler(objectMapper){
            final /* synthetic */ ObjectMapper $objectMapper;

            @NotNull
            public final Mono<Void> onAuthenticationFailure(WebFilterExchange webFilterExchange, AuthenticationException $noName_1) {
                return Mono.defer((Supplier)new Supplier<Mono<? extends T>>(webFilterExchange){
                    final /* synthetic */ WebFilterExchange $webFilterExchange;

                    @NotNull
                    public final Mono<ServerHttpResponse> get() {
                        WebFilterExchange webFilterExchange = this.$webFilterExchange;
                        Intrinsics.checkExpressionValueIsNotNull((Object)webFilterExchange, (String)"webFilterExchange");
                        ServerWebExchange serverWebExchange = webFilterExchange.getExchange();
                        Intrinsics.checkExpressionValueIsNotNull((Object)serverWebExchange, (String)"webFilterExchange.exchange");
                        return Mono.just((Object)serverWebExchange.getResponse());
                    }
                    {
                        this.$webFilterExchange = webFilterExchange;
                    }
                }).flatMap((Function)new Function<T, Mono<? extends R>>(this){
                    final /* synthetic */ springSecurityFilterChain.1 this$0;

                    @NotNull
                    public final Mono<Void> apply(@NotNull ServerHttpResponse response) {
                        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                        response.setStatusCode(HttpStatus.FORBIDDEN);
                        HttpHeaders httpHeaders = response.getHeaders();
                        Intrinsics.checkExpressionValueIsNotNull((Object)httpHeaders, (String)"response.headers");
                        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
                        DataBufferFactory dataBufferFactory = response.bufferFactory();
                        Intrinsics.checkExpressionValueIsNotNull((Object)dataBufferFactory, (String)"response.bufferFactory()");
                        DataBufferFactory dataBufferFactory2 = dataBufferFactory;
                        DataBuffer dataBuffer = dataBufferFactory2.wrap(this.this$0.$objectMapper.writeValueAsBytes((Object)new ErrorResponse("403", "NET.FOLIVO.MATRIX_FORBIDDEN")));
                        Intrinsics.checkExpressionValueIsNotNull((Object)dataBuffer, (String)"dataBufferFactory.wrap(\n\u2026                        )");
                        DataBuffer buffer = dataBuffer;
                        return response.writeWith((Publisher)Mono.just((Object)buffer)).doOnError((Consumer)new Consumer<Throwable>(buffer){
                            final /* synthetic */ DataBuffer $buffer;

                            public final void accept(Throwable it) {
                                DataBufferUtils.release((DataBuffer)this.$buffer);
                            }
                            {
                                this.$buffer = dataBuffer;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$objectMapper = objectMapper;
            }
        });
        ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.authorizeExchange().pathMatchers(new String[]{"/**"})).authenticated().and().csrf().disable().requestCache().disable().formLogin().disable().httpBasic().disable().logout().disable().addFilterAt((WebFilter)authenticationWebFilter, SecurityWebFiltersOrder.AUTHENTICATION).exceptionHandling();
        return http.build();
    }

    @Bean
    @NotNull
    public ReactiveAuthenticationManager matrixHomeServerAuthenticationManager() {
        return new MatrixHomeServerAuthenticationManager(this.matrixAppserviceProperties.getHsToken());
    }

    @Bean
    @NotNull
    public ErrorResponseAttributes errorResponseAttributes() {
        return new ErrorResponseAttributes();
    }

    public MatrixAppserviceAutoconfiguration(@NotNull MatrixAppserviceProperties matrixAppserviceProperties) {
        Intrinsics.checkParameterIsNotNull((Object)matrixAppserviceProperties, (String)"matrixAppserviceProperties");
        this.matrixAppserviceProperties = matrixAppserviceProperties;
    }
}

