/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.spring.matrix.bot.config;

import io.r2dbc.spi.ConnectionFactory;
import java.util.List;
import java.util.function.Supplier;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import liquibase.integration.spring.SpringLiquibase;
import net.folivo.spring.matrix.bot.config.MatrixBotProperties;
import net.folivo.spring.matrix.bot.config.MatrixIdReadingConverter;
import net.folivo.spring.matrix.bot.config.MatrixIdWritingConverter;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.r2dbc.ConnectionFactoryBuilder;
import org.springframework.boot.autoconfigure.r2dbc.EmbeddedDatabaseConnection;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.r2dbc.config.AbstractR2dbcConfiguration;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;

@Configuration
@EnableR2dbcRepositories(basePackages={"net.folivo.spring.matrix.bot"})
@EnableConfigurationProperties(value={MatrixBotProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0017J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J\u0012\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/folivo/spring/matrix/bot/config/MatrixBotDatabaseAutoconfiguration;", "Lorg/springframework/data/r2dbc/config/AbstractR2dbcConfiguration;", "botProperties", "Lnet/folivo/spring/matrix/bot/config/MatrixBotProperties;", "resourceLoader", "Lorg/springframework/core/io/ResourceLoader;", "(Lnet/folivo/spring/matrix/bot/config/MatrixBotProperties;Lorg/springframework/core/io/ResourceLoader;)V", "connectionFactory", "Lio/r2dbc/spi/ConnectionFactory;", "getCustomConverters", "", "", "liquibase", "Lliquibase/integration/spring/SpringLiquibase;", "liquibaseDatasource", "Ljavax/sql/DataSource;", "matrix-spring-boot-bot"})
public class MatrixBotDatabaseAutoconfiguration
extends AbstractR2dbcConfiguration {
    private final MatrixBotProperties botProperties;
    private final ResourceLoader resourceLoader;

    @Bean(value={"liquibaseDatasource"})
    @NotNull
    public DataSource liquibaseDatasource() {
        DataSource dataSource = this.botProperties.getMigration().initializeDataSourceBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)dataSource, (String)"botProperties.migration.\u2026taSourceBuilder().build()");
        return dataSource;
    }

    @Bean
    @NotNull
    public SpringLiquibase liquibase(@Qualifier(value="liquibaseDatasource") @NotNull DataSource liquibaseDatasource) {
        Intrinsics.checkNotNullParameter((Object)liquibaseDatasource, (String)"liquibaseDatasource");
        SpringLiquibase springLiquibase = new SpringLiquibase();
        boolean bl = false;
        boolean bl2 = false;
        SpringLiquibase $this$apply = springLiquibase;
        boolean bl3 = false;
        $this$apply.setChangeLog("classpath:db/changelog/net.folivo.matrix.bot.changelog-master.yml");
        $this$apply.setDataSource(liquibaseDatasource);
        return springLiquibase;
    }

    @Bean
    @NotNull
    public ConnectionFactory connectionFactory() {
        ConnectionFactory connectionFactory2 = ConnectionFactoryBuilder.of((R2dbcProperties)this.botProperties.getDatabase(), (Supplier)new Supplier<EmbeddedDatabaseConnection>(this){
            final /* synthetic */ MatrixBotDatabaseAutoconfiguration this$0;

            public final EmbeddedDatabaseConnection get() {
                return EmbeddedDatabaseConnection.get((ClassLoader)MatrixBotDatabaseAutoconfiguration.access$getResourceLoader$p(this.this$0).getClassLoader());
            }
            {
                this.this$0 = matrixBotDatabaseAutoconfiguration;
            }
        }).build();
        Intrinsics.checkNotNullExpressionValue((Object)connectionFactory2, (String)"ConnectionFactoryBuilder\u2026r) }\n            .build()");
        return connectionFactory2;
    }

    @NotNull
    protected List<Object> getCustomConverters() {
        return CollectionsKt.mutableListOf((Object[])new Object[]{new MatrixIdReadingConverter(), new MatrixIdWritingConverter()});
    }

    public MatrixBotDatabaseAutoconfiguration(@NotNull MatrixBotProperties botProperties, @NotNull ResourceLoader resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)botProperties, (String)"botProperties");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        this.botProperties = botProperties;
        this.resourceLoader = resourceLoader;
    }

    public static final /* synthetic */ ResourceLoader access$getResourceLoader$p(MatrixBotDatabaseAutoconfiguration $this) {
        return $this.resourceLoader;
    }
}

