/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.matrix.bot.config;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.folivo.matrix.bot.client.ClientMemberEventHandler;
import net.folivo.matrix.bot.client.MatrixClientBot;
import net.folivo.matrix.bot.config.MatrixBotProperties;
import net.folivo.matrix.bot.event.MatrixEventHandler;
import net.folivo.matrix.bot.membership.MembershipChangeHandler;
import net.folivo.matrix.bot.util.BotServiceHelper;
import net.folivo.matrix.restclient.MatrixClient;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="matrix.bot", name={"mode"}, havingValue="CLIENT", matchIfMissing=true)
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0012"}, d2={"Lnet/folivo/matrix/bot/config/MatrixClientBotAutoconfiguration;", "", "()V", "clientBotServiceHelper", "Lnet/folivo/matrix/bot/util/BotServiceHelper;", "botProperties", "Lnet/folivo/matrix/bot/config/MatrixBotProperties;", "clientMemberEventHandler", "Lnet/folivo/matrix/bot/client/ClientMemberEventHandler;", "membershipChangeHandler", "Lnet/folivo/matrix/bot/membership/MembershipChangeHandler;", "matrixClientBot", "Lnet/folivo/matrix/bot/client/MatrixClientBot;", "matrixClient", "Lnet/folivo/matrix/restclient/MatrixClient;", "eventHandler", "", "Lnet/folivo/matrix/bot/event/MatrixEventHandler;", "matrix-spring-boot-bot"})
public class MatrixClientBotAutoconfiguration {
    @Bean
    @NotNull
    public ClientMemberEventHandler clientMemberEventHandler(@NotNull MembershipChangeHandler membershipChangeHandler) {
        Intrinsics.checkNotNullParameter((Object)membershipChangeHandler, (String)"membershipChangeHandler");
        return new ClientMemberEventHandler(membershipChangeHandler);
    }

    @Bean
    @NotNull
    public MatrixClientBot matrixClientBot(@NotNull MatrixClient matrixClient, @NotNull List<? extends MatrixEventHandler> eventHandler, @NotNull MembershipChangeHandler membershipChangeHandler, @NotNull MatrixBotProperties botProperties) {
        Intrinsics.checkNotNullParameter((Object)matrixClient, (String)"matrixClient");
        Intrinsics.checkNotNullParameter(eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter((Object)membershipChangeHandler, (String)"membershipChangeHandler");
        Intrinsics.checkNotNullParameter((Object)botProperties, (String)"botProperties");
        return new MatrixClientBot(matrixClient, eventHandler, membershipChangeHandler, botProperties);
    }

    @Bean
    @NotNull
    public BotServiceHelper clientBotServiceHelper(@NotNull MatrixBotProperties botProperties) {
        Intrinsics.checkNotNullParameter((Object)botProperties, (String)"botProperties");
        boolean bl = false;
        bl = false;
        return new BotServiceHelper(botProperties, SetsKt.emptySet(), SetsKt.emptySet());
    }
}

