/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.matrix.bot.appservice.event;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.folivo.matrix.appservice.api.event.MatrixAppserviceEventService;
import net.folivo.matrix.bot.appservice.event.DefaultMatrixAppserviceEventService;
import net.folivo.matrix.bot.appservice.event.EventTransaction;
import net.folivo.matrix.bot.appservice.event.EventTransactionRepository;
import net.folivo.matrix.bot.handler.MatrixEventHandler;
import net.folivo.matrix.core.model.events.Event;
import net.folivo.matrix.core.model.events.StateEvent;
import net.folivo.matrix.core.model.events.m.room.message.MessageEvent;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/folivo/matrix/bot/appservice/event/DefaultMatrixAppserviceEventService;", "Lnet/folivo/matrix/appservice/api/event/MatrixAppserviceEventService;", "eventTransactionRepository", "Lnet/folivo/matrix/bot/appservice/event/EventTransactionRepository;", "eventHandler", "", "Lnet/folivo/matrix/bot/handler/MatrixEventHandler;", "(Lnet/folivo/matrix/bot/appservice/event/EventTransactionRepository;Ljava/util/List;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "delegateEventHandling", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "event", "Lnet/folivo/matrix/core/model/events/Event;", "roomId", "", "eventProcessingState", "Lnet/folivo/matrix/appservice/api/event/MatrixAppserviceEventService$EventProcessingState;", "tnxId", "eventIdOrType", "processEvent", "saveEventProcessed", "matrix-spring-boot-bot"})
public final class DefaultMatrixAppserviceEventService
implements MatrixAppserviceEventService {
    private final Logger logger;
    private final EventTransactionRepository eventTransactionRepository;
    private final List<MatrixEventHandler> eventHandler;

    @NotNull
    public Mono<MatrixAppserviceEventService.EventProcessingState> eventProcessingState(@NotNull String tnxId, @NotNull String eventIdOrType) {
        Intrinsics.checkParameterIsNotNull((Object)tnxId, (String)"tnxId");
        Intrinsics.checkParameterIsNotNull((Object)eventIdOrType, (String)"eventIdOrType");
        Mono mono = this.eventTransactionRepository.findByTnxIdAndEventIdElseType(tnxId, eventIdOrType).map((Function)eventProcessingState.1.INSTANCE).switchIfEmpty(Mono.just((Object)MatrixAppserviceEventService.EventProcessingState.NOT_PROCESSED));
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"eventTransactionReposito\u2026singState.NOT_PROCESSED))");
        return mono;
    }

    @NotNull
    public Mono<Void> saveEventProcessed(@NotNull String tnxId, @NotNull String eventIdOrType) {
        Intrinsics.checkParameterIsNotNull((Object)tnxId, (String)"tnxId");
        Intrinsics.checkParameterIsNotNull((Object)eventIdOrType, (String)"eventIdOrType");
        Mono mono = this.eventTransactionRepository.save(new EventTransaction(tnxId, eventIdOrType)).then();
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"eventTransactionReposito\u2026)\n                .then()");
        return mono;
    }

    @NotNull
    public Mono<Void> processEvent(@NotNull Event<?> event) {
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        Event<?> event2 = event;
        return event2 instanceof MessageEvent ? this.delegateEventHandling(event, ((MessageEvent)event).getRoomId()) : (event2 instanceof StateEvent ? this.delegateEventHandling(event, ((StateEvent)event).getRoomId()) : DefaultMatrixAppserviceEventService.delegateEventHandling$default(this, event, null, 2, null));
    }

    private final Mono<Void> delegateEventHandling(Event<?> event, String roomId) {
        this.logger.debug("delegate event " + event + " to event handlers");
        Mono mono = Flux.fromIterable((Iterable)this.eventHandler).filter((Predicate)new Predicate<MatrixEventHandler>(event){
            final /* synthetic */ Event $event;

            public final boolean test(MatrixEventHandler it) {
                return it.supports(this.$event.getClass());
            }
            {
                this.$event = event;
            }
        }).flatMap(new Function<T, Publisher<? extends R>>(event, roomId){
            final /* synthetic */ Event $event;
            final /* synthetic */ String $roomId;

            @NotNull
            public final Mono<Void> apply(MatrixEventHandler it) {
                return it.handleEvent(this.$event, this.$roomId);
            }
            {
                this.$event = event;
                this.$roomId = string;
            }
        }).then();
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"Flux.fromIterable(eventH\u2026\n                }.then()");
        return mono;
    }

    static /* synthetic */ Mono delegateEventHandling$default(DefaultMatrixAppserviceEventService defaultMatrixAppserviceEventService, Event event, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return defaultMatrixAppserviceEventService.delegateEventHandling(event, string);
    }

    public DefaultMatrixAppserviceEventService(@NotNull EventTransactionRepository eventTransactionRepository, @NotNull List<? extends MatrixEventHandler> eventHandler) {
        Intrinsics.checkParameterIsNotNull((Object)eventTransactionRepository, (String)"eventTransactionRepository");
        Intrinsics.checkParameterIsNotNull(eventHandler, (String)"eventHandler");
        this.eventTransactionRepository = eventTransactionRepository;
        this.eventHandler = eventHandler;
        this.logger = LoggerFactory.getLogger(DefaultMatrixAppserviceEventService.class);
    }
}

