/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapLegProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapProductDescriptor;
import net.finmath.modelling.descriptor.xmlparser.FPMLParser;
import net.finmath.modelling.productfactory.InterestRateAnalyticProductFactory;
import net.finmath.smartcontract.model.MarginResult;
import net.finmath.smartcontract.model.ValueResult;
import net.finmath.smartcontract.oracle.SmartDerivativeContractSettlementOracle;
import net.finmath.smartcontract.oracle.interestrates.ValuationOraclePlainSwap;
import net.finmath.smartcontract.product.SmartDerivativeContractDescriptor;
import net.finmath.smartcontract.product.xml.SDCXMLParser;
import net.finmath.smartcontract.simulation.scenariogeneration.IRMarketDataParser;
import net.finmath.smartcontract.simulation.scenariogeneration.IRMarketDataSet;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarginCalculator {
    private static final Logger logger = LoggerFactory.getLogger(MarginCalculator.class);
    private final DoubleUnaryOperator rounding;

    public MarginCalculator(DoubleUnaryOperator rounding) {
        this.rounding = rounding;
    }

    public MarginCalculator() {
        this(x -> (double)Math.round(x * 1000.0) / 1000.0);
    }

    public MarginResult getValue(String marketDataStart, String marketDataEnd, String productData) throws Exception {
        SmartDerivativeContractDescriptor productDescriptor = SDCXMLParser.parse(productData);
        List<IRMarketDataSet> marketDataSetsStart = IRMarketDataParser.getScenariosFromJsonString(marketDataStart);
        Validate.isTrue((marketDataSetsStart.size() == 1 ? 1 : 0) != 0, (String)"Parameter marketDataStart should be only a single market data set", (Object[])new Object[0]);
        List<IRMarketDataSet> marketDataSetsEnd = IRMarketDataParser.getScenariosFromJsonString(marketDataEnd);
        Validate.isTrue((marketDataSetsEnd.size() == 1 ? 1 : 0) != 0, (String)"Parameter marketDataStart should be only a single market data set", (Object[])new Object[0]);
        String ownerPartyID = productDescriptor.getUnderlyingReceiverPartyID();
        InterestRateSwapProductDescriptor underlying = (InterestRateSwapProductDescriptor)new FPMLParser(ownerPartyID, "forward-EUR-6M", "discount-EUR-OIS").getProductDescriptor(productDescriptor.getUnderlying());
        LocalDateTime startDate = marketDataSetsStart.get(0).getDate();
        LocalDateTime endDate = marketDataSetsEnd.get(0).getDate();
        double value = this.calculateMargin(List.of(marketDataSetsStart.get(0), marketDataSetsEnd.get(0)), startDate, endDate, productDescriptor, underlying);
        String currency = "EUR";
        LocalDateTime valuationDate = LocalDateTime.now();
        return new MarginResult().value(BigDecimal.valueOf(this.rounding.applyAsDouble(value))).currency(currency).valuationDate(valuationDate.toString());
    }

    public ValueResult getValue(String marketData, String productData) throws Exception {
        SmartDerivativeContractDescriptor productDescriptor = SDCXMLParser.parse(productData);
        List<IRMarketDataSet> marketDataSets = IRMarketDataParser.getScenariosFromJsonString(marketData);
        Validate.isTrue((marketDataSets.size() == 1 ? 1 : 0) != 0, (String)"Parameter marketData should be only a single market data set", (Object[])new Object[0]);
        String ownerPartyID = productDescriptor.getUnderlyingReceiverPartyID();
        InterestRateSwapProductDescriptor underlying = (InterestRateSwapProductDescriptor)new FPMLParser(ownerPartyID, "forward-EUR-6M", "discount-EUR-OIS").getProductDescriptor(productDescriptor.getUnderlying());
        LocalDateTime endDate = marketDataSets.get(0).getDate();
        double value = this.calculateMargin(marketDataSets, null, endDate, productDescriptor, underlying);
        String currency = "EUR";
        LocalDateTime valuationDate = LocalDateTime.now();
        return new ValueResult().value(BigDecimal.valueOf(value)).currency(currency).valuationDate(valuationDate.toString());
    }

    private double calculateMargin(List<IRMarketDataSet> marketDataSets, LocalDateTime startDate, LocalDateTime endState, SmartDerivativeContractDescriptor productDescriptor, InterestRateSwapProductDescriptor underlying) throws Exception {
        LocalDate referenceDate = productDescriptor.getTradeDate().toLocalDate();
        InterestRateSwapLegProductDescriptor legReceiver = (InterestRateSwapLegProductDescriptor)underlying.getLegReceiver();
        InterestRateSwapLegProductDescriptor legPayer = (InterestRateSwapLegProductDescriptor)underlying.getLegPayer();
        InterestRateAnalyticProductFactory productFactory = new InterestRateAnalyticProductFactory(referenceDate);
        DescribedProduct legReceiverProduct = productFactory.getProductFromDescriptor((ProductDescriptor)legReceiver);
        DescribedProduct legPayerProduct = productFactory.getProductFromDescriptor((ProductDescriptor)legPayer);
        Swap swap = new Swap((AnalyticProduct)((SwapLeg)legReceiverProduct), (AnalyticProduct)((SwapLeg)legPayerProduct));
        ValuationOraclePlainSwap oracle = new ValuationOraclePlainSwap(swap, 1.0, marketDataSets);
        SmartDerivativeContractSettlementOracle margin = new SmartDerivativeContractSettlementOracle(oracle);
        double marginCall = 0.0;
        marginCall = Objects.isNull(startDate) ? oracle.getValue(endState, endState).doubleValue() : margin.getMargin(startDate, endState).doubleValue();
        return marginCall;
    }
}

