/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.scenariogeneration;

import java.time.LocalDateTime;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationDatapoint;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationParser;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProvider;

public class IRMarketDataSet {
    LocalDateTime scenarioDate;
    Set<CalibrationDatapoint> curveDataPointSet;

    public IRMarketDataSet(Set<CalibrationDatapoint> curveDataPointSet, LocalDateTime scenarioDate) {
        this.scenarioDate = scenarioDate;
        this.curveDataPointSet = curveDataPointSet;
    }

    public IRMarketDataSet getScaled(double scaleFactor) {
        Set<CalibrationDatapoint> scaledSet = this.curveDataPointSet.stream().map(point -> point.getClonedScaled(scaleFactor)).collect(Collectors.toSet());
        return new IRMarketDataSet(scaledSet, this.scenarioDate);
    }

    public Stream<CalibrationSpecProvider> getDataAsCalibrationDataPointStream(CalibrationParser parser) {
        return parser.parse(this.curveDataPointSet.stream());
    }

    public Set<CalibrationDatapoint> getDataPoints() {
        return this.curveDataPointSet;
    }

    public LocalDateTime getDate() {
        return this.scenarioDate;
    }
}

